/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Set;

public class RandomUtils {
    public static SecureRandom getRandom() {
        return new SecureRandom();
    }

    public static int getRandomInt(int max, SecureRandom random) {
        return random.nextInt(max);
    }

    public static int getRandomInt(int max) {
        return RandomUtils.getRandomInt(max, RandomUtils.getRandom());
    }

    private static <E> E getRandomElement(Set<E> set, SecureRandom random) {
        int rn = RandomUtils.getRandomInt(set.size(), random);
        int i = 0;
        for (E e : set) {
            if (i == rn) {
                return e;
            }
            ++i;
        }
        return null;
    }

    public static <E> Set<E> getRandomElement(Set<E> set, int count) {
        if (count == 0) {
            return set;
        }
        if (set.size() <= count) {
            return set;
        }
        HashSet<E> newSet = new HashSet<E>(16);
        SecureRandom random = RandomUtils.getRandom();
        while (newSet.size() < count) {
            newSet.add(RandomUtils.getRandomElement(set, random));
        }
        return newSet;
    }

    public static String generateRandomCode(int codeLength, Set<String> existCodeSet) {
        String newCode;
        if (codeLength <= 0) {
            codeLength = 6;
        }
        StringBuilder sb = new StringBuilder().append('1');
        for (int i = 0; i < codeLength - 1; ++i) {
            sb.append('0');
        }
        int min = Integer.parseInt(sb.toString());
        int max = Integer.parseInt(sb.append('0').toString());
        SecureRandom random = RandomUtils.getRandom();
        while ((newCode = String.valueOf(RandomUtils.getRandomInt(max - min + min + 1, random))).length() != codeLength || !existCodeSet.add(newCode)) {
        }
        return newCode;
    }
}

