/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.scm.common.util.cal.CalImpl;
import kd.scm.common.util.cal.CalculateUtils;

public class SrcCalImpl
extends CalImpl {
    private static final String PRICE_UOM = "price_uom";

    public void calByEntryTaxAmountChange(IDataModel datamodel, String entryKey) {
        this.calEntryTaxPriceByTaxAmount(datamodel, entryKey);
        this.calEntryPriceByTaxPrice(datamodel, entryKey);
        this.calEntryDiscountRate(datamodel, entryKey);
        this.calEntryDiscountAmount(datamodel, entryKey);
        this.calEntryTax(datamodel, entryKey);
        this.calEntryAmount(datamodel, entryKey);
        this.calEntryActualPrice(datamodel, entryKey);
        this.calEntryActualTaxPrice(datamodel, entryKey);
        this.calSum(datamodel, entryKey);
    }

    public void proChanged(IDataModel datamodel, String entryKey, String propertyName) {
        if (this.getDISCOUNTAMOUNT().equals(propertyName) || this.getDISCOUNTRATE().equals(propertyName)) {
            // empty if block
        }
        super.proChanged(datamodel, entryKey, propertyName);
        if (PRICE_UOM.equals(propertyName)) {
            this.needChange(false);
            this.calByEntryQtyChange(datamodel, entryKey);
            this.needChange(true);
        } else if ("currency".equals(propertyName)) {
            this.needChange(false);
            this.setPricePrecisionByCurrcy(datamodel, entryKey);
            this.needChange(true);
        }
    }

    public void setPricePrecisionByCurrcy(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.getTAXTYPE());
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        boolean containTax = this.isContainTax(taxType);
        boolean isPriceChanged = false;
        BigDecimal oldPrice = BigDecimal.ZERO;
        if (containTax) {
            BigDecimal taxPrice = this.getEntryBigDecimalValue(datamodel, index, this.getTAXPRICE());
            oldPrice = taxPrice;
            if (oldPrice.compareTo(taxPrice = taxPrice.setScale(this.getPricePrecision(datamodel, entryKey), RoundingMode.HALF_UP)) != 0) {
                isPriceChanged = true;
            }
            datamodel.setValue(this.getTAXPRICE(), (Object)taxPrice, index);
        } else {
            BigDecimal price = this.getEntryBigDecimalValue(datamodel, index, this.getPRICE());
            oldPrice = price;
            if (oldPrice.compareTo(price = price.setScale(this.getPricePrecision(datamodel, entryKey), RoundingMode.HALF_UP)) != 0) {
                isPriceChanged = true;
            }
            datamodel.setValue(this.getPRICE(), (Object)price, index);
        }
        if (!isPriceChanged) {
            this.calByEntryQtyChange(datamodel, entryKey);
        }
    }

    public void calByEntryQtyChange(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.getTAXTYPE());
        boolean containTax = this.isContainTax(taxType);
        if (containTax) {
            this.calEntryDiscountAmount(datamodel, entryKey);
            this.calEntryTaxAmount(datamodel, entryKey);
            this.calEntryTax(datamodel, entryKey);
            this.calEntryAmount(datamodel, entryKey);
        } else {
            this.calEntryDiscountAmount(datamodel, entryKey);
            this.calEntryAmount(datamodel, entryKey);
            this.calEntryTax(datamodel, entryKey);
            this.calEntryTaxAmount(datamodel, entryKey);
        }
        this.calSum(datamodel, entryKey);
    }

    public void calEntryPriceByAmount(IDataModel datamodel, String entryKey) {
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal amount = this.getEntryBigDecimalValue(datamodel, index, this.getAMOUNT());
        BigDecimal discountRate = this.getEntryBigDecimalValue(datamodel, index, this.getDISCOUNTRATE());
        BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.getQTY());
        BigDecimal price = BigDecimal.ZERO;
        int scale = this.getPricePrecision(datamodel, entryKey);
        price = CalculateUtils.calPrice((BigDecimal)amount, (BigDecimal)qty, (BigDecimal)discountRate, (int)scale);
        price = price.setScale(scale, 4);
        datamodel.setValue(this.getPRICE(), (Object)price, index);
    }

    public void calEntryTaxAmount(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.getTAXTYPE());
        boolean containTax = this.isContainTax(taxType);
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal taxAmount = BigDecimal.ZERO;
        int scale = this.getAmtPrecision(datamodel, entryKey);
        if (containTax) {
            BigDecimal price_uom;
            BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.getQTY());
            BigDecimal taxPrice = this.getEntryBigDecimalValue(datamodel, index, this.getTAXPRICE());
            BigDecimal discountRate = this.getEntryBigDecimalValue(datamodel, index, this.getDISCOUNTRATE());
            taxAmount = CalculateUtils.calTaxAmountByDiscountPercent((BigDecimal)qty, (BigDecimal)taxPrice, (BigDecimal)discountRate, (int)scale);
            Object price_uomObj = this.getEntryObject(datamodel, index, PRICE_UOM);
            BigDecimal bigDecimal = price_uom = null == price_uomObj ? BigDecimal.ZERO : new BigDecimal(String.valueOf(price_uomObj));
            if (price_uom.compareTo(BigDecimal.ZERO) > 0) {
                taxAmount = taxAmount.divide(price_uom, scale, RoundingMode.HALF_UP);
            }
        } else {
            BigDecimal amount = this.getEntryBigDecimalValue(datamodel, index, this.getAMOUNT());
            BigDecimal tax = this.getEntryBigDecimalValue(datamodel, index, this.getTAX());
            taxAmount = CalculateUtils.calTaxAmount((BigDecimal)amount, (BigDecimal)tax, (int)scale);
        }
        datamodel.setValue(this.getTAXAMOUNT(), (Object)taxAmount, index);
        datamodel.setValue("pkgtaxamount", (Object)taxAmount, index);
    }

    public void calEntryAmount(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.getTAXTYPE());
        boolean containTax = this.isContainTax(taxType);
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal amount = BigDecimal.ZERO;
        int scale = this.getAmtPrecision(datamodel, entryKey);
        if (containTax) {
            BigDecimal taxAmount = this.getEntryBigDecimalValue(datamodel, index, this.getTAXAMOUNT());
            BigDecimal tax = this.getEntryBigDecimalValue(datamodel, index, this.getTAX());
            amount = CalculateUtils.calAmountInTax((BigDecimal)taxAmount, (BigDecimal)tax, (int)scale);
        } else {
            BigDecimal price_uom;
            BigDecimal discountRate = this.getEntryBigDecimalValue(datamodel, index, this.getDISCOUNTRATE());
            BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.getQTY());
            BigDecimal price = this.getEntryBigDecimalValue(datamodel, index, this.getPRICE());
            amount = CalculateUtils.calAmountByDiscountPercent((BigDecimal)qty, (BigDecimal)price, (BigDecimal)discountRate, (int)scale);
            Object price_uomObj = this.getEntryObject(datamodel, index, PRICE_UOM);
            BigDecimal bigDecimal = price_uom = null == price_uomObj ? BigDecimal.ZERO : new BigDecimal(String.valueOf(price_uomObj));
            if (price_uom.compareTo(BigDecimal.ZERO) > 0) {
                amount = amount.divide(price_uom, scale, RoundingMode.HALF_UP);
            }
        }
        datamodel.setValue(this.getAMOUNT(), (Object)amount, index);
        datamodel.setValue("pkgamount", (Object)amount, index);
    }

    protected int getAmtPrecision(IDataModel datamodel, String entryKey) {
        int amtPrecision = 6;
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        Object currency = datamodel.getValue("currency", index);
        if (currency instanceof DynamicObject) {
            DynamicObject curr = (DynamicObject)currency;
            amtPrecision = curr.getInt("amtprecision");
        }
        return amtPrecision;
    }

    protected int getPricePrecision(IDataModel datamodel, String entryKey) {
        int pricePrecision = 10;
        return pricePrecision;
    }

    protected void calSum(IDataModel datamodel, String entryKey) {
        this.calSumAmount(datamodel, entryKey);
        this.calSumTaxAmount(datamodel, entryKey);
        String entityKey = datamodel.getDataEntityType().getName();
        if (!"src_contract".equals(entityKey)) {
            this.calSumTax(datamodel, entryKey);
            this.calSumQty(datamodel, entryKey);
            return;
        }
    }
}

