/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.BizLog;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.enums.BidTypeEnums;
import kd.scm.pds.common.enums.MyTaskStatusEnums;
import kd.scm.pds.common.mytask.SrcMyTaskFacade;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.OrgAndUserUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SendMessageUtils;

public class SrcClarifyUtils {
    public static void openClarify(IFormView currView, long projectId, boolean showTips) {
        QFilter qFilter = new QFilter("project.id", "=", (Object)projectId).and("bidder", "=", (Object)RequestContext.get().getCurrUserId()).and("isclarify", "=", (Object)"0");
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_memberclarify", (String)"project", (QFilter[])new QFilter[]{qFilter});
        if (rows == null || rows.length == 0) {
            if (showTips) {
                currView.showTipNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5df2\u6f84\u6e05\uff0c\u65e0\u9700\u518d\u6f84\u6e05\u3002", (String)"SrcClarifyUtils_0", (String)"scm-pds-common", (Object[])new Object[0]));
            }
            return;
        }
        HashMap<String, Object> paraMap = new HashMap<String, Object>(16);
        paraMap.put("billid", rows[0].getString("id"));
        paraMap.put("projectid", rows[0].getString("project.id"));
        paraMap.put("billno", rows[0].getString("project.billno"));
        paraMap.put("bidname", rows[0].getString("project.bidname"));
        OpenFormUtils.openDynamicPage(currView, "pds_benefitclarify", ShowType.Modal, paraMap, null);
    }

    public static Map<String, Object> notifyAllMember(IFormView currView, long projectId, String compkey) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        if (StringUtils.equals((CharSequence)"src_project_reference", (CharSequence)compkey)) {
            SrcClarifyUtils.addScorerToReference(currView, projectId, compkey);
        }
        SrcClarifyUtils.setClarifystatusByHasclarify(projectId);
        QFilter qFilter = new QFilter("project", "=", (Object)projectId).and("isnotify", "=", (Object)"0").and("bidder.id", ">", (Object)0L);
        DynamicObject[] memberObjs = BusinessDataServiceHelper.load((String)"src_memberclarify", (String)"project,bidder,isnotify,number", (QFilter[])new QFilter[]{qFilter});
        if (memberObjs == null || memberObjs.length == 0) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u901a\u77e5\u7684\u4eba\u5458, \u53ef\u80fd\u539f\u56e0:1)\u6240\u6709\u4eba\u5458\u90fd\u5df2\u901a\u77e5\u4e86; 2)\u60a8\u5c1a\u672a\u5f55\u5165\u76f8\u5173\u4eba\u5458; 3)\u60a8\u5f55\u5165\u7684\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"SrcClarifyUtils_1", (String)"scm-pds-common", (Object[])new Object[0]));
            return resultMap;
        }
        String billNo = memberObjs[0].getString("project.billno");
        String bidName = memberObjs[0].getString("project.bidname");
        String title = String.format(ResManager.loadKDString((String)"\u60a8\u6709\u5f85\u6f84\u6e05\u7684\u9879\u76ee(%1$s),\u8bf7\u53ca\u65f6\u8fdb\u884c\u6f84\u6e05\u3002", (String)"SrcClarifyUtils_2", (String)"scm-pds-common", (Object[])new Object[0]), billNo);
        String content = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u7f16\u53f7\uff1a%1$s\uff0c\u9879\u76ee\u540d\u79f0\uff1a%2$s", (String)"SrcClarifyUtils_3", (String)"scm-pds-common", (Object[])new Object[0]), billNo, bidName);
        int count = 0;
        StringBuilder sb = new StringBuilder();
        HashSet<Long> bidderIds = new HashSet<Long>(16);
        for (DynamicObject memberObj : memberObjs) {
            memberObj.set("isnotify", (Object)"1");
            long bidderId = memberObj.getLong("bidder.id");
            if (!bidderIds.add(bidderId)) continue;
            StringBuilder userSb = new StringBuilder();
            userSb.append("bidder");
            userSb.append('.');
            userSb.append("id");
            SendMessageUtils.sendMessage(memberObj.getLong(userSb.toString()), (Long)memberObj.getPkValue(), "pds_benefitclarify", title, content);
            sb.append(memberObj.getString("bidder.name"));
            sb.append(',');
            ++count;
        }
        SaveServiceHelper.save((DynamicObject[])memberObjs);
        resultMap.put("succed", Boolean.TRUE);
        StringBuilder msgSb = new StringBuilder();
        msgSb.append(String.format(ResManager.loadKDString((String)"\u5171\u901a\u77e5\uff1a%1$s\u4eba\uff1a%2$s", (String)"SrcClarifyUtils_4", (String)"scm-pds-common", (Object[])new Object[0]), count, sb.toString().substring(0, sb.length() - 1)));
        resultMap.put("message", msgSb);
        return resultMap;
    }

    public static Map<String, Object> getClarifyStatus(long projectId, long userId) {
        DynamicObject[] rows;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("isclarify", Boolean.TRUE);
        resultMap.put("isbenifit", Boolean.FALSE);
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5df2\u8fdb\u884c\u5229\u76ca\u5173\u7cfb\u6f84\u6e05\uff0c\u4e14\u65e0\u5229\u76ca\u51b2\u7a81\u3002", (String)"SrcClarifyUtils_5", (String)"scm-pds-common", (Object[])new Object[0]));
        QFilter qFilter = new QFilter("project.id", "=", (Object)projectId);
        qFilter = qFilter.and(new QFilter("entrystatus", "=", (Object)MyTaskStatusEnums.NOTSTARTED.getValue()).or("entrystatus", "=", (Object)MyTaskStatusEnums.GRANTED.getValue()));
        if (userId > 0L) {
            qFilter = qFilter.and("bidder.id", "=", (Object)userId);
        }
        if ((rows = BusinessDataServiceHelper.load((String)"src_memberclarify", (String)"bidder,isclarify,isbenifit", (QFilter[])new QFilter[]{qFilter = qFilter.and(new QFilter("isclarify", "=", (Object)"0").or("isbenifit", "=", (Object)"1"))})) == null || rows.length == 0) {
            return resultMap;
        }
        StringBuilder sb = new StringBuilder();
        HashSet<String> noclarifySet = new HashSet<String>();
        HashSet<String> isbenifitSet = new HashSet<String>();
        SrcClarifyUtils.getBidderSet(rows, noclarifySet, isbenifitSet);
        boolean isSuccess = true;
        if (noclarifySet.size() > 0) {
            resultMap.put("isclarify", Boolean.FALSE);
            sb = sb.append(String.format(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u8fd9\u4e9b\u4eba\u5458\u672a\u6f84\u6e05\uff1a%1$s", (String)"SrcClarifyUtils_6", (String)"scm-pds-common", (Object[])new Object[0]), SrcClarifyUtils.getBidderName(noclarifySet)));
            isSuccess = false;
        }
        if (isbenifitSet.size() > 0) {
            resultMap.put("isbenifit", Boolean.TRUE);
            if (sb.toString().trim().length() > 0) {
                sb = sb.append(',');
            }
            sb = sb.append(String.format(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u8fd9\u4e9b\u4eba\u5458\u6709\u5229\u76ca\u51b2\u7a81\uff1a%1$s", (String)"SrcClarifyUtils_7", (String)"scm-pds-common", (Object[])new Object[0]), SrcClarifyUtils.getBidderName(isbenifitSet)));
            isSuccess = true;
        }
        resultMap.put("succed", isSuccess);
        resultMap.put("message", sb.toString());
        return resultMap;
    }

    public static void getBidderSet(DynamicObject[] rows, Set<String> noclarifySet, Set<String> isbenifitSet) {
        for (DynamicObject row : rows) {
            if (!row.getBoolean("isclarify")) {
                noclarifySet.add(row.getString("bidder.name"));
            }
            if (!StringUtils.equals((CharSequence)row.getString("isbenifit"), (CharSequence)"1")) continue;
            isbenifitSet.add(row.getString("bidder.name"));
        }
    }

    public static String getBidderName(Set<String> bidderSet) {
        if (bidderSet == null || bidderSet.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String bidder : bidderSet) {
            sb = sb.append(bidder).append(',');
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static long getMemberSet(long projectId, Set<String> memberSet, String compkey) {
        long billId;
        DynamicObject billObj = QueryServiceHelper.queryOne((String)compkey, (String)"id", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)String.valueOf(projectId)).and("entitykey", "=", (Object)compkey)});
        if (billObj == null) {
            DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)compkey);
            ORM.create().setPrimaryKey(newObj);
            newObj.set("parentid", (Object)projectId);
            if ("src_project_man".equals(compkey)) {
                newObj.set("pentitykey", (Object)"src_project");
            } else {
                newObj.set("pentitykey", (Object)"src_bidopen");
            }
            newObj.set("entitykey", (Object)compkey);
            newObj.set("origin", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObj});
            billId = PdsCommonUtils.object2Long(newObj.getPkValue());
        } else {
            billId = billObj.getLong("id");
        }
        QFilter qFilter = new QFilter("billid", "=", (Object)billId);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_memberclarify", (String)"bizrole.id,bidder.id", (QFilter[])new QFilter[]{qFilter});
        Set set = rows.stream().map(e -> e.getString("bizrole.id") + '_' + e.getString("bidder.id")).collect(Collectors.toSet());
        memberSet.addAll(set);
        return billId;
    }

    public static boolean addScorerToReference(IFormView currView, long projectId, String compkey) {
        String entityName = "src_bidopenconfig";
        if (currView.getEntityId().equals("src_aptitudeconfig")) {
            entityName = "src_aptitudeconfigf7";
        } else if (currView.getEntityId().equals("src_aptitudeconfig2")) {
            entityName = "src_aptitudeconfig2f7";
        }
        return SrcClarifyUtils.addScorerToReference(entityName, projectId, compkey);
    }

    public static boolean addScorerToReference(String entityName, long projectId, String compkey) {
        HashSet<String> memberSet = new HashSet<String>(16);
        long billId = SrcClarifyUtils.getMemberSet(projectId, memberSet, compkey);
        QFilter qFilter = new QFilter("billid", "=", (Object)projectId);
        String seleltFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        DynamicObject[] bidopencfgObjs = BusinessDataServiceHelper.load((String)entityName, (String)seleltFields, (QFilter[])new QFilter[]{qFilter});
        if (bidopencfgObjs == null || bidopencfgObjs.length == 0) {
            return false;
        }
        Set<Long> bizTypeSet = SrcClarifyUtils.getBizTypeSet(entityName);
        DynamicObjectCollection memberClarifyCols = SrcClarifyUtils.getMemberClarify(projectId, bizTypeSet);
        Map<String, DynamicObject> memberClarifyMap = SrcClarifyUtils.getMemberClarifyMap(memberClarifyCols);
        HashSet<Long> existDataSet = new HashSet<Long>(8);
        ArrayList<DynamicObject> newEntryObjs = new ArrayList<DynamicObject>(8);
        int seq = 0;
        for (DynamicObject bidopencfgObj : bidopencfgObjs) {
            DynamicObjectCollection rows = bidopencfgObj.getDynamicObjectCollection("scorer");
            for (DynamicObject row : rows) {
                DynamicObject basedataObj = row.getDynamicObject("fbasedataid");
                long scorerId = PdsCommonUtils.object2Long(basedataObj.getPkValue());
                StringBuilder memberClarifyKey = new StringBuilder();
                memberClarifyKey.append(bidopencfgObj.getPkValue()).append("-").append(scorerId);
                DynamicObject memberClarifyObj = memberClarifyMap.get(memberClarifyKey.toString());
                if (null != memberClarifyObj) {
                    existDataSet.add(memberClarifyObj.getLong("id"));
                    continue;
                }
                DynamicObject newObj = SrcClarifyUtils.createMemberEntry(scorerId, projectId, billId, seq++, "3", SrcClarifyUtils.getBizType(bidopencfgObj));
                newObj.set("srcentryid", bidopencfgObj.getPkValue());
                newObj.set("note", (Object)SrcClarifyUtils.getScorerNote(bidopencfgObj));
                if (scorerId == RequestContext.get().getCurrUserId()) {
                    newObj.set("isnotify", (Object)"1");
                    newObj.set("isclarify", (Object)"1");
                    newObj.set("isbenifit", (Object)"0");
                }
                newEntryObjs.add(newObj);
            }
        }
        SrcClarifyUtils.deleteMemberClarify(projectId, existDataSet, memberClarifyCols, bizTypeSet);
        if (newEntryObjs != null && newEntryObjs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newEntryObjs.toArray(new DynamicObject[newEntryObjs.size()]));
            return true;
        }
        return false;
    }

    public static String getScorerNote(DynamicObject scorerObj) {
        StringBuilder sb = new StringBuilder();
        String packageName = PdsCommonUtils.object2String(scorerObj.getString("package.packagename"), "ByItem");
        if (!packageName.equals("ByItem")) {
            sb.append(ResManager.loadKDString((String)"\u6807\u6bb5\uff1a", (String)"SrcClarifyUtils_8", (String)"scm-pds-common", (Object[])new Object[0]));
            sb = sb.append(scorerObj.getString("package.packagename"));
        }
        if (scorerObj.getDynamicObject("indextype") != null) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(ResManager.loadKDString((String)"\u6307\u6807\u7c7b\u578b\uff1a", (String)"SrcClarifyUtils_9", (String)"scm-pds-common", (Object[])new Object[0]));
            sb = sb.append(scorerObj.getString("indextype.name"));
        }
        if (scorerObj.getDynamicObject("scheme") != null) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(ResManager.loadKDString((String)"\u8bc4\u6807\u65b9\u6848\uff1a", (String)"SrcClarifyUtils_10", (String)"scm-pds-common", (Object[])new Object[0]));
            sb = sb.append(scorerObj.getString("scheme.name"));
        }
        return sb.toString();
    }

    public static boolean addCreatorToMember(IFormView currView, long projectId, String compkey, String memberType) {
        IFormView parentView = currView.getParentView();
        if (Objects.isNull(parentView)) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"\u3010\u5c06\u521b\u5efa\u4eba\u6dfb\u52a0\u5230\u9879\u76ee\u6210\u5458\u3011\uff1a\u7236\u9875\u9762\u4e3a\u7a7a currView:%1$s", (String)"SrcClarifyUtils_11", (String)"scm-pds-common", (Object[])new Object[0]), currView.getEntityId()));
            return false;
        }
        HashSet<String> memberSet = new HashSet<String>(16);
        long billId = SrcClarifyUtils.getMemberSet(projectId, memberSet, compkey);
        int seq = SrcClarifyUtils.deleteNullRowAndGetSeq(currView, billId);
        long userId = 0L;
        userId = StringUtils.equals((CharSequence)currView.getEntityId(), (CharSequence)"src_project") ? currView.getModel().getDataEntity().getLong("creator.id") : parentView.getModel().getDataEntity().getLong("creator.id");
        if (userId == 0L) {
            userId = RequestContext.get().getCurrUserId();
        }
        BizLog.log((String)String.format(ResManager.loadKDString((String)"\u3010\u5c06\u521b\u5efa\u4eba\u6dfb\u52a0\u5230\u9879\u76ee\u6210\u5458\u3011\uff1auserId:%1$s", (String)"SrcClarifyUtils_12", (String)"scm-pds-common", (Object[])new Object[0]), userId));
        String key = String.valueOf(SrcClarifyUtils.getBizRoleId("creatorrole")) + '_' + userId;
        if (memberSet.contains(key)) {
            BizLog.log((String)ResManager.loadKDString((String)"\u201c\u5c06\u521b\u5efa\u4eba\u6dfb\u52a0\u5230\u9879\u76ee\u6210\u5458\u201d\uff1a\u5df2\u5b58\u5728\u66f4\u65b0\u72b6\u6001\u3002", (String)"SrcClarifyUtils_13", (String)"scm-pds-common", (Object[])new Object[0]));
            return SrcClarifyUtils.setCreatorStatus(billId, userId, "creatorrole");
        }
        ArrayList<DynamicObject> newEntryObjs = new ArrayList<DynamicObject>(2);
        BizLog.log((String)ResManager.loadKDString((String)"\u3010\u5c06\u521b\u5efa\u4eba\u6dfb\u52a0\u5230\u9879\u76ee\u6210\u5458\u3011\uff1a\u521b\u5efa\u5206\u5f55", (String)"SrcClarifyUtils_14", (String)"scm-pds-common", (Object[])new Object[0]));
        DynamicObject newObj = SrcClarifyUtils.createMemberEntry(userId, projectId, billId, seq++, memberType, null);
        BizLog.log((String)String.format(ResManager.loadKDString((String)"\u3010\u5c06\u521b\u5efa\u4eba\u6dfb\u52a0\u5230\u9879\u76ee\u6210\u5458\u3011\uff1a\u521b\u5efa\u5206\u5f55\u5b8c\u6210 newObj: %1$s", (String)"SrcClarifyUtils_15", (String)"scm-pds-common", (Object[])new Object[0]), newObj.toString()));
        SrcClarifyUtils.updateCreatorStatus(newObj, "creatorrole");
        newEntryObjs.add(newObj);
        if (newEntryObjs.size() > 0) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"\u3010\u5c06\u521b\u5efa\u4eba\u6dfb\u52a0\u5230\u9879\u76ee\u6210\u5458\u3011\uff1a\u4fdd\u5b58\u6570\u636e size: %1$s", (String)"SrcClarifyUtils_16", (String)"scm-pds-common", (Object[])new Object[0]), newEntryObjs.size()));
            SaveServiceHelper.save((DynamicObject[])newEntryObjs.toArray(new DynamicObject[0]));
            return true;
        }
        return false;
    }

    public static boolean addCreatorSuperiorToMember(IFormView currView, long projectId, String compkey, String memberType) {
        long superiorId;
        HashSet<String> memberSet = new HashSet<String>(16);
        long billId = SrcClarifyUtils.getMemberSet(projectId, memberSet, compkey);
        int seq = SrcClarifyUtils.deleteNullRowAndGetSeq(currView, billId);
        long userId = 0L;
        try {
            userId = StringUtils.equals((CharSequence)currView.getEntityId(), (CharSequence)"src_project") ? currView.getModel().getDataEntity().getLong("creator.id") : currView.getParentView().getModel().getDataEntity().getLong("creator.id");
        }
        catch (Exception e) {
            userId = 0L;
        }
        if (userId == 0L) {
            userId = RequestContext.get().getCurrUserId();
        }
        if ((superiorId = OrgAndUserUtils.getSuperiorIdByUserId(userId)) == 0L) {
            return false;
        }
        String key = String.valueOf(SrcClarifyUtils.getBizRoleId("leaderrole")) + '_' + String.valueOf(superiorId);
        if (memberSet.contains(key)) {
            return SrcClarifyUtils.setCreatorStatus(billId, superiorId, "leaderrole");
        }
        ArrayList<DynamicObject> newEntryObjs = new ArrayList<DynamicObject>(2);
        DynamicObject newObj = SrcClarifyUtils.createMemberEntry(superiorId, projectId, billId, seq++, memberType, null);
        SrcClarifyUtils.updateCreatorStatus(newObj, "leaderrole");
        newEntryObjs.add(newObj);
        if (newEntryObjs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newEntryObjs.toArray(new DynamicObject[newEntryObjs.size()]));
            return true;
        }
        return false;
    }

    public static boolean setCreatorStatus(long billId, long userId, String bizRole) {
        QFilter qFilter = new QFilter("billid", "=", (Object)billId);
        qFilter.and("bidder.id", "=", (Object)userId);
        qFilter.and("isnotify", "=", (Object)"0");
        qFilter.and("bizrole", "=", (Object)SrcClarifyUtils.getBizRoleId(bizRole));
        DynamicObject[] memberObjs = BusinessDataServiceHelper.load((String)"src_memberclarify", (String)"bidder,isnotify,isclarify,isbenifit,bizrole,needmessage,needsignin", (QFilter[])new QFilter[]{qFilter});
        if (memberObjs == null || memberObjs.length == 0) {
            return false;
        }
        for (DynamicObject memberObj : memberObjs) {
            SrcClarifyUtils.updateCreatorStatus(memberObj, bizRole);
        }
        SaveServiceHelper.save((DynamicObject[])memberObjs);
        return true;
    }

    public static void updateCreatorStatus(DynamicObject memberObj, String bizRole) {
        memberObj.set("isnotify", (Object)"1");
        memberObj.set("isclarify", (Object)"1");
        memberObj.set("isbenifit", (Object)"0");
        long bizRoleId = SrcClarifyUtils.getBizRoleId(bizRole);
        memberObj.set("bizrole", (Object)bizRoleId);
        DynamicObject bizRoleObj = QueryServiceHelper.queryOne((String)"pds_bizrole", (String)"needmessage,needsignin", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizRoleId)});
        if (null != bizRoleObj) {
            memberObj.set("needmessage", bizRoleObj.get("needmessage"));
            memberObj.set("needsignin", bizRoleObj.get("needsignin"));
        }
    }

    public static long getBizRoleId(String bizRole) {
        Object leaderrole;
        long roleId = 773680364982926336L;
        if (StringUtils.equals((CharSequence)bizRole, (CharSequence)"creatorrole")) {
            Object creatorrole = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)bizRole);
            if (creatorrole instanceof HashMap) {
                roleId = PdsCommonUtils.object2Long(((HashMap)creatorrole).get("masterid"));
            }
        } else if (StringUtils.equals((CharSequence)bizRole, (CharSequence)"leaderrole") && (leaderrole = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)bizRole)) instanceof HashMap) {
            roleId = PdsCommonUtils.object2Long(((HashMap)leaderrole).get("masterid"));
        }
        return roleId;
    }

    public static DynamicObject createMemberEntry(long scorerId, long projectId, long billId, int seq, String memberType, String bizType) {
        Object scorerrole;
        DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)"src_memberclarify");
        ORM.create().setPrimaryKey(newObj);
        newObj.set("fseq", (Object)seq);
        newObj.set("billid", (Object)billId);
        newObj.set("project", (Object)projectId);
        newObj.set("bidder", (Object)scorerId);
        newObj.set("type", (Object)memberType);
        if ("1".equals(memberType) || "2".equals(memberType)) {
            newObj.set("issignin", (Object)"1");
            newObj.set("signintime", (Object)TimeServiceHelper.now());
        }
        if ((scorerrole = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"scorerrole")) instanceof HashMap) {
            newObj.set("bizrole", ((HashMap)scorerrole).get("masterid"));
        } else {
            newObj.set("bizrole", (Object)1244160800789105664L);
        }
        QFilter qfilter = new QFilter("group.number", "=", (Object)"C0218");
        if (null == bizType || "C021806".equals(bizType)) {
            HashSet<String> bizTypeSet = new HashSet<String>(4);
            bizTypeSet.add("C021801");
            bizTypeSet.add("C021802");
            bizTypeSet.add("C021803");
            qfilter = qfilter.and("number", "in", bizTypeSet);
        } else {
            qfilter = qfilter.and("number", "=", (Object)bizType);
        }
        DynamicObjectCollection biztypeRows = QueryServiceHelper.query((String)"pds_extdata", (String)"masterid,id fbasedataid", (QFilter[])qfilter.toArray());
        if (biztypeRows != null && biztypeRows.size() > 0) {
            MultiBasedataUtils.setMultiBasedataForObject(newObj, biztypeRows, "biztype");
        } else {
            newObj.set("biztype", null);
        }
        newObj.set("note", (Object)"");
        newObj.set("entrystatus", (Object)"A");
        newObj.set("isnotify", (Object)"0");
        newObj.set("isclarify", (Object)"0");
        newObj.set("isbenifit", (Object)"2");
        SrcClarifyUtils.setUserInfo(newObj, scorerId);
        SrcMyTaskFacade.setBizRoleUser(projectId, newObj);
        return newObj;
    }

    public static void setUserInfo(DynamicObject userObj, long userId) {
        DynamicObjectCollection userRows = QueryServiceHelper.query((String)"bos_user", (String)"id,number,entryentity.dpt dept,entryentity.position position,phone,email", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userId)});
        if (userRows != null && userRows.size() > 0) {
            userObj.set("number", ((DynamicObject)userRows.get(0)).get("number"));
            userObj.set("dept", ((DynamicObject)userRows.get(0)).get("dept"));
            userObj.set("position", ((DynamicObject)userRows.get(0)).get("position"));
            userObj.set("phone", ((DynamicObject)userRows.get(0)).get("phone"));
            userObj.set("email", ((DynamicObject)userRows.get(0)).get("email"));
        }
    }

    public static void setClarifystatusByHasclarify(long projectId) {
        QFilter clarifyFilter = new QFilter("project", "=", (Object)projectId).and("isclarify", "=", (Object)"1");
        DynamicObjectCollection clarifyObjs = QueryServiceHelper.query((String)"src_memberclarify", (String)"bizrole.id,bidder.id,isnotify,isclarify,isbenifit,description", (QFilter[])clarifyFilter.toArray());
        if (clarifyObjs == null || clarifyObjs.size() == 0) {
            return;
        }
        Map<String, List<DynamicObject>> bidderMap = clarifyObjs.stream().collect(Collectors.groupingBy(e -> e.getString("bizrole.id") + '_' + e.getString("bidder.id")));
        QFilter noClarifyFilter = new QFilter("project", "=", (Object)projectId).and("isclarify", "=", (Object)"0");
        DynamicObject[] noClarifyObjs = BusinessDataServiceHelper.load((String)"src_memberclarify", (String)"bizrole.id,bidder,isnotify,isclarify,isbenifit,description", (QFilter[])noClarifyFilter.toArray());
        if (noClarifyObjs == null || noClarifyObjs.length == 0) {
            return;
        }
        ArrayList<DynamicObject> noclarifyList = new ArrayList<DynamicObject>();
        for (DynamicObject noclarifyObj : noClarifyObjs) {
            String key = noclarifyObj.getString("bizrole.id") + '_' + noclarifyObj.getString("bidder.id");
            List<DynamicObject> bidderList = bidderMap.get(key);
            if (null == bidderList) continue;
            noclarifyObj.set("isnotify", (Object)"1");
            noclarifyObj.set("isclarify", (Object)"1");
            noclarifyObj.set("isbenifit", bidderList.get(0).get("isbenifit"));
            noclarifyObj.set("description", bidderList.get(0).get("description"));
            noclarifyList.add(noclarifyObj);
        }
        if (noclarifyList != null && noclarifyList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])noclarifyList.toArray(new DynamicObject[noclarifyList.size()]));
        }
    }

    public static Integer deleteNullRowAndGetSeq(IFormView currView, long billId) {
        if (!StringUtils.equals((CharSequence)currView.getEntityId(), (CharSequence)"src_project_man") && !StringUtils.equals((CharSequence)currView.getEntityId(), (CharSequence)"src_project_reference")) {
            DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_memberclarify", (String)"id", (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)billId)});
            if (rows == null || rows.size() == 0) {
                return 1;
            }
            return rows.size() + 1;
        }
        for (int i = 0; i < currView.getModel().getEntryRowCount("entryentity"); ++i) {
            DynamicObject row = currView.getModel().getEntryRowEntity("entryentity", i);
            if (row != null && row.get("bidder") != null && row.getLong("bidder.id") != 0L) continue;
            currView.getModel().deleteEntryRow("entryentity", i);
        }
        return currView.getModel().getEntryRowCount("entryentity") + 1;
    }

    public static String getBizType(DynamicObject bidopencfgObj) {
        String bizType = "C021801";
        String baseType = PdsCommonUtils.object2String(bidopencfgObj.getString("indextype.basetype"), "1");
        QFilter qfilter = new QFilter("group.number", "=", (Object)"C0218");
        qfilter.and("paramvalue", "=", (Object)baseType);
        DynamicObject extData = QueryServiceHelper.queryOne((String)"pds_extdata", (String)"number", (QFilter[])qfilter.toArray());
        if (null != extData) {
            return extData.getString("number");
        }
        switch (baseType) {
            case "1": {
                bizType = "C021801";
                break;
            }
            case "2": {
                bizType = "C021802";
                break;
            }
            case "3": {
                bizType = "C021803";
                break;
            }
            case "6": {
                bizType = "C021806";
                break;
            }
            case "4": {
                bizType = "C021804";
                break;
            }
            case "7": {
                bizType = "C021807";
                break;
            }
        }
        return bizType;
    }

    public static DynamicObjectCollection getMemberClarify(long projectId, Set<Long> biztypeSet) {
        QFilter qfilter = new QFilter("project.id", "=", (Object)projectId);
        qfilter.and("srcentryid", ">", (Object)0);
        qfilter.and("biztype.fbasedataid", "in", biztypeSet);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_memberclarify", (boolean)false);
        selectFields = selectFields + ",id";
        DynamicObjectCollection memberClarifyCols = QueryServiceHelper.query((String)"src_memberclarify", (String)selectFields, (QFilter[])qfilter.toArray());
        return memberClarifyCols;
    }

    public static void deleteMemberClarify(long projectId, Set<Long> notDelDataIdSet, DynamicObjectCollection memberClarifyCols, Set<Long> biztypeSet) {
        HashSet<Long> needDelDataIdSet = new HashSet<Long>(memberClarifyCols.size());
        for (DynamicObject memberClarifyCol : memberClarifyCols) {
            Long entryId = memberClarifyCol.getLong("id");
            if (notDelDataIdSet.contains(entryId)) continue;
            needDelDataIdSet.add(entryId);
        }
        if (needDelDataIdSet.size() > 0) {
            QFilter qfilter = new QFilter("project.id", "=", (Object)projectId);
            qfilter.and("srcentryid", ">", (Object)0);
            qfilter.and("biztype.fbasedataid", "in", biztypeSet);
            qfilter.and("id", "in", needDelDataIdSet);
            int delCount = DeleteServiceHelper.delete((String)"src_memberclarify", (QFilter[])qfilter.toArray());
            BizLog.log((String)("###SrcClarifyUtils deleteMemberClarify:" + delCount));
        }
    }

    public static Map<String, DynamicObject> getMemberClarifyMap(DynamicObjectCollection memberClarifyCols) {
        HashMap<String, DynamicObject> memberClarifyMap = new HashMap<String, DynamicObject>(memberClarifyCols.size());
        for (DynamicObject memberClarifyCol : memberClarifyCols) {
            StringBuilder memberClarifyKey = new StringBuilder();
            long srcentryId = memberClarifyCol.getLong("srcentryid");
            long bidderId = memberClarifyCol.getLong("bidder.id");
            memberClarifyKey.append(srcentryId).append("-").append(bidderId);
            memberClarifyMap.put(memberClarifyKey.toString(), memberClarifyCol);
        }
        return memberClarifyMap;
    }

    public static Set<Long> getBizTypeSet(String entityName) {
        HashSet<Long> bizTypeSet = new HashSet<Long>();
        switch (entityName) {
            case "src_aptitudeconfigf7": {
                bizTypeSet.add(BidTypeEnums.APT.getId());
                break;
            }
            case "src_aptitudeconfig2f7": {
                bizTypeSet.add(BidTypeEnums.APT2.getId());
                break;
            }
            default: {
                bizTypeSet.add(BidTypeEnums.TEC.getId());
                bizTypeSet.add(BidTypeEnums.BIZ.getId());
                bizTypeSet.add(BidTypeEnums.OTH.getId());
                bizTypeSet.add(BidTypeEnums.SYN.getId());
            }
        }
        return bizTypeSet;
    }
}

