/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcCurrencyUtil {
    public static Map<String, Long> getRateTableIdAndBaseCurrIdByOrg(long orgId) {
        Map companyMap = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (companyMap == null || companyMap.size() == 0) {
            return null;
        }
        Map baseAccountingInfo = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)companyMap.get("id")));
        if (baseAccountingInfo == null || baseAccountingInfo.size() == 0) {
            return null;
        }
        return baseAccountingInfo;
    }

    public static BigDecimal convertAmountMoneyByCurr(BigDecimal money, String currId, Map<String, Integer> precisionMap) throws KDBizException {
        int precision;
        String amountKey = PdsCommonUtils.buildString(currId, "_", "amount");
        int n = precision = null == precisionMap || null == precisionMap.get(amountKey) ? -1 : precisionMap.get(amountKey);
        if (precision >= 0) {
            return money.setScale(precision, 4);
        }
        AmountProp amountProp = new AmountProp();
        return SrcCurrencyUtil.convertMoneyByCurr(money, currId, (IDataEntityProperty)amountProp, precisionMap);
    }

    public static BigDecimal convertPriceMoneyByCurr(BigDecimal money, String currId, Map<String, Integer> precisionMap) throws KDBizException {
        int precision;
        String priceKey = PdsCommonUtils.buildString(currId, "_", "price");
        int n = precision = null == precisionMap || null == precisionMap.get(priceKey) ? -1 : precisionMap.get(priceKey);
        if (precision >= 0) {
            return money.setScale(precision, 4);
        }
        PriceProp priceProp = new PriceProp();
        return SrcCurrencyUtil.convertMoneyByCurr(money, currId, (IDataEntityProperty)priceProp, precisionMap);
    }

    public static BigDecimal convertMoneyByCurr(BigDecimal money, String currId, IDataEntityProperty pro, Map<String, Integer> precisionMap) throws KDBizException {
        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(currId));
        DynamicObject selectCurr = QueryServiceHelper.queryOne((String)"bd_currency", (String)"amtprecision,priceprecision", (QFilter[])new QFilter[]{qFilter});
        if (selectCurr == null) {
            return money;
        }
        if (pro instanceof PriceProp) {
            String priceKey = PdsCommonUtils.buildString(currId, "_", "price");
            int pricePrecision = selectCurr.getInt("priceprecision");
            money = money.setScale(pricePrecision, 4);
            precisionMap.put(priceKey, pricePrecision);
        } else if (pro instanceof AmountProp) {
            String amountKey = PdsCommonUtils.buildString(currId, "_", "amount");
            int amtPrecision = selectCurr.getInt("amtprecision");
            money = money.setScale(amtPrecision, 4);
            precisionMap.put(amountKey, amtPrecision);
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38", (String)"SrcCurrencyUtil_0", (String)"scm-pds-common", (Object[])new Object[0]));
        }
        return money;
    }

    public static Object getBaseCurrIdByOrg(Object orgId) {
        Map<String, Long> baseAccountingInfo = SrcCurrencyUtil.getRateTableIdAndBaseCurrIdByOrg(PdsCommonUtils.object2Long(orgId));
        if (baseAccountingInfo == null || baseAccountingInfo.isEmpty()) {
            return null;
        }
        return baseAccountingInfo.get("baseCurrencyID");
    }
}

