/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.util.PdsDefaultConfigUtil;

public class SrcDateUtils {
    public static Date addDateByHours(Date date, int hour) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(10, hour);
        date = cal.getTime();
        cal = null;
        return date;
    }

    public static Date addDateBySeconds(Date date, int seconds) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(13, seconds);
        date = cal.getTime();
        cal = null;
        return date;
    }

    public static Date addDateByMilliSeconds(Date date, int millisecond) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(14, millisecond);
        date = cal.getTime();
        cal = null;
        return date;
    }

    public static String getDateDiffer(Date beginDate, Date endDate) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long diff = endDate.getTime() - beginDate.getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        if (day > 0L) {
            return String.format(ResManager.loadKDString((String)"%1$s\u5929%2$s\u5c0f\u65f6%3$s\u5206\u949f", (String)"SrcDateUtils_0", (String)"scm-pds-common", (Object[])new Object[0]), day, hour, min);
        }
        return String.format(ResManager.loadKDString((String)"%1$s\u5c0f\u65f6%2$s\u5206\u949f", (String)"SrcDateUtils_1", (String)"scm-pds-common", (Object[])new Object[0]), hour, min);
    }

    public static BigDecimal getDateDifferHours(Date beginDate, Date endDate) {
        long nh = 3600000L;
        long diff = endDate.getTime() - beginDate.getTime();
        return new BigDecimal(diff).divide(new BigDecimal(nh), 2, RoundingMode.HALF_DOWN);
    }

    public static final Date getDateByOffsetDay(Date now, int offsetDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(now);
        calendar.add(5, offsetDay);
        return calendar.getTime();
    }

    public static Date getMaxDate() {
        return DateUtil.string2date((String)"2099-12-31", (String)"yyyy-MM-dd");
    }

    public static String getCurrentDateTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(TimeServiceHelper.now());
    }

    public static void calculateDateTimes(String changeField, DynamicObject obj, String beginField, String endField, String daysField) {
        BigDecimal secondsPerDay = new BigDecimal(86400);
        BigDecimal millisecond = new BigDecimal(1000);
        Date beginDate = obj.getDate(beginField);
        Date endDate = obj.getDate(endField);
        BigDecimal days = obj.getBigDecimal(daysField);
        if (changeField.equals(beginField)) {
            if (null == beginDate && null != endDate) {
                obj.set(endField, null);
            } else if (null != endDate && !beginDate.before(endDate)) {
                obj.set(endField, (Object)SrcDateUtils.addDateBySeconds(beginDate, days.multiply(secondsPerDay).intValue()));
            } else if (days.compareTo(BigDecimal.ZERO) > 0) {
                obj.set(endField, (Object)SrcDateUtils.addDateBySeconds(beginDate, days.multiply(secondsPerDay).intValue()));
            } else if (null != endDate) {
                obj.set(daysField, (Object)new BigDecimal(endDate.getTime() - beginDate.getTime()).divide(millisecond).divide(secondsPerDay, 2, RoundingMode.HALF_DOWN));
            }
        } else if (changeField.equals(endField)) {
            if (null == endDate && null != beginDate) {
                obj.set(beginField, null);
            } else if (null != beginDate && !beginDate.before(endDate)) {
                obj.set(beginField, (Object)SrcDateUtils.addDateBySeconds(endDate, -days.multiply(secondsPerDay).intValue()));
            } else if (days.compareTo(BigDecimal.ZERO) > 0) {
                obj.set(beginField, (Object)SrcDateUtils.addDateBySeconds(endDate, -days.multiply(secondsPerDay).intValue()));
            } else if (null != beginDate) {
                obj.set(daysField, (Object)new BigDecimal(endDate.getTime() - beginDate.getTime()).divide(millisecond).divide(secondsPerDay, 2, RoundingMode.HALF_DOWN));
            }
        } else if (changeField.equals(daysField)) {
            if (null != beginDate) {
                obj.set(endField, (Object)SrcDateUtils.addDateBySeconds(beginDate, days.multiply(secondsPerDay).intValue()));
            } else if (null != endDate) {
                obj.set(beginField, (Object)SrcDateUtils.addDateBySeconds(endDate, -days.multiply(secondsPerDay).intValue()));
            }
        }
    }

    public static Date getQueryHistoryDate(ExtPluginContext context) {
        QFilter projectFilter = new QFilter("id", "=", context.getProjectObj().getPkValue());
        DynamicObject baseObj = QueryServiceHelper.queryOne((String)"src_project_base", (String)"monthnum", (QFilter[])projectFilter.toArray());
        int monthnum = baseObj.getInt("monthnum");
        if (monthnum == 0) {
            monthnum = Integer.parseInt(PdsDefaultConfigUtil.getDefaultValue(baseObj, "src_project", "src_project_base", "monthnum", 24).toString());
        }
        return SrcDateUtils.getDateByOffsetDay(TimeServiceHelper.now(), -monthnum * 30);
    }
}

