/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.pds.common.util.CollectionUtils;

public class SrcExchangeRateUtils {
    public static Long getRateTableIdByOrg(long orgId) {
        long exchangeTableId = 0L;
        Map companyMap = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (companyMap == null || companyMap.size() == 0) {
            return exchangeTableId;
        }
        Map baseAccountingInfo = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)companyMap.get("id")));
        if (baseAccountingInfo == null || baseAccountingInfo.size() == 0) {
            return exchangeTableId;
        }
        exchangeTableId = (Long)baseAccountingInfo.get("exchangeRateTableID");
        return exchangeTableId;
    }

    public static void setCalcLocalValue(DynamicObject purlistObj, String sourceField, String targetField, String precisionField) {
        purlistObj.set(targetField, (Object)SrcExchangeRateUtils.calcLocalValue(purlistObj, sourceField, precisionField));
    }

    public static BigDecimal calcLocalValue(DynamicObject purlistObj, String sourceField, String precisionField) {
        return SrcExchangeRateUtils.calc(purlistObj, sourceField, precisionField, true);
    }

    public static BigDecimal calcValue(DynamicObject purlistObj, String sourceField, String precisionField) {
        return SrcExchangeRateUtils.calc(purlistObj, sourceField, precisionField, false);
    }

    private static BigDecimal calc(DynamicObject purlistObj, String sourceField, String precisionField, boolean isLoc) {
        int precision;
        BigDecimal calcValue = purlistObj.getBigDecimal(sourceField);
        DynamicObject locCurr = purlistObj.getDynamicObject("loccurr");
        DynamicObject curr = purlistObj.getDynamicObject("currency");
        int n = precision = null == locCurr ? 4 : locCurr.getInt(precisionField);
        if ("taxprice".equals(sourceField) || "price".equals(sourceField)) {
            precision = 10;
        }
        String quotation = purlistObj.getString("quotation");
        BigDecimal exrate = purlistObj.getBigDecimal("exrate");
        if (Objects.isNull(locCurr) || Objects.isNull(curr) || Objects.equals(locCurr.getPkValue(), curr.getPkValue()) || exrate.compareTo(BigDecimal.ZERO) <= 0) {
            exrate = BigDecimal.ONE;
            quotation = "0";
        }
        switch (quotation) {
            case "0": {
                if (isLoc) {
                    calcValue = calcValue.multiply(exrate).setScale(precision, RoundingMode.HALF_UP);
                    break;
                }
                calcValue = calcValue.divide(exrate, precision, RoundingMode.HALF_UP);
                break;
            }
            case "1": {
                if (isLoc) {
                    calcValue = calcValue.divide(exrate, precision, RoundingMode.HALF_UP);
                    break;
                }
                calcValue = calcValue.multiply(exrate).setScale(precision, RoundingMode.HALF_UP);
                break;
            }
        }
        return calcValue;
    }

    public static Map<String, Object> getExchangeRate(DynamicObject purlistObj, StringBuilder currMsgSb, Map<String, Object> cacheMap) {
        HashMap<String, Object> exchangeRateMap = new HashMap<String, Object>(16);
        long rateTableId = purlistObj.getLong("exratetable.id");
        if (rateTableId == 0L) {
            rateTableId = SrcExchangeRateUtils.getRateTableIdByOrg(purlistObj.getLong("org.id"));
            purlistObj.set("exratetable_id", (Object)rateTableId);
        }
        String quotation = purlistObj.getString("quotation");
        BigDecimal exrate = purlistObj.getBigDecimal("exrate");
        if (exrate.compareTo(BigDecimal.ZERO) <= 0 || StringUtils.isBlank((String)quotation)) {
            long currency;
            long loccurr = purlistObj.getLong("loccurr.id");
            if (loccurr == (currency = purlistObj.getLong("currency.id"))) {
                exchangeRateMap.put("exrate", BigDecimal.ONE);
                exchangeRateMap.put("quotation", "0");
                purlistObj.set("quotation", (Object)"0");
                purlistObj.set("exrate", (Object)BigDecimal.ONE);
                return exchangeRateMap;
            }
            String key = String.valueOf(rateTableId) + '|' + currency + '|' + loccurr;
            if (cacheMap.get(key + '|' + "exrate") != null) {
                exchangeRateMap.put("exrate", cacheMap.get(key + '|' + "exrate"));
                exchangeRateMap.put("quotation", cacheMap.get(key + '|' + "quotation"));
            } else {
                Map exchangeRateByRules;
                Date exrateDate = purlistObj.getDate("exratedate");
                if (Objects.isNull(exrateDate)) {
                    exrateDate = Calendar.getInstance().getTime();
                    purlistObj.set("exratedate", (Object)exrateDate);
                }
                if (CollectionUtils.isEmpty(exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)currency, (Long)loccurr, (Long)rateTableId, (Date)exrateDate)) || Objects.isNull(exchangeRateByRules.get("exchangeRate"))) {
                    currMsgSb.append(String.format(ResManager.loadKDString((String)"\u62a5\u4ef7\u5e01\u522b\uff1a%s<-->", (String)"SrcExchangeRateUtils_4", (String)"scm-pds-common", (Object[])new Object[0]), purlistObj.getString("currency.name")));
                    StringBuilder currMsgSb1 = new StringBuilder();
                    if (null == purlistObj.get("loccurr")) {
                        currMsgSb1.append(ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"SrcExchangeRateUtils_2", (String)"scm-pds-common", (Object[])new Object[0]));
                    } else {
                        currMsgSb1.append(purlistObj.getString("loccurr.name"));
                    }
                    currMsgSb.append(String.format(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\uff1a%s; ", (String)"SrcExchangeRateUtils_5", (String)"scm-pds-common", (Object[])new Object[0]), currMsgSb1));
                } else {
                    exrate = (BigDecimal)exchangeRateByRules.get("exchangeRate");
                    quotation = (Boolean)exchangeRateByRules.get("quoteType") != false ? "1" : "0";
                    exchangeRateMap.put("exrate", exrate);
                    exchangeRateMap.put("quotation", quotation);
                    cacheMap.put(key + '|' + "quotation", quotation);
                    cacheMap.put(key + '|' + "exrate", exrate);
                    purlistObj.set("quotation", (Object)quotation);
                    purlistObj.set("exrate", (Object)exrate);
                }
            }
        }
        return exchangeRateMap;
    }

    public static void setExchangeRate(DynamicObject purlistObj, Map<String, Object> cacheMap) {
        long rateTableId = purlistObj.getLong("exratetable.id");
        if (rateTableId == 0L) {
            rateTableId = SrcExchangeRateUtils.getRateTableIdByOrg(purlistObj.getLong("org.id"));
            purlistObj.set("exratetable_id", (Object)rateTableId);
        }
        long loccurr = 0L;
        Object loccurrObj = purlistObj.get("loccurr");
        if (loccurrObj instanceof Long) {
            loccurr = (Long)loccurrObj;
        } else if (loccurrObj instanceof DynamicObject) {
            loccurr = purlistObj.getLong("loccurr.id");
        }
        long currency = 0L;
        Object currObj = purlistObj.get("currency");
        if (currObj instanceof Long) {
            currency = (Long)currObj;
        } else if (currObj instanceof DynamicObject) {
            currency = purlistObj.getLong("currency.id");
        }
        if (loccurr == currency) {
            purlistObj.set("quotation", (Object)"0");
            purlistObj.set("exrate", (Object)BigDecimal.ONE);
            return;
        }
        String key = String.valueOf(rateTableId) + '|' + currency + '|' + loccurr;
        BigDecimal exrate = BigDecimal.ZERO;
        String quotation = "";
        if (cacheMap.get(key + '|' + "exrate") != null) {
            exrate = (BigDecimal)cacheMap.get(key + '|' + "exrate");
            quotation = (String)cacheMap.get(key + '|' + "quotation");
        } else {
            Map exchangeRateByRules;
            Date exrateDate = purlistObj.getDate("exratedate");
            if (Objects.isNull(exrateDate)) {
                exrateDate = Calendar.getInstance().getTime();
                purlistObj.set("exratedate", (Object)exrateDate);
            }
            if (CollectionUtils.isNotEmpty(exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)currency, (Long)loccurr, (Long)rateTableId, (Date)exrateDate))) {
                exrate = (BigDecimal)exchangeRateByRules.get("exchangeRate");
                quotation = (Boolean)exchangeRateByRules.get("quoteType") != false ? "1" : "0";
                cacheMap.put(key + '|' + "quotation", quotation);
                cacheMap.put(key + '|' + "exrate", exrate);
            }
        }
        purlistObj.set("quotation", (Object)quotation);
        purlistObj.set("exrate", (Object)exrate);
    }
}

