/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enroll.PdsEnrollContext;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.suplinkman.PdsLinkManFacade;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsParameterUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class SupplierUtil {
    public static DynamicObject getSupplier() {
        QFilter userIdFilter = new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId());
        DynamicObject partner = BusinessDataServiceHelper.loadSingle((String)"bos_bizpartneruser", (String)"bizpartner,org", (QFilter[])new QFilter[]{userIdFilter});
        if (partner == null) {
            return null;
        }
        DynamicObject bizpartner = (DynamicObject)partner.get("bizpartner");
        QFilter bizPartnerFilter = new QFilter("bizpartner", "=", bizpartner.getPkValue());
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)"name", (QFilter[])new QFilter[]{bizPartnerFilter});
        return supplier;
    }

    public static DynamicObject getBizPartner(Object supplierId, String supType) {
        DynamicObject bizPartner = null;
        long supId = PdsCommonUtils.object2Long(supplierId);
        if (supId == 0L || !QueryServiceHelper.exists((String)supType, (QFilter[])new QFilter("id", "=", (Object)supId).toArray())) {
            return bizPartner;
        }
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(supplierId.toString()), (String)supType);
        if (null != supplier) {
            DynamicObject bdSup;
            if ("bd_supplier".equals(supType)) {
                bizPartner = supplier.getDynamicObject("bizpartner");
            } else if ("src_supplier".equals(supType) && null != (bdSup = supplier.getDynamicObject("supplier"))) {
                bizPartner = bdSup.getDynamicObject("bizpartner");
            }
        }
        return bizPartner;
    }

    public static DynamicObject getBdSuplierBySrcSupplier(DynamicObject supplier) {
        DynamicObject bdSup = null;
        if (null == supplier) {
            return null;
        }
        if (null != supplier && null != (bdSup = supplier.getDynamicObject("supplier"))) {
            bdSup = BusinessDataServiceHelper.loadSingle((Object)bdSup.getPkValue(), (String)"bd_supplier");
        }
        return bdSup;
    }

    public static DynamicObject getSrcSupplierByBdSupplier() {
        long bdSupplier = SrmCommonUtil.getPkValue((DynamicObject)SupplierUtil.getSupplier());
        QFilter filters = new QFilter("supplier.id", "=", (Object)bdSupplier);
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((String)"src_supplier", (String)"id", (QFilter[])filters.toArray());
        return supplier;
    }

    public static List<Long> getUserIdsByBizPartner(long bizpartnerId) {
        DynamicObjectCollection userObjs = QueryServiceHelper.query((String)"pur_supuser", (String)"user.id", (QFilter[])new QFilter[]{new QFilter("bizpartner", "=", (Object)bizpartnerId)}, (String)"isadmin desc");
        if (userObjs == null || userObjs.size() == 0) {
            return null;
        }
        List<Long> userIds = userObjs.stream().map(e -> e.getLong("user.id")).distinct().collect(Collectors.toList());
        return userIds;
    }

    public static long getUserIdByBizPartner(long bizpartnerId) {
        List<Long> userIds = SupplierUtil.getUserIdsByBizPartner(bizpartnerId);
        if (userIds == null || userIds.size() == 0) {
            return 0L;
        }
        return userIds.get(0);
    }

    public static QFilter getRegistSupFilterByCurrUserId() {
        List<Long> formalSupList = PdsCommonUtils.getSupplierByUserOfBizPartner();
        DynamicObjectCollection registSupRows = QueryServiceHelper.query((String)"src_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("supplier.id", "in", formalSupList)});
        List registSupList = registSupRows.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("supplier.id", "in", registSupList);
        return qFilter;
    }

    public static String getSupProBySupType(String supType) {
        String filterPro = "supplier";
        if ("bd_supplier".equals(supType)) {
            filterPro = "supplier";
        } else if ("src_supplier".equals(supType)) {
            filterPro = "supplier.supplier";
        }
        return filterPro;
    }

    public static String getSupType(DynamicObject obj) {
        Object supTypeObj = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"suppliertype");
        String supType = "bd_supplier";
        if (null != supTypeObj && String.valueOf(supTypeObj).trim().length() > 0) {
            supType = String.valueOf(supTypeObj);
        }
        return supType;
    }

    public static DynamicObject getBdSupplier(DynamicObject obj, String supType) {
        DynamicObject bdSup = null;
        if ("bd_supplier".equals(supType)) {
            bdSup = obj;
        } else if ("src_supplier".equals(supType)) {
            bdSup = obj.getDynamicObject("supplier");
        }
        return bdSup;
    }

    public static List<Long> getAllSupIdByBizPartnerAndSupType() {
        DynamicObject[] supObjs;
        List<Long> supIdList = PdsCommonUtils.getSupplierByUserOfBizPartner();
        String supType = SupplierUtil.getSupType(null);
        if ("src_supplier".equals(supType) && null != (supObjs = BusinessDataServiceHelper.load((String)supType, (String)"id", (QFilter[])new QFilter[]{new QFilter("supplier.id", "in", supIdList)}))) {
            supIdList = Arrays.stream(supObjs).map(obj -> PdsCommonUtils.object2Long(obj.getPkValue())).collect(Collectors.toList());
        }
        return supIdList;
    }

    public static Set<Long> getInviteSupplierIds(long projectId, long packageId) {
        return SupplierUtil.getEnrollOrInviteOrTenderSupplierIds("src_bidopensupplier", projectId, packageId);
    }

    public static Set<Long> getEnrollOrInviteOrTenderSupplierIds(String entityName, long projectId, long packageId) {
        DynamicObjectCollection rows;
        QFilter qfilters = new QFilter("billid", "=", (Object)projectId);
        if (packageId > 0L) {
            qfilters.and("package", "=", (Object)packageId);
        }
        if ((rows = QueryServiceHelper.query((String)entityName, (String)"supplier.id", (QFilter[])qfilters.toArray())) == null || rows.size() == 0) {
            return Collections.emptySet();
        }
        Set<Long> suppliers = rows.stream().map(row -> row.getLong("supplier.id")).collect(Collectors.toSet());
        return suppliers;
    }

    public static Set<Long> getValidSupplierIds(long projectId, long packageId) {
        QFilter qfilters = SupplierUtil.getValidTenderSupplierFilter(projectId, packageId);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"supplier.id", (QFilter[])qfilters.toArray());
        if (rows == null || rows.size() == 0) {
            return Collections.emptySet();
        }
        Set<Long> suppliers = rows.stream().map(row -> row.getLong("supplier.id")).collect(Collectors.toSet());
        return suppliers;
    }

    public static QFilter getValidTenderSupplierFilter(long projectId, long packageId) {
        QFilter qfilters = new QFilter("billid", "=", (Object)projectId);
        qfilters.and("istender", "=", (Object)"1");
        qfilters.and("isabandon", "=", (Object)"0");
        qfilters.and("isdiscard", "=", (Object)"0");
        qfilters.and("isaptitude", "!=", (Object)"2");
        if (packageId > 0L) {
            qfilters.and("package", "=", (Object)packageId);
        }
        return qfilters;
    }

    public static QFilter getValidConfirmSupplierFilter(long projectId, long packageId) {
        QFilter qfilters = new QFilter("billid", "=", (Object)projectId);
        qfilters.and("isinvite", "=", (Object)"1");
        qfilters.and("isconfirm", "=", (Object)"1");
        qfilters.and("isdiscard", "=", (Object)"0");
        qfilters.and("isaptitude", "!=", (Object)"2");
        if (packageId > 0L) {
            qfilters.and("package", "=", (Object)packageId);
        }
        return qfilters;
    }

    public static QFilter getValidInviteSupplierFilter(long projectId, long packageId) {
        QFilter qfilters = new QFilter("billid", "=", (Object)projectId);
        qfilters.and("isinvite", "=", (Object)"1");
        qfilters.and("isdiscard", "=", (Object)"0");
        qfilters.and("isaptitude", "!=", (Object)"2");
        if (packageId > 0L) {
            qfilters.and("package", "=", (Object)packageId);
        }
        return qfilters;
    }

    public static Set<Long> getInvitePackageIds(long projectId, long supplierId) {
        DynamicObjectCollection rows;
        QFilter qfilters = new QFilter("billid", "=", (Object)projectId);
        if (supplierId > 0L) {
            qfilters.and("supplier", "=", (Object)supplierId);
        }
        if ((rows = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"package.id", (QFilter[])qfilters.toArray())) == null || rows.size() == 0) {
            return Collections.emptySet();
        }
        Set<Long> packages = rows.stream().map(row -> row.getLong("package.id")).collect(Collectors.toSet());
        return packages;
    }

    public static Set<Long> getPurlistSupplierIds(long projectId, long purlistId, QFilter otherFilter) {
        DynamicObjectCollection rows;
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and("purlist", "=", (Object)purlistId);
        qfilters.and("supplier", ">", (Object)0L);
        if (null != otherFilter) {
            qfilters.and(otherFilter);
        }
        if ((rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"suppliertype,supplier.id", (QFilter[])qfilters.toArray())) == null || rows.size() == 0) {
            return Collections.emptySet();
        }
        Set<Long> suppliers = rows.stream().map(row -> row.getLong("supplier.id")).collect(Collectors.toSet());
        return suppliers;
    }

    public static Set<Long> getItemSupplierIds(long projectId, long purlistId) {
        DynamicObject proItemSupObj = TemplateUtil.getComponentData(String.valueOf(projectId), "src_itemsupplier");
        if (null == proItemSupObj) {
            return Collections.emptySet();
        }
        DynamicObjectCollection proItemSupRows = proItemSupObj.getDynamicObjectCollection("entryentity");
        if (proItemSupRows == null || proItemSupRows.size() == 0) {
            return Collections.emptySet();
        }
        for (DynamicObject proItemSupRow : proItemSupRows) {
            if (purlistId != proItemSupRow.getLong("purlist.id")) continue;
            DynamicObjectCollection rows = proItemSupRow.getDynamicObjectCollection("supplier");
            Set<Long> suppliers = rows.stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toSet());
            return suppliers;
        }
        return Collections.emptySet();
    }

    public static void supplierChangedHandle(IDataModel model, PropertyChangedArgs e) {
        ChangeData[] change = e.getChangeSet();
        if (change[0] == null) {
            return;
        }
        DynamicObject supplier = (DynamicObject)change[0].getNewValue();
        if (null == supplier) {
            return;
        }
        if (!SupplierUtil.isSupplierBaseData(supplier)) {
            return;
        }
        int index = change[0].getRowIndex();
        HashMap<Object, Object> supMap = new HashMap(2);
        Object supplierType = model.getValue("suppliertype", index);
        DynamicObject loadSup = BusinessDataServiceHelper.loadSingle((Object)supplier.getPkValue(), (String)supplier.getDynamicObjectType().getName());
        if ("src_supplier".equals(String.valueOf(supplierType))) {
            supMap = PdsLinkManFacade.getRegSupplierLinkMan(loadSup);
        } else if ("bd_supplier".equals(String.valueOf(supplierType))) {
            supMap = PdsLinkManFacade.getSupplierLinkMan(loadSup);
            model.setValue("supname", (Object)loadSup.getString("name"), index);
            model.setValue("societycreditcode", (Object)loadSup.getString("societycreditcode"), index);
        }
        model.setValue("linkman", supMap.get("linkman"), index);
        model.setValue("phone", supMap.get("phone"), index);
        model.setValue("duty", supMap.get("duty"), index);
        model.setValue("email", supMap.get("email"), index);
        model.setValue("address", supMap.get("address"), index);
        model.setValue("supplieruser", null, index);
        if (index > 0 && model.getValue("package", index - 1) != null && model.getValue("package", index) == null) {
            model.setValue("package", model.getValue("package", index - 1), index);
        }
    }

    public static void setBdSupplierInfo(long supplierId, DynamicObject supplierObj) {
        if (supplierId == 0L) {
            return;
        }
        DynamicObject bdSupplier = BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)"bd_supplier");
        supplierObj.set("suppliertype", (Object)"bd_supplier");
        supplierObj.set("supplier", (Object)supplierId);
        supplierObj.set("supname", (Object)bdSupplier.getString("name"));
        supplierObj.set("societycreditcode", (Object)bdSupplier.getString("societycreditcode"));
        HashMap<String, String> supMap = PdsLinkManFacade.getSupplierLinkMan(bdSupplier);
        supplierObj.set("linkman", supMap.get("linkman"));
        supplierObj.set("phone", supMap.get("phone"));
        supplierObj.set("duty", supMap.get("duty"));
        supplierObj.set("email", supMap.get("email"));
        supplierObj.set("address", supMap.get("address"));
    }

    public static void setInviteSupplierEntry(DynamicObject supEntryObj, DynamicObject supplier, long billId, long packageId) {
        supEntryObj.set("billid", (Object)billId);
        supEntryObj.set("package", (Object)packageId);
        supEntryObj.set("package_id", (Object)packageId);
        supEntryObj.set("suppliertype", (Object)"bd_supplier");
        supEntryObj.set("supplier", (Object)SrmCommonUtil.getPkValue((DynamicObject)supplier));
        supEntryObj.set("supplier_id", (Object)SrmCommonUtil.getPkValue((DynamicObject)supplier));
        supEntryObj.set("supname", (Object)supplier.getString("name"));
        supEntryObj.set("societycreditcode", (Object)supplier.getString("societycreditcode"));
        HashMap<String, String> linkMap = PdsLinkManFacade.getSupplierLinkMan(supplier.getPkValue());
        supEntryObj.set("linkman", linkMap.get("linkman"));
        supEntryObj.set("phone", linkMap.get("phone"));
        supEntryObj.set("isinvite", (Object)"1");
        supEntryObj.set("isconfirm", (Object)Character.valueOf('1'));
        supEntryObj.set("source", (Object)"9");
        supEntryObj.set("isselect", (Object)Character.valueOf('1'));
        Date now = TimeServiceHelper.now();
        supEntryObj.set("publishstatus", (Object)"B");
        supEntryObj.set("publishdate", (Object)now);
        supEntryObj.set("publisher", (Object)RequestContext.get().getCurrUserId());
    }

    public static Set<Long> getSupplierUserIdSet(DynamicObject billObj, String multiBasedataField) {
        Set<Long> supUserIds = MultiBasedataUtils.getBasedataIdSet(billObj, multiBasedataField);
        DynamicObjectCollection userObjs = QueryServiceHelper.query((String)"pur_supuser", (String)"user.id", (QFilter[])new QFilter[]{new QFilter("id", "in", supUserIds)});
        if (null != userObjs) {
            return userObjs.stream().map(e -> e.getLong("user.id")).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public static final Set<Long> getSupplierUserIdsByCurrUserId() {
        HashSet<Long> pkIds = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"bos_bizpartneruser", (String)"id", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId())}, (String)"id");){
            dataSet.forEach(row -> pkIds.add(row.getLong("id")));
        }
        return pkIds;
    }

    public static DynamicObjectCollection getSupplierUser(long projectId, long supplierId) {
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId).and("supplier", "=", (Object)supplierId);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_supplierinvite", (String)"supplieruser", (QFilter[])qfilter.toArray());
        if (null == rows || rows.length == 0) {
            return null;
        }
        DynamicObjectCollection supplierUsers = new DynamicObjectCollection();
        for (DynamicObject row : rows) {
            supplierUsers.addAll((Collection)row.getDynamicObjectCollection("supplieruser"));
        }
        return supplierUsers;
    }

    public static void setSupplierUser(DynamicObject currentObj, long projectId, long supplierId) {
        DynamicObjectCollection supplierUsers = SupplierUtil.getSupplierUser(projectId, supplierId);
        if (supplierUsers != null && supplierUsers.size() > 0) {
            MultiBasedataUtils.setMultiBasedataForObject(currentObj, supplierUsers, "supplieruser");
        }
    }

    public static void setIsPurAgent(DynamicObject currentObj, long projectId, long supplierId) {
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        qfilter.and("supplier", "=", (Object)supplierId);
        qfilter.and("ispuragent", "=", (Object)"1");
        if (QueryServiceHelper.exists((String)"src_supplierinvite", (QFilter[])qfilter.toArray())) {
            currentObj.set("ispuragent", (Object)"1");
        }
    }

    public static void setSupplierUser2Entry(IDataModel model, int index, long projectId, long supplierId) {
        DynamicObjectCollection supplierUsers = SupplierUtil.getSupplierUser(projectId, supplierId);
        if (supplierUsers != null && supplierUsers.size() > 0) {
            List supplierUserList = supplierUsers.stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
            Object[] basedataIds = supplierUserList.toArray();
            model.setValue("supplieruser", (Object)basedataIds, index);
        }
    }

    public static boolean isBdSupplier(DynamicObject row) {
        String suppliertype;
        return row != null && "bd_supplier".equals(suppliertype = row.getString("suppliertype"));
    }

    public static boolean isQZGYS(long supplierId) {
        DynamicObject status;
        DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplierId, (String)"bd_supplier");
        if (supplier != null && (status = supplier.getDynamicObject("supplier_status")) != null) {
            return "QZGYS".endsWith(status.getString("number"));
        }
        return false;
    }

    public static DynamicObject createSupplierObj(String entityName, PdsEnrollContext context, int indexSeq, long packageId) {
        DynamicObject supplierObj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        ORM.create().setPrimaryKey(supplierObj);
        supplierObj.set("billid", (Object)context.getProjectId());
        supplierObj.set("parentid", (Object)String.valueOf(context.getProjectId()));
        supplierObj.set("fseq", (Object)indexSeq++);
        supplierObj.set("suppliertype", (Object)"bd_supplier");
        supplierObj.set("supplier_id", (Object)context.getSupplierId());
        supplierObj.set("package_id", (Object)packageId);
        supplierObj.set("linkman", (Object)context.getBillObj().getString("linkman"));
        supplierObj.set("duty", (Object)context.getBillObj().getString("duty"));
        supplierObj.set("phone", (Object)context.getBillObj().getString("phone"));
        supplierObj.set("address", (Object)context.getBillObj().getString("address"));
        supplierObj.set("email", (Object)context.getBillObj().getString("email"));
        supplierObj.set("remark", (Object)context.getBillObj().getString("remark"));
        supplierObj.set("societycreditcode", (Object)context.getBillObj().getString("societycreditcode"));
        return supplierObj;
    }

    public static DynamicObject[] reloadSupplierArray(String entityName, Set<Long> entryIds) {
        QFilter qfilter = new QFilter("id", "in", entryIds);
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        return BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilter.toArray());
    }

    public static List<DynamicObject> reloadSupplierList(String entityName, Set<Long> entryIds) {
        DynamicObject[] supplierArray = SupplierUtil.reloadSupplierArray(entityName, entryIds);
        return Arrays.asList(supplierArray);
    }

    public static DynamicObjectCollection reloadSupplierCollection(String entityName, Set<Long> entryIds) {
        DynamicObject[] supplierArray = SupplierUtil.reloadSupplierArray(entityName, entryIds);
        DynamicObjectCollection supplierList = new DynamicObjectCollection();
        supplierList.addAll(Arrays.asList(supplierArray));
        return supplierList;
    }

    public static void isPuragentChangedHandle(IFormView view, int currIndex, String isPurAgentField, String isFeeAgentField, String isPurAptitudeField) {
        if ("src_apply".equals(view.getEntityId()) || "src_demand".equals(view.getEntityId()) || "src_demand_comp".equals(view.getEntityId())) {
            return;
        }
        try {
            DynamicObject billObj = view.getParentView().getModel().getDataEntity();
            if (PdsCommonUtils.isNotProjectBill(view.getParentView().getEntityId())) {
                billObj = billObj.getDynamicObject("project");
            }
            if (!"2".equals(billObj.getString("managetype"))) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        DynamicObject currRow = view.getModel().getEntryRowEntity("entrysupplier", currIndex);
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)currRow.getDynamicObject("supplier"));
        boolean isPurAgent = null != isPurAgentField ? currRow.getBoolean(isPurAgentField) : false;
        boolean isFeeAgent = null != isFeeAgentField ? currRow.getBoolean(isFeeAgentField) : false;
        boolean isPurAptitude = null != isPurAptitudeField ? currRow.getBoolean(isPurAptitudeField) : false;
        int index = 0;
        DynamicObjectCollection rows = view.getModel().getEntryEntity("entrysupplier");
        for (DynamicObject row : rows) {
            long supplierId2;
            if (index != currIndex && supplierId == (supplierId2 = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("supplier")))) {
                if (null != isPurAgentField) {
                    view.getModel().setValue(isPurAgentField, (Object)isPurAgent, index);
                }
                if (null != isFeeAgentField) {
                    view.getModel().setValue(isFeeAgentField, (Object)isFeeAgent, index);
                }
                if (null != isPurAptitudeField) {
                    view.getModel().setValue(isPurAptitudeField, (Object)isPurAptitude, index);
                }
            }
            ++index;
        }
    }

    public static void isPuragentChangedHandle(IFormView view, int currIndex, String isPurAgentField, String isFeeAgentField) {
        SupplierUtil.isPuragentChangedHandle(view, currIndex, isPurAgentField, isFeeAgentField, null);
    }

    public static DynamicObject getQualifiedSupplierUser(List<DynamicObject> list) {
        DynamicObject bizObj = list.stream().filter(s -> s.getBoolean("isadmin")).findFirst().orElse(null);
        if (Objects.isNull(bizObj)) {
            bizObj = list.stream().filter(s -> Objects.nonNull(s.getDate("modifytime"))).max(Comparator.comparing(s -> s.getDate("modifytime"), Date::compareTo)).orElse(null);
        }
        return bizObj;
    }

    public static void createEnrollSupEntry(DynamicObject projectObj) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)projectObj);
        String manageType = PdsCommonUtils.object2String(projectObj.getString("managetype"), "1");
        DynamicObject[] inviteRows = SupplierUtil.getSupplierRows(projectId, "src_supplierinvite", "billid");
        DynamicObject[] enrollRows = SupplierUtil.getSupplierRows(projectId, "src_enrollsupplier", "billid");
        if (inviteRows.length == 0) {
            return;
        }
        Map<String, DynamicObject> enrollMap = null;
        Map<String, DynamicObject> inviteMap = null;
        if ("2".equals(manageType)) {
            enrollMap = Arrays.asList(enrollRows).stream().collect(Collectors.groupingBy(e -> String.valueOf(e.getLong("package.id")) + '_' + String.valueOf(e.getLong("supplier.id")), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
            inviteMap = Arrays.asList(inviteRows).stream().collect(Collectors.groupingBy(e -> String.valueOf(e.getLong("package.id")) + '_' + String.valueOf(e.getLong("supplier.id")), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        } else {
            enrollMap = Arrays.asList(enrollRows).stream().collect(Collectors.groupingBy(e -> String.valueOf(e.getLong("supplier.id")), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
            inviteMap = Arrays.asList(inviteRows).stream().collect(Collectors.groupingBy(e -> String.valueOf(e.getLong("supplier.id")), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        }
        List<String> properties = null;
        ArrayList<DynamicObject> enrollSupObjs = new ArrayList<DynamicObject>(inviteRows.length - enrollRows.length > 0 ? inviteRows.length - enrollRows.length : 8);
        HashSet<String> excludedFields = new HashSet<String>(4);
        for (Map.Entry<String, DynamicObject> entry : inviteMap.entrySet()) {
            if (null != enrollMap.get(entry.getKey())) continue;
            DynamicObject enrollObj = SupplierUtil.copySupplierValues("src_enrollsupplier", entry.getValue(), properties, excludedFields, enrollRows.length);
            enrollObj.set("isselect", (Object)"1");
            enrollSupObjs.add(enrollObj);
        }
        PdsCommonUtils.saveDynamicObjects(enrollSupObjs);
    }

    public static DynamicObject[] getSupplierRows(long projectId, String entityName, String keyField) {
        QFilter qfilters = new QFilter(keyField, "=", (Object)projectId);
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        return BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilters.toArray());
    }

    public static DynamicObject copySupplierValues(String newEntityName, DynamicObject oldObj, List<String> properties, Set<String> excludedFields, int index) {
        DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)newEntityName);
        if (null == properties) {
            properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)newObj);
        }
        PdsCommonUtils.copyDynamicObjectValue(oldObj, newObj, properties, excludedFields, index);
        return newObj;
    }

    public static Set<String> getPackageId_SupplierIdSet(long projectId, long packageId, long supplierId, String entityName) {
        QFilter qfilters = new QFilter("billid", "=", (Object)projectId);
        if (packageId > 0L) {
            qfilters.and("package", "=", (Object)packageId);
        }
        if (supplierId > 0L) {
            qfilters.and("supplier", "=", (Object)supplierId);
        }
        return SupplierUtil.getPackageId_SupplierIdSet(qfilters, entityName);
    }

    public static Set<String> getPackageId_SupplierIdSet(QFilter qfilters, String entityName) {
        DynamicObjectCollection rows = QueryServiceHelper.query((String)entityName, (String)"package.id,supplier.id", (QFilter[])qfilters.toArray());
        if (rows == null || rows.size() == 0) {
            return new HashSet<String>();
        }
        return rows.stream().map(row -> String.valueOf(row.getLong("package.id")) + '_' + String.valueOf(row.getLong("supplier.id"))).collect(Collectors.toSet());
    }

    public static Set<Long> getAllSupplierIds(long projectId) {
        HashSet<Long> supplierIds = new HashSet<Long>();
        supplierIds.addAll(SupplierUtil.getSupplierIds(projectId, "src_enrollsupplier"));
        supplierIds.addAll(SupplierUtil.getSupplierIds(projectId, "src_supplierinvite"));
        supplierIds.addAll(SupplierUtil.getSupplierIds(projectId, "src_bidopensupplier"));
        return supplierIds;
    }

    public static Set<Long> getSupplierIds(long projectId, String entityName) {
        QFilter qfilters = new QFilter("billid", "=", (Object)projectId);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)entityName, (String)"supplier.id", (QFilter[])qfilters.toArray());
        if (rows == null || rows.size() == 0) {
            return Collections.emptySet();
        }
        Set<Long> suppliers = rows.stream().map(row -> row.getLong("supplier.id")).collect(Collectors.toSet());
        return suppliers;
    }

    public static boolean isSupplierBaseData(DynamicObject baseDataObj) {
        return "bd_supplier".equals(baseDataObj.getDataEntityType().getName()) || "srm_supplier".equals(baseDataObj.getDataEntityType().getName());
    }

    public static Set<Long> getContractSuppliers(long projectId) {
        Set<String> resultValueSet = PdsParameterUtils.getResultValueSet();
        QFilter qFilters = new QFilter("project", "=", (Object)projectId);
        qFilters.and("entrystatus", "=", (Object)ProjectStatusEnums.OPENED.getValue());
        qFilters.and("result", "in", resultValueSet);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"supplier.id", (QFilter[])qFilters.toArray());
        return rows.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
    }

    public static Map<Long, DynamicObject> getNoAccountSupplier(Map<Long, DynamicObject> supplierIdMap) {
        QFilter filter = new QFilter("id", "in", supplierIdMap.keySet());
        DynamicObjectCollection supCols = QueryServiceHelper.query((String)"bd_supplier", (String)"id,name,bizpartner", (QFilter[])filter.toArray());
        HashMap<Long, DynamicObject> bizpartnerIDSupMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject supCol : supCols) {
            Long bizPartnerID = supCol.getLong("bizpartner");
            if (bizPartnerID == 0L) continue;
            bizpartnerIDSupMap.put(bizPartnerID, supCol);
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("bizpartner", "in", bizpartnerIDSupMap.keySet()).and("enable", "=", (Object)"1")};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SrcItemSupplierAccountValidator", (String)"pur_supuser", (String)"bizpartner,user", (QFilter[])qFilters, (String)"user");){
            dataSet.forEach(row -> bizpartnerIDSupMap.remove(row.getLong("bizpartner")));
        }
        return bizpartnerIDSupMap;
    }

    public static QFilter getAddSupplierFilter(DynamicObject billObj, DynamicObject pBillObj, long projectId, long purlistId) {
        String addSupplierType;
        String entityId = billObj.getDataEntityType().getName();
        String pEntityId = pBillObj.getDataEntityType().getName();
        if ("pds_invitehelper".equals(entityId) && !"src_invitesupplier_chg".equals(pEntityId) && !"src_itemsupplier_chg".equals(pEntityId) && !"src_addsupplier".equals(pEntityId)) {
            return null;
        }
        QFilter supplierFilter = null;
        switch (addSupplierType = SupplierUtil.getAddSupplierType(billObj)) {
            case "0": {
                supplierFilter = SupplierUtil.getExcludedSupplierFilter(billObj, pBillObj, projectId, purlistId);
                break;
            }
            case "1": {
                supplierFilter = SupplierUtil.getProjectSupplierFilter(projectId);
                break;
            }
            case "2": {
                break;
            }
        }
        return supplierFilter;
    }

    public static String getAddSupplierType(DynamicObject billObj) {
        String entityId;
        DynamicObject projectObj = null;
        switch (entityId = billObj.getDataEntityType().getName()) {
            case "src_invitesupplier_chg": 
            case "src_itemsupplier_chg": {
                projectObj = billObj.getDynamicObject("projectf7");
                break;
            }
            case "src_addsupplier": 
            case "pds_invitehelper": {
                projectObj = billObj.getDynamicObject("project");
            }
        }
        if (null == projectObj) {
            return "2";
        }
        long projectId = projectObj.getLong("id");
        long sourceFlowId = projectObj.getLong("srctype.id");
        return PdsCommonUtils.object2String(ExtParameterUtils.getExtParameterValueById("pds_flowconfig", sourceFlowId, "isAddInviteSupplier", "2", projectId), "2");
    }

    public static QFilter getExcludedSupplierFilter(DynamicObject billObj, DynamicObject pBillObj, long projectId, long purlistId) {
        Set<Long> supplierIds = null;
        String entityId = billObj.getDataEntityType().getName();
        String pEntityId = pBillObj.getDataEntityType().getName();
        if ("src_addsupplier".equals(entityId)) {
            QFilter qfilter = null;
            if ("src_negotiatebill".equals(pEntityId)) {
                qfilter = new QFilter("entrystatus", ">=", (Object)ProjectStatusEnums.OPENED.getValue());
            }
            supplierIds = SupplierUtil.getPurlistSupplierIds(projectId, purlistId, qfilter);
        } else {
            supplierIds = "src_itemsupplier_chg".equals(entityId) ? SupplierUtil.getItemSupplierIds(projectId, purlistId) : SupplierUtil.getInviteSupplierIds(projectId);
        }
        if (null != supplierIds && supplierIds.size() > 0) {
            return new QFilter("id", "not in", supplierIds);
        }
        return null;
    }

    public static QFilter getProjectSupplierFilter(long projectId) {
        Set<Long> inviteSupplierIds = SupplierUtil.getInviteSupplierIds(projectId);
        if (null != inviteSupplierIds && inviteSupplierIds.size() > 0) {
            return new QFilter("id", "in", inviteSupplierIds);
        }
        return null;
    }

    public static Set<Long> getInviteSupplierIds(long projectId) {
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_supplierinvite", (String)"supplier.id", (QFilter[])qfilter.toArray());
        return rows.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
    }
}

