/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.enums.BidDocTypeEnums;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;

public class TemplateUtil {
    public static List<DynamicObject> getTplEntryList(DynamicObject obj, DynamicObject template) {
        ArrayList<DynamicObject> tplEntryList = new ArrayList<DynamicObject>();
        if (null == template) {
            return tplEntryList;
        }
        DynamicObjectCollection compEntryCols = obj.getDynamicObjectCollection("tplentry");
        for (DynamicObject compEntryCol : compEntryCols) {
            DynamicObject currTemplate = compEntryCol.getDynamicObject("tmp_template");
            if (null == template || !template.getPkValue().toString().equals(currTemplate.getPkValue().toString())) continue;
            tplEntryList.add(compEntryCol);
        }
        return tplEntryList;
    }

    public static List<DynamicObject> getTplEntryList(DynamicObject obj) {
        ArrayList<DynamicObject> tplEntryList = new ArrayList<DynamicObject>();
        DynamicObject template = obj.getDynamicObject("template");
        if (null == template) {
            return tplEntryList;
        }
        DynamicObjectCollection compEntryCols = obj.getDynamicObjectCollection("tplentry");
        for (DynamicObject compEntryCol : compEntryCols) {
            DynamicObject currTemplate = compEntryCol.getDynamicObject("tmp_template");
            if (null == currTemplate || !template.getPkValue().toString().equals(currTemplate.getPkValue().toString())) continue;
            tplEntryList.add(compEntryCol);
        }
        return tplEntryList;
    }

    public static List<String> getCompKeyListByTplEntry(DynamicObject obj, DynamicObject template, boolean isAttach) {
        ArrayList<String> compKeyList = new ArrayList<String>();
        if (null == template) {
            return compKeyList;
        }
        DynamicObjectCollection compEntryCols = obj.getDynamicObjectCollection("tplentry");
        for (DynamicObject compEntryCol : compEntryCols) {
            String srcTplId;
            Object component = compEntryCol.get("tmp_bizobject");
            if (null == component || component.toString().trim().length() == 0) continue;
            DynamicObject currTemplate = compEntryCol.getDynamicObject("tmp_template");
            if (null == template || !template.getPkValue().toString().equals(currTemplate.getPkValue().toString()) || isAttach && (null == (srcTplId = compEntryCol.getString("srctplid")) || srcTplId.trim().length() == 0)) continue;
            String compKey = component.toString();
            compKeyList.add(compKey);
        }
        return compKeyList;
    }

    public static List<String> getCompKeyListByTplEntry(DynamicObject obj, boolean isAttach) {
        ArrayList<String> compKeyList = new ArrayList<String>();
        DynamicObject template = obj.getDynamicObject("template");
        if (null == template) {
            return compKeyList;
        }
        DynamicObjectCollection compEntryCols = obj.getDynamicObjectCollection("tplentry");
        for (DynamicObject compEntryCol : compEntryCols) {
            String srcTplId;
            Object component = compEntryCol.get("tmp_bizobject");
            if (null == component || component.toString().trim().length() == 0) continue;
            DynamicObject currTemplate = compEntryCol.getDynamicObject("tmp_template");
            if (null == template || null == currTemplate || !template.getPkValue().toString().equals(currTemplate.getPkValue().toString()) || isAttach && (null == (srcTplId = compEntryCol.getString("srctplid")) || srcTplId.trim().length() == 0)) continue;
            String compKey = component.toString();
            compKeyList.add(compKey);
        }
        return compKeyList;
    }

    public static List<String> getAllCompKeyListByTplEntry(DynamicObject obj) {
        DynamicObjectCollection compEntryCols = obj.getDynamicObjectCollection("tplentry");
        ArrayList<String> compKeyList = new ArrayList<String>(compEntryCols.size());
        for (DynamicObject compEntryCol : compEntryCols) {
            Object component = compEntryCol.get("tmp_bizobject");
            if (null == component || component.toString().trim().length() == 0) continue;
            String compKey = component.toString();
            compKeyList.add(compKey);
        }
        return compKeyList;
    }

    public static List<String> getCompKeyListByTplEntry(DynamicObject obj) {
        return TemplateUtil.getCompKeyListByTplEntry(obj, false);
    }

    public static List<String> getCompKeyList(DynamicObject obj) {
        List<String> compKeyList = new ArrayList<String>();
        DynamicObject template = obj.getDynamicObject("template");
        if (null == template) {
            return compKeyList;
        }
        compKeyList = TemplateUtil.getCompKeyListByTemplate(template);
        return compKeyList;
    }

    public static List<String> getCompKeyListByTemplate(DynamicObject template) {
        ArrayList<String> compKeyList = new ArrayList<String>();
        if (null == template) {
            return compKeyList;
        }
        DynamicObjectCollection compEntryCols = template.getDynamicObjectCollection("compentry");
        for (DynamicObject compEntryCol : compEntryCols) {
            Object component = compEntryCol.get("bizobject");
            if (null == component || component.toString().trim().length() == 0) continue;
            String compKey = component.toString();
            compKeyList.add(compKey);
        }
        return compKeyList;
    }

    public static List<Long> getCompIdList(DynamicObject obj) {
        ArrayList<Long> compIdList = new ArrayList<Long>();
        List<String> compKeyList = TemplateUtil.getCompKeyList(obj);
        for (String compKey : compKeyList) {
            DynamicObjectCollection compCols = QueryServiceHelper.query((String)compKey, (String)"id", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)String.valueOf(obj.getPkValue()))});
            compIdList.addAll(DynamicObjectUtil.col2ListId((DynamicObjectCollection)compCols, (String)"id"));
        }
        return compIdList;
    }

    public static DynamicObject getCompData(DynamicObject obj, String compKey) {
        return TemplateUtil.getComponentData(obj.getPkValue().toString(), compKey);
    }

    public static DynamicObject getComponentData(Object pkValue, String entityKey, String compKey) {
        if ("0".equals(String.valueOf(pkValue))) {
            return null;
        }
        QFilter filter = TemplateUtil.getComponentQfilter(pkValue, entityKey, compKey);
        DynamicObject compData = QueryServiceHelper.queryOne((String)compKey, (String)"id", (QFilter[])new QFilter[]{filter});
        if (null == compData) {
            return null;
        }
        compData = BusinessDataServiceHelper.loadSingle((Object)compData.getLong("id"), (String)compKey);
        return compData;
    }

    public static DynamicObject getComponentData(String pkValue, String compKey) {
        if ("0".equals(String.valueOf(pkValue))) {
            return null;
        }
        QFilter filter = TemplateUtil.getComponentQfilter(pkValue, compKey);
        DynamicObject compData = QueryServiceHelper.queryOne((String)compKey, (String)"id", (QFilter[])new QFilter[]{filter});
        if (null == compData) {
            return null;
        }
        compData = BusinessDataServiceHelper.loadSingle((Object)compData.getLong("id"), (String)compKey);
        return compData;
    }

    public static QFilter getComponentQfilter(String pkValue, String compKey) {
        if ("".equals(pkValue)) {
            return null;
        }
        QFilter filter = new QFilter("parentid", "=", (Object)String.valueOf(pkValue));
        filter.and("entitykey", "=", (Object)compKey);
        filter.or("id", "=", (Object)Long.parseLong(pkValue));
        return filter;
    }

    public static QFilter getComponentQfilter(Object pkValue, String entityKey, String compKey) {
        QFilter filter = new QFilter("parentid", "=", (Object)String.valueOf(pkValue));
        filter.and("entitykey", "=", (Object)compKey);
        filter.and("pentitykey", "=", (Object)entityKey);
        filter.or("id", "=", (Object)PdsCommonUtils.object2Long(pkValue));
        return filter;
    }

    public static QFilter getComponentQfilter(Object pkValue, Set<String> entityKeys, String compKey) {
        QFilter filter = new QFilter("parentid", "=", (Object)String.valueOf(pkValue));
        filter.and("entitykey", "=", (Object)compKey);
        filter.and("pentitykey", "in", entityKeys);
        filter.or("id", "=", (Object)PdsCommonUtils.object2Long(pkValue));
        return filter;
    }

    public static void createTplEntryData(DynamicObject billObj, DynamicObject tarBill) {
        TemplateUtil.createTplEntryData(billObj, tarBill, false);
    }

    public static void createTplEntryData(DynamicObject billObj, DynamicObject tarBill, boolean isAttach) {
        TemplateUtil.createTplEntryData(billObj, tarBill, isAttach, null);
    }

    public static void createTplEntryData(DynamicObject billObj, DynamicObject tarBill, boolean isAttach, Set<String> allCompKeySet) {
        QFilter qfilter;
        List<DynamicObject> tplEntryList = TemplateUtil.getTplEntryList(billObj);
        Object template = tarBill.get("template");
        DynamicObject srcTemplate = billObj.getDynamicObject("template");
        DynamicObjectCollection tplEntryCols = tarBill.getDynamicObjectCollection("tplentry");
        for (DynamicObject tplEntry : tplEntryList) {
            String compKey = tplEntry.getString("tmp_bizobject");
            if (null != allCompKeySet && allCompKeySet.size() > 0 && !allCompKeySet.contains(compKey)) continue;
            DynamicObject newCol = tplEntryCols.addNew();
            DynamicObject component = tplEntry.getDynamicObject("tmp_component");
            newCol.set("tmp_template", template);
            newCol.set("tmp_component", (Object)component);
            newCol.set("tmp_bizobject", tplEntry.get("tmp_bizobject"));
            if (!isAttach) continue;
            newCol.set("srctplid", srcTemplate.getPkValue());
        }
        if (tarBill.getDataEntityType().getName().equals("tnd_quotebill") && QueryServiceHelper.exists((String)"src_biddoctplf7", (QFilter[])(qfilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj)).and("packfiletype", "=", (Object)BidDocTypeEnums.SYN_DOC.getValue())).toArray())) {
            DynamicObject newCol = tplEntryCols.addNew();
            newCol.set("tmp_template", template);
            newCol.set("tmp_bizobject", (Object)"tnd_biddoc_query");
        }
        DynamicObjectUtil.setBillEntrySeq((DynamicObject)tarBill, (String)"tplentry");
    }

    public static boolean createNegTplEntryData(DynamicObject billObj, DynamicObject tarBill, Set<String> allCompKeySet, boolean isAttach) {
        boolean isChanged = false;
        List<DynamicObject> tplEntryList = TemplateUtil.getTplEntryList(billObj);
        Object template = tarBill.get("template");
        DynamicObject srcTemplate = billObj.getDynamicObject("template");
        DynamicObjectCollection tplEntryCols = tarBill.getDynamicObjectCollection("tplentry");
        Set tarCompKeys = tplEntryCols.stream().map(e -> e.getString("tmp_bizobject")).collect(Collectors.toSet());
        for (DynamicObject tplEntry : tplEntryList) {
            String compKey = tplEntry.getString("tmp_bizobject");
            if (null != tarCompKeys && tarCompKeys.size() > 0 && tarCompKeys.contains(compKey) || Objects.equals("src_purlist_item", compKey) || !allCompKeySet.contains(compKey)) continue;
            DynamicObject newCol = tplEntryCols.addNew();
            DynamicObject component = tplEntry.getDynamicObject("tmp_component");
            newCol.set("tmp_template", template);
            newCol.set("tmp_component", (Object)component);
            newCol.set("tmp_bizobject", tplEntry.get("tmp_bizobject"));
            if (isAttach) {
                newCol.set("srctplid", srcTemplate.getPkValue());
            }
            isChanged = true;
        }
        if (tarBill.getDataEntityType().getName().equals("tnd_quotebill")) {
            QFilter qfilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj)).and("packfiletype", "=", (Object)BidDocTypeEnums.SYN_DOC.getValue());
            if (QueryServiceHelper.exists((String)"src_biddoctplf7", (QFilter[])qfilter.toArray())) {
                DynamicObject newCol = tplEntryCols.addNew();
                newCol.set("tmp_template", template);
                newCol.set("tmp_bizobject", (Object)"tnd_biddoc_query");
            }
            isChanged = true;
        }
        DynamicObjectUtil.setBillEntrySeq((DynamicObject)tarBill, (String)"tplentry");
        return isChanged;
    }

    public static void createTplEntryData(DynamicObject billObj, DynamicObject tarBill, Set<String> allCompKeySet, boolean isAttach) {
        DynamicObject template = tarBill.getDynamicObject("template");
        List<DynamicObject> tplEntryList = TemplateUtil.getTplEntryList(billObj, template);
        DynamicObject srcTemplate = billObj.getDynamicObject("template");
        DynamicObjectCollection tplEntryCols = tarBill.getDynamicObjectCollection("tplentry");
        for (DynamicObject tplEntry : tplEntryList) {
            DynamicObject newCol = tplEntryCols.addNew();
            DynamicObject component = tplEntry.getDynamicObject("tmp_component");
            String bizObject = tplEntry.getString("tmp_bizobject");
            if (!allCompKeySet.contains(bizObject)) continue;
            newCol.set("tmp_template", (Object)template);
            newCol.set("tmp_component", component.getPkValue());
            newCol.set("tmp_bizobject", (Object)bizObject);
            if (!isAttach) continue;
            newCol.set("srctplid", srcTemplate.getPkValue());
        }
        DynamicObjectUtil.setBillEntrySeq((DynamicObject)tarBill, (String)"tplentry");
    }

    public static void createTplEntryDataByTemplate(DynamicObject obj, DynamicObject template) {
        DynamicObjectCollection compEntryCols = template.getDynamicObjectCollection("compentry");
        DynamicObjectCollection tplEntryCols = obj.getDynamicObjectCollection("tplentry");
        for (DynamicObject tplEntry : compEntryCols) {
            String bizObj;
            DynamicObject newCol = tplEntryCols.addNew();
            newCol.set("tmp_template", template.getPkValue());
            DynamicObject component = tplEntry.getDynamicObject("component");
            if (null != component) {
                newCol.set("tmp_component", component.getPkValue());
            }
            if (null == (bizObj = tplEntry.getString("bizobject"))) continue;
            newCol.set("tmp_bizobject", (Object)bizObj);
        }
        DynamicObjectUtil.setBillEntrySeq((DynamicObject)obj, (String)"tplentry");
    }

    public static void setDefaultTemplate(IDataModel model, String nodeNo) {
        TemplateUtil.setDefaultTemplate(model, nodeNo, "pds_tplconfig_filter");
    }

    public static void setDefaultTemplate(IDataModel model, String nodeNo, String number) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("biznodenumber", nodeNo);
        long templateId = SchemeFilterUtils.getFirstSchemeId(model.getDataEntity(), number, paramMap);
        if (templateId > 0L) {
            model.setValue("template", (Object)templateId);
        }
        model.setDataChanged(false);
    }

    public static DynamicObject getDefaultTemplate(String nodeNo) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("biznodenumber", nodeNo);
        long templateId = SchemeFilterUtils.getFirstSchemeId(null, "pds_tplconfig_filter", paramMap);
        if (templateId > 0L) {
            return BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"pds_tplconfig");
        }
        return null;
    }

    public static void loadCompEntryData(IFormView targetView, String sourceObject, QFilter sourceQfilter, Set<String> excFields, String entryentity, String orderBy, boolean isAdd, boolean isSetId) {
        String selectfields = DynamicObjectUtil.getSelectfields((String)sourceObject, (boolean)true);
        DynamicObject[] srouceRows = BusinessDataServiceHelper.load((String)sourceObject, (String)selectfields, (QFilter[])new QFilter[]{sourceQfilter}, (String)orderBy);
        if (srouceRows == null || srouceRows.length == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)targetView.getModel();
        model.beginInit();
        if (!isAdd) {
            model.deleteEntryData(entryentity);
        }
        EntryGrid entryGrid = (EntryGrid)targetView.getControl(entryentity);
        List properties = DynamicObjectUtil.getContainerProperties((Container)entryGrid);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (int i = 0; i < srouceRows.length; ++i) {
            DynamicObject row = srouceRows[i];
            for (String pro : properties) {
                if (excFields.contains(pro)) continue;
                try {
                    if (pro.equals("srcbillid")) {
                        ts.set(pro, row.getPkValue(), i);
                        continue;
                    }
                    if (pro.equals("srcentitykey")) {
                        ts.set("srcentitykey", (Object)sourceObject, i);
                        continue;
                    }
                    if (pro.equals("srcentryid")) {
                        ts.set("srcentryid", row.getPkValue(), i);
                        continue;
                    }
                    if (pro.equals("purlistid")) {
                        ts.set(pro, row.getDynamicObject("purlist").getPkValue(), i);
                        continue;
                    }
                    if (pro.equals("supplierpk")) {
                        ts.set(pro, row.getDynamicObject("supplier").getPkValue(), i);
                        continue;
                    }
                    if (pro.equals("bidattach")) {
                        ts.set(pro, (Object)PdsCommonUtils.cloneAttachment(row, pro), i);
                        continue;
                    }
                    if (row.get(pro) instanceof DynamicObject) {
                        ts.set(pro, row.getDynamicObject(pro).getPkValue(), i);
                        continue;
                    }
                    ts.set(pro, row.get(pro), i);
                }
                catch (Exception e) {
                    BizLog.log((String)e.getMessage());
                }
            }
            if (properties.contains("packfilename") && (null == ts.get("packfilename", i) || StringUtils.isBlank((Object)ts.get("packfilename", i)))) {
                String fileName = AttachmentUtils.getAttachFileName((DynamicObjectCollection)ts.get("bidattach", i));
                ts.set("packfilename", (Object)fileName, i);
            }
            if (properties.contains("packfiletype") && "src_enrollsupplier".equals(sourceObject)) {
                ts.set("packfiletype", (Object)"6", i);
            }
            if (!isSetId) continue;
            ts.set("id", row.getPkValue(), i);
        }
        model.batchCreateNewEntryRow(entryentity, ts);
        model.endInit();
        targetView.updateView(entryentity);
    }

    public static void loadCompEntryData(IFormView targetView, String sourceObject, QFilter sourceQfilter, Set<String> excFields, String orderBy) {
        TemplateUtil.loadCompEntryData(targetView, sourceObject, sourceQfilter, excFields, "entryentity", orderBy, false);
    }

    public static void loadCompEntryData(IFormView targetView, String sourceObject, QFilter sourceQfilter, Set<String> excFields, String entryentity, String orderBy, boolean isAdd) {
        TemplateUtil.loadCompEntryData(targetView, sourceObject, sourceQfilter, excFields, entryentity, orderBy, isAdd, false);
    }

    public static DynamicObject createCompData(String entityName, long pkId, String compKey) {
        DynamicObject compDataObj = BusinessDataServiceHelper.newDynamicObject((String)compKey);
        compDataObj.set("pentitykey", (Object)entityName);
        compDataObj.set("entitykey", (Object)compKey);
        compDataObj.set("parentid", (Object)pkId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{compDataObj});
        return compDataObj;
    }

    public static Set<String> getPurListCompKeySet() {
        Set<String> purListCompKeySet = PdsMetadataUtil.getInheritMetaNumber("0F92UW2TEN+6");
        return purListCompKeySet;
    }
}

