/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class TenderSupplierUtils {
    public static boolean isExistsUnHandleTenderSupplier(DynamicObjectCollection rows, String isHandleField) {
        if (null == rows || rows.size() == 0) {
            return false;
        }
        for (DynamicObject row : rows) {
            if (!row.getBoolean("istender") || row.getBoolean(isHandleField)) continue;
            return true;
        }
        return false;
    }

    public static String getIsPushFieldByOpKey(String operationKey) {
        String isPushField = null;
        switch (operationKey) {
            case "aptpush": {
                isPushField = "isaptpush";
                break;
            }
            case "aptpush2": {
                isPushField = "isaptpush2";
                break;
            }
            case "bidpush": {
                isPushField = "isbidpush";
                break;
            }
            case "bidpublish": {
                isPushField = "isbidpublish";
                break;
            }
            case "viepublish": {
                isPushField = "isviepublish";
                break;
            }
        }
        return isPushField;
    }

    public static List<DynamicObject> getSelectedRowDatas(ExtPluginContext context) {
        IFormView parentView = context.getView().getParentView();
        if (null == parentView) {
            return Collections.emptyList();
        }
        EntryGrid entryGrid = (EntryGrid)context.getView().getControl("entryentity");
        int[] selectIndexs = entryGrid.getSelectRows();
        if (selectIndexs.length == 0) {
            context.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4f9b\u5e94\u5546\u518d\u8fdb\u884c\u5904\u7406\u3002", (String)"TenderSupplierUtils_0", (String)"scm-pds-common", (Object[])new Object[0]));
            return Collections.emptyList();
        }
        String isOpenField = TenderSupplierUtils.getIsOpenField(parentView.getModel().getDataEntity().getDataEntityType().getName());
        Set<Long> openPackageIds = TenderSupplierUtils.getOpenPackageIds(parentView.getModel().getDataEntity());
        ArrayList<Integer> selectList = new ArrayList<Integer>(8);
        IDataModel model = context.getView().getModel();
        for (int index = 0; index < selectIndexs.length; ++index) {
            DynamicObject row = model.getEntryRowEntity("entryentity", selectIndexs[index]);
            if (row.getBoolean(TenderSupplierUtils.getIsPushFieldByOpKey(context.getOperationKey())) || null != openPackageIds && !openPackageIds.contains(row.getLong("package.id")) && !row.getBoolean(isOpenField)) continue;
            selectList.add(selectIndexs[index]);
        }
        if (selectList.size() == 0) {
            context.getView().showMessage(ResManager.loadKDString((String)"\u6240\u9009\u7684\u6570\u636e\u90fd\u5df2\u5904\u7406 \u6216\u6240\u9009\u6807\u6bb5\u672a\u5f00\u6807\uff0c\u4e0d\u80fd\u8fdb\u884c\u5904\u7406\u3002", (String)"TenderSupplierUtils_2", (String)"scm-pds-common", (Object[])new Object[0]));
            return Collections.emptyList();
        }
        ArrayList<DynamicObject> selectedRowDatas = new ArrayList<DynamicObject>(16);
        for (int index = 0; index < selectList.size(); ++index) {
            DynamicObject row = model.getEntryRowEntity("entryentity", ((Integer)selectList.get(index)).intValue());
            selectedRowDatas.add(row);
        }
        return selectedRowDatas;
    }

    public static Set<Long> getOpenPackageIds(DynamicObject projectObj) {
        if (!"2".equals(projectObj.getString("managetype"))) {
            return null;
        }
        if (PdsCommonUtils.isOpenBySupplier(projectObj)) {
            return null;
        }
        QFilter qfilters = new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)projectObj));
        qfilters.and(TenderSupplierUtils.getIsOpenField(projectObj.getDataEntityType().getName()), "=", (Object)"1");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_bidopenpackage", (String)"package.id", (QFilter[])qfilters.toArray());
        if (rows == null || rows.size() == 0) {
            return null;
        }
        return rows.stream().map(row -> row.getLong("package.id")).collect(Collectors.toSet());
    }

    public static String getIsOpenField(String entityName) {
        if ("src_aptitudeaudit".equals(entityName)) {
            return "isaptopen";
        }
        if ("src_aptitudeaudit2".equals(entityName)) {
            return "istecopen";
        }
        return "istecopen";
    }

    public static Map<String, Set<Long>> getSupplier_PurlistIdSet(String entityName, long projectId, long supplierId, boolean isByPackage) {
        DynamicObject[] rows;
        HashMap<String, Set<Long>> supplier_PurlistIdSet = new HashMap<String, Set<Long>>(32);
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        if (supplierId > 0L) {
            qfilter.and("supplier", "=", (Object)supplierId);
        }
        if ((rows = BusinessDataServiceHelper.load((String)entityName, (String)"package,suppliertype,supplier,purlists", (QFilter[])qfilter.toArray())).length == 0) {
            return supplier_PurlistIdSet;
        }
        for (DynamicObject row : rows) {
            if (null == row.get("purlists")) continue;
            supplier_PurlistIdSet.put(PdsCommonUtils.getSup_Pkg_Key(row, isByPackage), MultiBasedataUtils.getBasedataIdSet(row, "purlists"));
        }
        return supplier_PurlistIdSet;
    }
}

