/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class TndQuoteUtil {
    public static void getQuoteBillEntryId(DynamicObject billObj, Set<Long> entryIds, Set<Long> purlistIds, Set<Long> packageIds) {
        DynamicObject template = billObj.getDynamicObject("template");
        if (null == template) {
            return;
        }
        List<String> compKeyList = TemplateUtil.getCompKeyListByTplEntry(billObj);
        Set<String> purlistCompKeyList = TemplateUtil.getPurListCompKeySet();
        DynamicObject compObj = null;
        for (String compKey : compKeyList) {
            if (!purlistCompKeyList.contains(compKey)) continue;
            QFilter filter = TemplateUtil.getComponentQfilter(String.valueOf(billObj.getPkValue()), compKey);
            StringBuilder selectFields = new StringBuilder();
            selectFields.append("id");
            selectFields.append(',');
            selectFields.append("entryentity");
            selectFields.append('.');
            selectFields.append("purlist");
            selectFields.append(',');
            selectFields.append("entryentity");
            selectFields.append('.');
            selectFields.append("package");
            compObj = BusinessDataServiceHelper.loadSingle((String)compKey, (String)selectFields.toString(), (QFilter[])new QFilter[]{filter});
            if (null == compObj) continue;
            DynamicObjectCollection rows = null;
            DynamicProperty property = compObj.getDynamicObjectType().getProperty("entryentity");
            if (null == property) continue;
            rows = compObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : rows) {
                entryIds.add(row.getLong("id"));
                purlistIds.add(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("purlist")));
                packageIds.add(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("package")));
            }
        }
    }

    public static Map<String, BigDecimal> calcTotalAmount(String entityName, long billId) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put("sumamount", BigDecimal.ZERO);
        resultMap.put("sumtaxamount", BigDecimal.ZERO);
        QFilter purlistFilter = new QFilter("parentid", "=", (Object)String.valueOf(billId)).and("isdiscarded", "=", (Object)"0");
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("amount");
        selectFields.append(",").append("taxamount");
        selectFields.append(",").append("currency");
        DynamicObjectCollection purlistObjs = QueryServiceHelper.query((String)"src_purlistf7", (String)selectFields.toString(), (QFilter[])new QFilter[]{purlistFilter});
        if (purlistObjs == null || purlistObjs.size() == 0) {
            return resultMap;
        }
        Long currencyId = 0L;
        BigDecimal sumAmount = BigDecimal.ZERO;
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        for (DynamicObject purlistObj : purlistObjs) {
            sumAmount = sumAmount.add(purlistObj.getBigDecimal("amount"));
            sumTaxAmount = sumTaxAmount.add(purlistObj.getBigDecimal("taxamount"));
            currencyId = purlistObj.getLong("currency");
        }
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityName, (String)"currency,project,sumamount,sumtaxamount");
        billObj.set("sumamount", (Object)sumAmount);
        billObj.set("sumtaxamount", (Object)sumTaxAmount);
        if (currencyId == 0L && billObj.getDynamicObject("currency") == null) {
            currencyId = billObj.getLong("project.currency.id");
        }
        billObj.set("currency", (Object)currencyId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
        resultMap.put("sumamount", sumAmount);
        resultMap.put("sumtaxamount", sumTaxAmount);
        return resultMap;
    }

    public static Set<Long> getAgentProjectIds() {
        QFilter qfilters = new QFilter("bidder", "=", (Object)RequestContext.get().getCurrUserId());
        HashSet<String> bizRoles = new HashSet<String>(2);
        bizRoles.add("SYS001");
        bizRoles.add("SYS018");
        qfilters.and("bizrole.number", "in", bizRoles);
        qfilters.and("project.billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_memberclarify", (String)"project.id", (QFilter[])qfilters.toArray());
        Set<Long> projectIds = rows.stream().map(e -> e.getLong("project.id")).collect(Collectors.toSet());
        return projectIds;
    }

    public static QFilter getProjectAndSupplierFilter(IFormView view) {
        QFilter qfilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity().getDynamicObject("project")));
        qfilter.and("supplier", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity().getDynamicObject("supplier")));
        return qfilter;
    }

    public static void copyDynamicObjectValue(DynamicObject sourceBillObj, DynamicObject targetBillObj) {
        List<String> properties;
        String sourceEntity = sourceBillObj.getDataEntityType().getName();
        if ("src_purlist".equals(sourceEntity)) {
            sourceEntity = "src_project";
        }
        if (null == (properties = PdsCommonUtils.getPropertiesFromFieldMapper2(sourceEntity, targetBillObj.getDataEntityType().getName())) || properties.size() == 0) {
            return;
        }
        HashSet<String> excludedFields = new HashSet<String>();
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)sourceBillObj.getPkValue(), (String)sourceEntity);
        PdsCommonUtils.copyDynamicObjectValue2(projectObj, targetBillObj, properties, excludedFields, -1, "");
    }

    public static void copyDynamicObjectValueByTarget(DynamicObject sourceBillObj, DynamicObject targetBillObj) {
        QFilter qfilter = new QFilter("targetbill", "=", (Object)targetBillObj.getDataEntityType().getName());
        qfilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"pds_fieldmapper", (String)"sourcebill.number", (QFilter[])qfilter.toArray(), (String)"number");
        long billId = PdsCommonUtils.object2Long(sourceBillObj.getPkValue());
        for (DynamicObject row : rows) {
            String sourceEntity = row.getString("sourcebill.number");
            if (!QueryServiceHelper.exists((String)sourceEntity, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)})) continue;
            List<String> properties = PdsCommonUtils.getPropertiesFromFieldMapper2(sourceEntity, targetBillObj.getDataEntityType().getName());
            if (null == properties || properties.size() == 0) {
                return;
            }
            DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)sourceEntity);
            HashSet<String> excludedFields = new HashSet<String>();
            PdsCommonUtils.copyDynamicObjectValue2(billObj, targetBillObj, properties, excludedFields, -1, "");
        }
    }
}

