/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.validator;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pds.common.util.PdsCompConfigUtil;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.PdsMustInputValidatorData;
import kd.scm.pds.common.validator.SrcValidatorData;
import org.apache.commons.collections.CollectionUtils;

public class PdsDefaultMustInputValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(PdsDefaultMustInputValidator.class);

    @Override
    public void validate(SrcValidatorData validatorData) {
        if (validatorData instanceof PdsMustInputValidatorData) {
            PdsMustInputValidatorData mustInputValidatorData = (PdsMustInputValidatorData)validatorData;
            StringBuilder validateMsg = new StringBuilder();
            Map<String, String> mustInputProMap = mustInputValidatorData.getMustInputProMap();
            for (Map.Entry<String, String> mustInputProEntry : mustInputProMap.entrySet()) {
                String proKey = mustInputProEntry.getKey();
                String[] fieldKeys = proKey.split("\\.");
                String fieldKey = null;
                String entryKey = null;
                if (fieldKeys.length > 1) {
                    entryKey = fieldKeys[0];
                    fieldKey = fieldKeys[1];
                } else {
                    fieldKey = proKey;
                }
                String displayName = mustInputProEntry.getValue();
                if (null == entryKey) {
                    validateMsg.append(this.volidateHead(mustInputValidatorData, fieldKey, displayName));
                    continue;
                }
                validateMsg.append(this.volidateEntry(mustInputValidatorData, entryKey, fieldKey, displayName));
            }
            if (validateMsg.length() > 0) {
                mustInputValidatorData.setSucced(false);
                mustInputValidatorData.setMessage(validateMsg.toString());
            } else {
                mustInputValidatorData.setSucced(true);
            }
        }
    }

    public String volidateHead(PdsMustInputValidatorData validatorData, String fieldKey, String displayName) {
        boolean isValidate = true;
        Object proVal = null;
        DynamicObject data = validatorData.getBillObj();
        IFormView view = validatorData.getView();
        Control control = null;
        if (null != view) {
            control = view.getControl(fieldKey);
        }
        if (null != control && control instanceof AttachmentPanel) {
            List attachmentData = ((AttachmentPanel)control).getAttachmentData();
            if (CollectionUtils.isEmpty((Collection)attachmentData)) {
                isValidate = false;
            }
        } else {
            proVal = data.get(fieldKey);
            isValidate = PdsCompConfigUtil.isValidate(proVal, fieldKey);
        }
        StringBuilder validateMsg = new StringBuilder();
        if (!isValidate) {
            validateMsg.append(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PdsDefaultMustInputValidator_0", (String)"scm-pds-common", (Object[])new Object[0]), displayName)).append("\u3002\r\n");
        }
        return validateMsg.toString();
    }

    public String volidateEntry(PdsMustInputValidatorData validatorData, String entryKey, String fieldKey, String displayName) {
        boolean isValidate = true;
        Object proVal = null;
        DynamicObject data = validatorData.getBillObj();
        StringBuilder validateMsg = new StringBuilder();
        try {
            DynamicObjectCollection cols = data.getDynamicObjectCollection(entryKey);
            for (int i = 0; i < cols.size(); ++i) {
                proVal = ((DynamicObject)cols.get(i)).get(fieldKey);
                isValidate = PdsCompConfigUtil.isValidate(proVal, fieldKey);
                if (isValidate) continue;
                validateMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PdsDefaultMustInputValidator_1", (String)"scm-pds-common", (Object[])new Object[0]), i + 1, displayName)).append("\u3002\r\n");
            }
        }
        catch (Exception e) {
            log.error("#####\u6570\u636e\u6821\u9a8c\u5f02\u5e38\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
        }
        return validateMsg.toString();
    }
}

