/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.PdsDefaultMustInputValidator;

public class PdsMustInputValidatorFactory {
    public static ISrcValidator getService(Object configId) {
        String plugin = PdsMustInputValidatorFactory.getValidatePluginByCompConfig(configId);
        ISrcValidator validator = null;
        if (plugin != null && plugin.trim().length() > 0) {
            try {
                validator = (ISrcValidator)Class.forName(plugin).newInstance();
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        } else {
            validator = new PdsDefaultMustInputValidator();
        }
        return validator;
    }

    public static String getValidatePluginByCompConfig(Object configId) {
        String plugin = null;
        DynamicObject compConfigObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(configId.toString()), (String)"pds_compconfig", (String)"validatorplugin");
        if (null != compConfigObj) {
            plugin = compConfigObj.getString("validatorplugin");
        }
        return plugin;
    }
}

