/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.SrcCommonValidatorHelper;

public class SrcCommonValidator
extends AbstractValidator {
    public void validate() {
        if (this.isOpenList()) {
            DynamicObject[] billObjs = this.reLoadBillObjs();
            HashMap<Long, ExtendedDataEntity> billIdExtDataEntityMap = new HashMap<Long, ExtendedDataEntity>(billObjs.length);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                billIdExtDataEntityMap.put(dataEntity.getDataEntity().getLong("id"), dataEntity);
            }
            for (int index = 0; index < billObjs.length; ++index) {
                DynamicObject billObj = billObjs[index];
                String message = SrcCommonValidatorHelper.validate(billObj, this.getEntityKey(), this.getOperateKey(), this.getOption(), null);
                if (message == null || message.length() <= 0) continue;
                this.addMessage((ExtendedDataEntity)billIdExtDataEntityMap.get(billObj.getLong("id")), message, ErrorLevel.Error);
            }
        } else {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject billObj = dataEntity.getDataEntity();
                String message = SrcCommonValidatorHelper.validate(billObj, this.getEntityKey(), this.getOperateKey(), this.getOption(), null);
                if (message == null || message.length() <= 0) continue;
                this.addMessage(dataEntity, message, ErrorLevel.Error);
            }
        }
    }

    private DynamicObject[] reLoadBillObjs() {
        DynamicObject[] billObjs = new DynamicObject[this.dataEntities.length];
        int index = 0;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            billObjs[index++] = dataEntity.getDataEntity();
        }
        Set<Long> idSet = Arrays.asList(billObjs).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        return PdsCommonUtils.loadBillObjsByIdSet(billObjs[0].getDataEntityType().getName(), idSet);
    }

    private boolean isOpenList() {
        OperateOption option = this.validateContext.getOption();
        if (null == option || null == option.getVariableValue("modeltypeforwf", null)) {
            return false;
        }
        return "list".equals(option.getVariableValue("modeltypeforwf"));
    }
}

