/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.validator;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.pds.common.validator.SrcValidatorFactory;
import kd.scm.pds.common.validator.SrcValidatorInstance;

public class SrcCommonValidatorHelper {
    public static String validate(DynamicObject billObj, String entityKey, String operateKey, IFormView view) {
        return SrcCommonValidatorHelper.validate(billObj, entityKey, operateKey, null, view);
    }

    public static String validate(DynamicObject billObj, String entityKey, String operateKey, OperateOption option, IFormView view) {
        StringBuilder sb = new StringBuilder();
        SrcValidatorData validatorData = new SrcValidatorData();
        validatorData.setBillObj(billObj);
        validatorData.setBizObject(entityKey);
        validatorData.setOperation(operateKey);
        validatorData.setView(view);
        validatorData.setOption(option);
        List<SrcValidatorInstance> validatorList = SrcValidatorFactory.getInstance().getValidatorList(validatorData);
        if (validatorList == null || validatorList.size() == 0) {
            return null;
        }
        for (int i = 0; i < validatorList.size(); ++i) {
            ISrcValidator validator = validatorList.get(i).getValidator();
            if (null == validator) continue;
            validatorData.setSucced(true);
            validatorData.setMessage("");
            validatorData.setPluginId(validatorList.get(i).getId());
            validatorData.setPluginName(validatorList.get(i).getPluginName());
            validatorData.setPluginRemark(validatorList.get(i).getRemark());
            validator.validate(validatorData);
            if (validatorData.isSucced()) continue;
            if (validatorData.getMessage() != null && validatorData.getMessage().length() > 0) {
                sb = sb.append(validatorData.getMessage()).append('\n');
            }
            if (validatorList.get(i).getRemark() == null || validatorList.get(i).getRemark().length() <= 0) continue;
            sb = sb.append(validatorList.get(i).getRemark()).append('\n');
        }
        return sb.toString();
    }
}

