/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.entity.PdsObjectPools;
import kd.scm.pds.common.extfilter.ExtFilterContext;
import kd.scm.pds.common.extfilter.ExtFilterFactory;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extfilter.FilterGridUtils;
import kd.scm.pds.common.extfilter.IExtFilterPlugin;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.pds.common.validator.SrcValidatorInstance;

public class SrcValidatorFactory {
    public List<SrcValidatorInstance> getValidatorList(SrcValidatorData validatorData) {
        List<SrcValidatorInstance> validatorList = SrcValidatorFactory.getValidatorPlugin(validatorData);
        if (validatorList == null || validatorList.size() == 0) {
            return validatorList;
        }
        for (int i = 0; i < validatorList.size(); ++i) {
            try {
                String plugName = validatorList.get(i).getPluginName();
                ISrcValidator instance = (ISrcValidator)PdsObjectPools.getInstance(plugName);
                if (null != instance) {
                    validatorList.get(i).setValidator(instance);
                    continue;
                }
                instance = (ISrcValidator)Class.forName(plugName).newInstance();
                if (null == instance) continue;
                validatorList.get(i).setValidator(instance);
                PdsObjectPools.putInstance(plugName, instance);
                continue;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return validatorList;
    }

    private SrcValidatorFactory() {
    }

    public static SrcValidatorFactory getInstance() {
        return SingletonHolder.SINSTANCE;
    }

    public static List<SrcValidatorInstance> getValidatorPlugin(SrcValidatorData validatorData) {
        String selectFields;
        DynamicObject[] rows;
        ArrayList<SrcValidatorInstance> instanceList = new ArrayList<SrcValidatorInstance>(8);
        String bizObject = validatorData.getBizObject();
        String operation = validatorData.getOperation();
        if (bizObject == null || operation == null) {
            return instanceList;
        }
        QFilter qFilter = new QFilter("bizobject.number", "=", (Object)bizObject).and("operation", "=", (Object)operation).and("status", "=", (Object)BillStatusEnum.AUDIT.getVal()).and("enable", "=", (Object)"1");
        QFilter extFilter = SrcValidatorFactory.getValidatorExtFilter(validatorData);
        if (null != extFilter) {
            qFilter.and(extFilter);
        }
        if ((rows = BusinessDataServiceHelper.load((String)"pds_validatorconfig", (String)(selectFields = "id,pluginname,remark,order,changetype2,sourcetype2,srctype2"), (QFilter[])new QFilter[]{qFilter}, (String)"order")) == null || rows.length == 0) {
            return instanceList;
        }
        String sourceType = ExtFilterUtils.getSourceTypeField(validatorData.getBillObj());
        String sourceFlow = ExtFilterUtils.getSourceFlowField(validatorData.getBillObj());
        long sourceTypeId = null == validatorData.getBillObj() ? 0L : ExtFilterUtils.getSourceFlowOrSourceTypeId(validatorData.getBillObj(), sourceType);
        long sourceFlowId = null == validatorData.getBillObj() ? 0L : ExtFilterUtils.getSourceFlowOrSourceTypeId(validatorData.getBillObj(), sourceFlow);
        long changeTypeId = null == validatorData.getBillObj() ? 0L : ExtFilterUtils.getChangeTypeId(validatorData.getBillObj());
        for (DynamicObject row : rows) {
            if (sourceTypeId > 0L && ExtFilterUtils.isNeedExclude(sourceTypeId, row, "sourcetype2") || sourceFlowId > 0L && ExtFilterUtils.isNeedExclude(sourceFlowId, row, "srctype2") || changeTypeId > 0L && ExtFilterUtils.isNeedExclude(changeTypeId, row, "changetype2")) continue;
            SrcValidatorInstance instance = new SrcValidatorInstance();
            instance.setId(row.getLong("id"));
            instance.setPluginName(row.getString("pluginname"));
            instance.setRemark(row.getString("remark"));
            instanceList.add(instance);
        }
        return instanceList;
    }

    public static QFilter getValidatorExtFilter(SrcValidatorData validatorData) {
        List extFilters;
        ExtFilterContext context = new ExtFilterContext();
        context.setProjectObj(validatorData.getBillObj());
        Map<String, Object> qfilterMap = FilterGridUtils.getQFilter("pds_extfilter", ISrcValidator.class.getSimpleName());
        context.setQfilter((QFilter)qfilterMap.get("qfilter"));
        if (!StringUtils.isBlank((Object)qfilterMap.get("description"))) {
            context.setDescription(new StringBuilder(qfilterMap.get("description").toString()));
        }
        if (null != (extFilters = ExtFilterFactory.getInstance().getExtFilterInstance("pds_extfilter", ISrcValidator.class.getSimpleName())) && extFilters.size() > 0) {
            for (IExtFilterPlugin extFilter : extFilters) {
                extFilter.buildQFilter(context);
            }
        }
        return context.getQfilter();
    }

    private static class SingletonHolder {
        private static final SrcValidatorFactory SINSTANCE = new SrcValidatorFactory();

        private SingletonHolder() {
        }
    }
}

