/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.vie;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsSortUtils;
import kd.scm.pds.common.vie.IPdsVieProcess;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;

public class PdsVieSumAndRankHandler
implements IPdsVieProcess {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsVieContext context) {
        if (null == context.getQuoteData() || context.getQuoteData().size() == 0) {
            return;
        }
        HashMap<String, Map<String, BigDecimal>> proSumMap = new HashMap<String, Map<String, BigDecimal>>(32);
        HashMap<String, BigDecimal> proAmountMap = new HashMap<String, BigDecimal>(32);
        HashMap<String, Map<String, BigDecimal>> pkgSumMap = new HashMap<String, Map<String, BigDecimal>>(32);
        HashMap<Long, Map<String, BigDecimal>> pkgId_SumMap = new HashMap<Long, Map<String, BigDecimal>>(32);
        HashMap<String, Integer> sortedProMap = new HashMap<String, Integer>(32);
        HashMap<String, Integer> sortedPkgMap = new HashMap<String, Integer>(32);
        HashSet<Long> vieDetailIds = new HashSet<Long>(32);
        this.calcSumAmount(context, proSumMap, proAmountMap, pkgSumMap, pkgId_SumMap, vieDetailIds);
        this.sortSumAmount(context, proAmountMap, pkgId_SumMap, sortedProMap, sortedPkgMap);
        this.updateVieHall(context, proSumMap, pkgSumMap, sortedProMap, sortedPkgMap);
        if (PdsVieHelper.isSupplierCommitData(context)) {
            this.updateVieDetail(context, proSumMap, pkgSumMap, sortedProMap, sortedPkgMap, vieDetailIds);
        }
    }

    public void calcSumAmount(PdsVieContext context, Map<String, Map<String, BigDecimal>> proSumMap, Map<String, BigDecimal> proAmountMap, Map<String, Map<String, BigDecimal>> pkgSumMap, Map<Long, Map<String, BigDecimal>> pkgId_SumMap, Set<Long> vieDetailIds) {
        String taxType = context.getVieBillObj().getString("taxtype");
        for (Map.Entry<String, List<DynamicObject>> entry : context.getQuoteData().entrySet()) {
            for (DynamicObject row : entry.getValue()) {
                String prokey = row.getString("supplier");
                this.calcSumMap(row, prokey, proSumMap, proAmountMap, taxType);
                String pkgkey = this.getSupPkgKey(row, "2", true);
                long pkgId = row.getLong("purlist.package.id");
                Map<String, BigDecimal> pkgAmountMap = pkgId_SumMap.get(pkgId);
                if (null == pkgAmountMap) {
                    pkgAmountMap = new HashMap<String, BigDecimal>(32);
                }
                this.calcSumMap(row, pkgkey, pkgSumMap, pkgAmountMap, taxType);
                pkgId_SumMap.put(pkgId, pkgAmountMap);
                vieDetailIds.add(row.getLong("id"));
            }
        }
    }

    public void sortSumAmount(PdsVieContext context, Map<String, BigDecimal> proAmountMap, Map<Long, Map<String, BigDecimal>> pkgId_SumMap, Map<String, Integer> sortedProMap, Map<String, Integer> sortedPkgMap) {
        boolean isDesc = "B".equals(context.getVieBillObj().getString("vietype"));
        sortedProMap.putAll(PdsSortUtils.getRankFromSortedList(PdsSortUtils.mapSortByValue(proAmountMap, isDesc)));
        for (Map.Entry<Long, Map<String, BigDecimal>> entry : pkgId_SumMap.entrySet()) {
            sortedPkgMap.putAll(PdsSortUtils.getRankFromSortedList(PdsSortUtils.mapSortByValue(entry.getValue(), isDesc)));
        }
    }

    public void updateVieHall(PdsVieContext context, Map<String, Map<String, BigDecimal>> proSumMap, Map<String, Map<String, BigDecimal>> pkgSumMap, Map<String, Integer> sortedProMap, Map<String, Integer> sortedPkgMap) {
        for (Map.Entry<String, List<DynamicObject>> entry : context.getQuoteData().entrySet()) {
            for (DynamicObject row : entry.getValue()) {
                this.updateVlue(row, proSumMap, pkgSumMap, sortedProMap, sortedPkgMap, true);
            }
        }
    }

    public void updateVieDetail(PdsVieContext context, Map<String, Map<String, BigDecimal>> proSumMap, Map<String, Map<String, BigDecimal>> pkgSumMap, Map<String, Integer> sortedProMap, Map<String, Integer> sortedPkgMap, Set<Long> vieDetailIds) {
        DynamicObject[] rows;
        QFilter qfilter = new QFilter("id", "in", vieDetailIds);
        String selectfields = "supplier,purlist,prorank,proamount,protaxamount,pkgrank,pkgamount,pkgtaxamount";
        for (DynamicObject row : rows = BusinessDataServiceHelper.load((String)"src_vie_detailf7", (String)selectfields, (QFilter[])qfilter.toArray())) {
            this.updateVlue(row, proSumMap, pkgSumMap, sortedProMap, sortedPkgMap, false);
        }
        PdsCommonUtils.saveDynamicObjects(rows);
    }

    public void calcSumMap(DynamicObject row, String key, Map<String, Map<String, BigDecimal>> sumMap, Map<String, BigDecimal> orderMap, String taxType) {
        Map<String, BigDecimal> valueMap = sumMap.get(key);
        if (null == valueMap) {
            valueMap = new HashMap<String, BigDecimal>(2);
            valueMap.put("locamount", row.getBigDecimal("locamount"));
            valueMap.put("loctaxamount", row.getBigDecimal("loctaxamount"));
        } else {
            valueMap.put("locamount", valueMap.get("locamount").add(row.getBigDecimal("locamount")));
            valueMap.put("loctaxamount", valueMap.get("loctaxamount").add(row.getBigDecimal("loctaxamount")));
        }
        sumMap.put(key, valueMap);
        if ("2".equals(taxType)) {
            orderMap.put(key, valueMap.get("locamount"));
        } else {
            orderMap.put(key, valueMap.get("loctaxamount"));
        }
    }

    public void updateVlue(DynamicObject row, Map<String, Map<String, BigDecimal>> proSumMap, Map<String, Map<String, BigDecimal>> pkgSumMap, Map<String, Integer> sortedProMap, Map<String, Integer> sortedPkgMap, boolean isVieHall) {
        String pkgkey;
        Map<String, BigDecimal> pkgValueMap;
        String prokey = this.getSupPkgKey(row, "1", isVieHall);
        Map<String, BigDecimal> proValueMap = proSumMap.get(prokey);
        if (null != proValueMap) {
            row.set("prorank", (Object)sortedProMap.get(prokey));
            row.set("proamount", (Object)proValueMap.get("locamount"));
            row.set("protaxamount", (Object)proValueMap.get("loctaxamount"));
        }
        if (null != (pkgValueMap = pkgSumMap.get(pkgkey = this.getSupPkgKey(row, "2", isVieHall)))) {
            row.set("pkgrank", (Object)sortedPkgMap.get(pkgkey));
            row.set("pkgamount", (Object)pkgValueMap.get("locamount"));
            row.set("pkgtaxamount", (Object)pkgValueMap.get("loctaxamount"));
        }
    }

    public String getSupPkgKey(DynamicObject row, String sumType, boolean isVieHall) {
        String supPkgkey;
        String string = supPkgkey = isVieHall ? row.getString("supplier") : row.getString("supplier.id");
        if ("2".equals(sumType)) {
            supPkgkey = supPkgkey + "_" + row.getString("purlist.package.id");
        }
        return supPkgkey;
    }
}

