/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.Html;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.mytask.SrcMyTaskFacade;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsBenefitClarifyPlugin
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.showProjectInfo();
    }

    private void showProjectInfo() {
        Set handleIds = SrcMyTaskFacade.getHandleIdsFromView((IFormView)this.getView());
        if (handleIds == null) {
            return;
        }
        Map resultMap = SrcMyTaskFacade.getProjectInfoByHandleIds((Set)handleIds);
        DynamicObject[] myTaskObjs = SrcMyTaskFacade.getMyTaskByHandleIds((Set)handleIds);
        Map<String, List<DynamicObject>> projectMap = Arrays.asList(myTaskObjs).stream().collect(Collectors.groupingBy(e -> e.getString("project.id")));
        Set<Long> projectIds = projectMap.keySet().stream().map(e -> Long.valueOf(e)).collect(Collectors.toSet());
        String supplierInfo = this.getSupplierInfo(projectIds);
        String content = null;
        QFilter qFilter = new QFilter("biznode.number", "=", (Object)"01").and("letterstype", "=", (Object)"7");
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"pds_doctpl", (String)"content", (QFilter[])new QFilter[]{qFilter}, (String)"isdefault desc,number");
        if (rows != null && rows.length > 0) {
            content = rows[0].getString("content");
            content = content.replace("{supplier}", supplierInfo);
            content = content.replace("{billno}", (CharSequence)resultMap.get("billno"));
            content = content.replace("{bidname}", (CharSequence)resultMap.get("bidname"));
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append((String)resultMap.get("billno")).append("<br>");
            sb.append((String)resultMap.get("bidname")).append("<br>");
            sb.append(supplierInfo).append("<br>");
            content = sb.toString();
        }
        Html html = (Html)this.getControl("content");
        html.setConent(content);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "clarify": {
                if (this.getModel().getValue("radiogroupfield") == null || this.getModel().getValue("radiogroupfield").equals("")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u662f\u5426\u6709\u5229\u76ca\u5173\u7cfb\u51b2\u7a81\uff0c\u518d\u8fdb\u884c\u786e\u8ba4\u3002", (String)"PdsBenefitClarifyPlugin_0", (String)"scm-pds-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (this.getModel().getValue("radiogroupfield").equals("2") && (this.getModel().getValue("description") == null || this.getModel().getValue("description").toString().trim().equals(""))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5229\u76ca\u5173\u7cfb\u51b2\u7a81\uff0c\u8bf7\u586b\u7533\u62a5\u4fe1\u606f\u3002", (String)"PdsBenefitClarifyPlugin_1", (String)"scm-pds-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                this.clarifyHandle();
            }
        }
    }

    private void clarifyHandle() {
        Set handleIds = SrcMyTaskFacade.getHandleIdsFromView((IFormView)this.getView());
        if (handleIds != null && handleIds.size() > 0) {
            SrcMyTaskContext context = new SrcMyTaskContext();
            context.setHandleIds(handleIds);
            boolean isnobenifit = this.getModel().getValue("radiogroupfield").equals("1");
            context.setIsnobenifit(isnobenifit);
            String description = this.getModel().getDataEntity().getString("description");
            context.setDescription(description);
            SrcMyTaskFacade.ClarifyHandle((SrcMyTaskContext)context);
            this.getView().showMessage(context.getHandleMessage());
            PdsCommonUtils.refreshParentView((IFormView)this.getView());
        }
    }

    private String getSupplierInfo(Set<Long> projectIds) {
        StringBuilder sb = new StringBuilder();
        QFilter qfilters = new QFilter("billid", "in", projectIds).and("isinvite", "=", (Object)"1");
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_supplierinvite", (String)"suppliertype,supplier.name", (QFilter[])qfilters.toArray());
        Set supplierSet = Arrays.asList(rows).stream().filter(row -> null != row.getString("supplier.name")).map(row -> row.getString("supplier.name")).collect(Collectors.toSet());
        for (String supplier : supplierSet) {
            if (sb.toString().trim().length() == 0) {
                sb = sb.append(supplier);
                continue;
            }
            sb = sb.append(',').append(supplier);
        }
        return sb.toString();
    }
}

