/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.scm.pds.common.enums.ImportMode;

public class PdsDataImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"view", "importmodel", "btncancel", "btnok"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    private void setSaveByResIsEmpty() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        List list = attachmentPanel.getAttachmentData();
        this.getView().setEnable(Boolean.valueOf(!list.isEmpty()), new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        this.setSaveByResIsEmpty();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("import".equals(args.getOperateKey())) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
            List attDataList = attachmentPanel.getAttachmentData();
            ArrayList fileUrls = new ArrayList(attDataList.size());
            ArrayList fileNames = new ArrayList(1);
            attDataList.stream().forEach(it -> {
                fileUrls.add(it.get("url").toString());
                fileNames.add(it.get("name").toString());
            });
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            String importmode = this.getModel().getValue("importmodel").toString();
            if ("ignore".equalsIgnoreCase(importmode)) {
                paramMap.put("IMPORT_MODE", ImportMode.IGNORED);
            } else {
                paramMap.put("IMPORT_MODE", ImportMode.OVERWRITE);
            }
            String entityKey = (String)this.getView().getFormShowParameter().getCustomParam("entitykey");
            paramMap.put("entitykey", entityKey);
            if (fileUrls.size() > 0) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("pds_dataimporting");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("fileUrls", fileUrls);
                showParameter.setCustomParam("fileNames", fileNames);
                showParameter.setCustomParam("parammap", paramMap);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importdata"));
                this.getView().showForm(showParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getActionId().equals("importdata") && null != event.getReturnData() && event.getReturnData().equals(Boolean.TRUE)) {
            this.getView().returnDataToParent((Object)Boolean.TRUE);
            this.getView().close();
        }
    }

    public void afterUpload(UploadEvent evt) {
        this.setSaveByResIsEmpty();
    }

    public void afterRemove(UploadEvent evt) {
        this.setSaveByResIsEmpty();
    }
}

