/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.scm.pds.common.dataimport.DataImportResponse;
import kd.scm.pds.common.enums.ImportStatus;
import kd.scm.pds.common.util.ExportAndDownloadUtil;
import kd.scm.pds.common.util.ExportUtil;
import kd.scm.pds.common.util.ImportUtil;
import kd.scm.pds.common.util.PdsExceptionUtil;

public class PdsJobExecutorPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log LOG = LogFactory.getLog(PdsJobExecutorPlugin.class);
    private int total = 0;
    private List<String> fileUrls;
    private List<String> fileNames;
    private Map<String, Object> param;
    private boolean flag = true;

    public void afterCreateNewData(EventObject e) {
        this.fileUrls = (List)this.getView().getFormShowParameter().getCustomParam("fileUrls");
        this.fileNames = (List)this.getView().getFormShowParameter().getCustomParam("fileNames");
        this.param = (Map)this.getView().getFormShowParameter().getCustomParam("parammap");
        if (CollectionUtils.isNotEmpty(this.fileUrls)) {
            this.total = this.fileUrls.size();
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"download"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ProgressBar progressBar = (ProgressBar)this.getControl("job_progress");
        progressBar.setPercent(0, ResManager.loadKDString((String)"\u7b49\u5f85\u4e2d\u2026", (String)"PdsJobExecutorPlugin_0", (String)"scm-pds-formplugin", (Object[])new Object[0]));
        progressBar.start();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ArrayList<DataImportResponse> result = new ArrayList<DataImportResponse>();
        this.work(result);
        ProgressBar progressBar = (ProgressBar)this.getControl("job_progress");
        if (this.flag) {
            progressBar.setPercent(100, ResManager.loadKDString((String)"\u5bfc\u5165\u5b8c\u6210", (String)"PdsJobExecutorPlugin_1", (String)"scm-pds-formplugin", (Object[])new Object[0]));
            progressBar.stop();
            this.showJobDescription("job_result", this.buildResult(result));
            this.showJobDescription("job_resultdesc", this.buildJobResultDesc(result));
            String errorStr = this.buildErrorDesc(result);
            if (StringUtils.isNotEmpty((CharSequence)errorStr)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"download"});
            }
            this.getView().getPageCache().put("errorLog", errorStr);
        } else {
            progressBar.setPercent(100, ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"PdsJobExecutorPlugin_2", (String)"scm-pds-formplugin", (Object[])new Object[0]));
            progressBar.stop();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("job_progress");
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equalsIgnoreCase("download")) {
            String errorLog = this.getView().getPageCache().get("errorLog");
            String fp = ExportUtil.createTxt((String)errorLog);
            String fileName = "errorLog_" + System.currentTimeMillis() + ".txt";
            try {
                ExportAndDownloadUtil.download((IFormView)this.getView(), (String)fp, (String)fileName);
            }
            catch (Exception e) {
                LOG.error("download log error", (Throwable)e);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent((Object)Boolean.TRUE);
    }

    private void work(List<DataImportResponse> result) {
        for (int i = 0; i < this.total; ++i) {
            String url = this.fileUrls.get(i);
            String fileName = this.fileNames.get(i);
            try (InputStream inputStream = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(url);){
                this.param.put("fileName", fileName);
                List importResponses = ImportUtil.importDts((InputStream)inputStream, this.param);
                result.addAll(importResponses);
                continue;
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(fileName + " import failed");
                this.showJobDescription("job_resultdesc", fileName + PdsExceptionUtil.toString((Throwable)ex));
                this.showJobDescription("job_result", ResManager.loadKDString((String)"\u5bfc\u5165\u53d1\u751f\u4e2d\u65ad\u9519\u8bef", (String)"PdsJobExecutorPlugin_3", (String)"scm-pds-formplugin", (Object[])new Object[0]));
                this.flag = false;
                break;
            }
        }
    }

    private void showJobDescription(String controlName, String desc) {
        Label label = (Label)this.getView().getControl(controlName);
        label.setText(desc);
    }

    public String buildResult(List<DataImportResponse> result) {
        StringBuilder desc = new StringBuilder();
        desc.append(ResManager.loadKDString((String)"\u6210\u529f\u6587\u4ef6\uff1a%1$s\u4e2a\uff0c\u5931\u8d25\u6587\u4ef6\uff1a%2$s\u4e2a\uff0c\u5ffd\u7565\u6587\u4ef6\uff1a%3$s\u4e2a", (String)"PdsJobExecutorPlugin_4", (String)"scm-pds-formplugin", (Object[])new Object[0]));
        int failCnt = 0;
        int ignoreCnt = 0;
        int successCnt = (int)result.stream().filter(it -> !it.isRef() && it.getStatus() == ImportStatus.SUCCESS || !it.getEntityName().equals("") && it.isRef() && it.getStatus() == ImportStatus.SUCCESS).count();
        failCnt = (int)result.stream().filter(it -> it.getStatus() == ImportStatus.FAILED).count();
        ignoreCnt = (int)result.stream().filter(it -> it.getStatus() == ImportStatus.IGNORED).count();
        return String.format(desc.toString(), successCnt, failCnt, ignoreCnt);
    }

    public String buildJobResultDesc(List<DataImportResponse> result) {
        StringBuilder desc = new StringBuilder();
        result.forEach(it -> {
            String name;
            String isRef = ResManager.loadKDString((String)"\uff08\u5f15\u7528\u8d44\u6e90\uff09", (String)"PdsJobExecutorPlugin_5", (String)"scm-pds-formplugin", (Object[])new Object[0]);
            String string = name = it.isRef() ? isRef + "[" + it.getEntityTitle() + "]" + it.getNumber() : "[" + it.getEntityTitle() + "]" + it.getNumber();
            if (it.getStatus() == ImportStatus.FAILED) {
                String message = StringUtils.isEmpty((CharSequence)it.getMessage()) ? ResManager.loadKDString((String)"\u672a\u77e5\u9519\u8bef\u3002", (String)"PdsJobExecutorPlugin_6", (String)"scm-pds-formplugin", (Object[])new Object[0]) : it.getMessage();
                String msg = ResManager.loadKDString((String)"%1$s\uff1a\u5bfc\u5165\u5931\u8d25--->%2$s", (String)"PdsJobExecutorPlugin_13", (String)"scm-pds-formplugin", (Object[])new Object[0]);
                desc.append(String.format(msg, name, message));
                desc.append('\n');
            } else if (it.getStatus() == ImportStatus.IGNORED) {
                desc.append(name);
                desc.append('\uff1a');
                desc.append(ResManager.loadKDString((String)"\u5df2\u5ffd\u7565--->\u6570\u636e\u5df2\u5b58\u5728\uff0c\u4e0d\u518d\u5bfc\u5165", (String)"PdsJobExecutorPlugin_11", (String)"scm-pds-formplugin", (Object[])new Object[0]));
                desc.append('\n');
            } else if (it.getStatus() == ImportStatus.SUCCESS) {
                desc.append(it.getEntityTitle());
                desc.append('_');
                desc.append(it.getNumber());
                desc.append('\uff1a');
                desc.append(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"PdsJobExecutorPlugin_12", (String)"scm-pds-formplugin", (Object[])new Object[0]));
                desc.append('\n');
            }
        });
        return desc.toString();
    }

    public String buildErrorDesc(List<DataImportResponse> result) {
        StringBuilder desc = new StringBuilder();
        result.forEach(it -> {
            if (it.getStatus() == ImportStatus.FAILED) {
                String isRef = ResManager.loadKDString((String)"\uff08\u5f15\u7528\u8d44\u6e90\uff09", (String)"PdsJobExecutorPlugin_5", (String)"scm-pds-formplugin", (Object[])new Object[0]);
                String name = it.isRef() ? isRef + "[" + it.getEntityTitle() + "]" + it.getNumber() : "[" + it.getEntityTitle() + "]" + it.getNumber();
                String msg = ResManager.loadKDString((String)"%1$s\uff1a\u5bfc\u5165\u5931\u8d25--->%2$s,%3$s", (String)"PdsJobExecutorPlugin_14", (String)"scm-pds-formplugin", (Object[])new Object[0]);
                desc.append(String.format(msg, name, it.getMessage(), PdsExceptionUtil.toString((Throwable)it.getErr())));
                desc.append('\n');
            }
        });
        return desc.toString();
    }

    public void onProgress(ProgressEvent progressEvent) {
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getActionId().equals("importdata") && null != event.getReturnData() && event.getReturnData().equals(Boolean.TRUE)) {
            this.getView().setReturnData((Object)Boolean.TRUE);
            this.getView().close();
        }
    }
}

