/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.sqlscript.PreInsDataScriptBuilder;

public class PdsKsqlPlugin
extends AbstractFormPlugin
implements ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btngenksql"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button bt = (Button)evt.getSource();
        switch (bt.getKey()) {
            case "btngenksql": {
                this.batchCreateKSql();
                break;
            }
        }
    }

    public void batchCreateKSql() {
        ArrayList<SqlParams> sqlParamList = new ArrayList<SqlParams>();
        sqlParamList.addAll(this.wrapBatchSql());
        StringBuilder sqlSb = new StringBuilder();
        for (SqlParams sqlParam : sqlParamList) {
            String sql = this.createKSql(sqlParam);
            if (StringUtils.isEmpty((CharSequence)sql)) continue;
            sqlSb.append(sql).append("\n");
        }
        if (sqlSb.toString().trim().length() == 0) {
            this.getView().showTipNotification("not find query ksql data.");
            return;
        }
        CodeEdit codeSQLshow1 = (CodeEdit)this.getView().getControl("ksqltext");
        int maxLength = 1000000;
        if (sqlSb.length() > maxLength) {
            codeSQLshow1.setText(String.format(ResManager.loadKDString((String)"\u811a\u672c\u592a\u5927\uff0c\u5c06\u88ab\u622a\u65ad ...%1$s%2$s%3$s", (String)"PdsKsqlPlugin_4", (String)"scm-pds-formplugin", (Object[])new Object[0]), new Object[0], System.lineSeparator(), sqlSb.substring(0, maxLength)));
        } else {
            codeSQLshow1.setText(sqlSb.toString());
        }
    }

    public List<SqlParams> wrapBatchSql() {
        IDataModel model = this.getModel();
        String batchSql = String.valueOf(model.getValue("batchsql_tag"));
        String routefield = String.valueOf(model.getValue("routefield"));
        ArrayList<SqlParams> sqlParamList = new ArrayList<SqlParams>();
        if (!StringUtils.isBlank((CharSequence)batchSql)) {
            String[] sqlStrArrys;
            String billid = String.valueOf(model.getValue("billid"));
            String newbatchSql = batchSql;
            if (StringUtils.isNotEmpty((CharSequence)billid)) {
                newbatchSql = batchSql.replaceAll("#billid", billid);
            }
            for (String sqlStr : sqlStrArrys = newbatchSql.split(";")) {
                String newSqlStr = sqlStr.replaceAll("\n", "").trim();
                if (newSqlStr.length() == 0) continue;
                String[] sqlPros = newSqlStr.split("&");
                SqlParams sqlParams = new SqlParams();
                block17: for (int i = 0; i < sqlPros.length; ++i) {
                    String[] pros = sqlPros[i].split(":");
                    switch (pros[0]) {
                        case "textfield": {
                            sqlParams.setTextfield(pros[1]);
                            continue block17;
                        }
                        case "routefield": {
                            sqlParams.setRoutefield(pros[1]);
                            continue block17;
                        }
                        case "selectfield": {
                            sqlParams.setSelectField(pros[1]);
                            continue block17;
                        }
                        case "fromfield": {
                            sqlParams.setFromfield(pros[1]);
                            continue block17;
                        }
                        case "wherefield": {
                            sqlParams.setWherefield(pros[1]);
                            continue block17;
                        }
                        case "orderfield": {
                            sqlParams.setOrderfield(pros[1]);
                            continue block17;
                        }
                    }
                }
                if (null == sqlParams.getRoutefield()) {
                    sqlParams.setRoutefield(routefield);
                }
                sqlParamList.add(sqlParams);
            }
        }
        return sqlParamList;
    }

    public String createKSql(SqlParams sqlParams) {
        String textfield = sqlParams.getTextfield();
        String routefield = sqlParams.getRoutefield();
        String selectField = sqlParams.getSelectField();
        String fromfield = sqlParams.getFromfield();
        String sql = null;
        IFormView view = this.getView();
        if (StringUtils.isBlank((CharSequence)routefield)) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u5e93:%1$s", (String)"PdsKsqlPlugin_5", (String)"scm-pds-formplugin", (Object[])new Object[0]), sqlParams.toString()));
        } else if (StringUtils.isBlank((CharSequence)fromfield)) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u8868\u540d:%1$s", (String)"PdsKsqlPlugin_6", (String)"scm-pds-formplugin", (Object[])new Object[0]), sqlParams.toString()));
        } else if (StringUtils.isBlank((CharSequence)selectField)) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u5b57\u6bb5\u540d:%1$s", (String)"PdsKsqlPlugin_7", (String)"scm-pds-formplugin", (Object[])new Object[0]), sqlParams.toString()));
        } else {
            Map sqlMap;
            PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
            String wherefield = sqlParams.getWherefield();
            String orderfield = sqlParams.getOrderfield();
            try {
                sqlMap = builder.genInsertSQLScript(DBRoute.of((String)routefield.trim()), fromfield, selectField, wherefield, orderfield, textfield);
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
            }
            sql = (String)sqlMap.get("sql");
            sql = sql.replaceAll("0E-10", "0");
        }
        return sql;
    }

    public static class SqlParams {
        String routefield;
        String textfield;
        String selectField;
        String fromfield;
        String wherefield;
        String orderfield;

        public String getRoutefield() {
            return this.routefield;
        }

        public SqlParams setRoutefield(String routefield) {
            this.routefield = routefield;
            return this;
        }

        public String getTextfield() {
            return this.textfield;
        }

        public SqlParams setTextfield(String textfield) {
            this.textfield = textfield;
            return this;
        }

        public String getSelectField() {
            return this.selectField;
        }

        public SqlParams setSelectField(String selectField) {
            this.selectField = selectField;
            return this;
        }

        public String getFromfield() {
            return this.fromfield;
        }

        public SqlParams setFromfield(String fromfield) {
            this.fromfield = fromfield;
            return this;
        }

        public String getWherefield() {
            if (null != this.wherefield && !this.wherefield.endsWith(";")) {
                return this.wherefield + ";";
            }
            return this.wherefield;
        }

        public SqlParams setWherefield(String wherefield) {
            this.wherefield = wherefield;
            return this;
        }

        public String getOrderfield() {
            return this.orderfield;
        }

        public SqlParams setOrderfield(String orderfield) {
            this.orderfield = orderfield;
            return this;
        }
    }
}

