/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class PdsTplSetPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.createCompData();
    }

    private void createCompData() {
        if (!PdsCommonUtils.isValidBillType((IFormView)this.getView().getParentView())) {
            return;
        }
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        paramMap.put("project", this.getView().getParentView().getModel().getDataEntity());
        QFilter qfilter = ExtFilterUtils.getExtQFilters((String)"pds_extfilter", (String)"pds_compreg_filter", (IFormView)this.getView().getParentView(), (Map)paramMap);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"pds_compreg", (String)"id", (QFilter[])qfilter.toArray(), (String)"number");
        int i = 0;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (DynamicObject col : objs) {
            ts.set("component", col.get("id"), i);
            ++i;
        }
        if (i > 0) {
            model.batchCreateNewEntryRow("entryentity", ts);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("confirm".equals(operateKey)) {
            EntryGrid entry = (EntryGrid)this.getView().getControl("entryentity");
            int[] selRows = entry.getSelectRows();
            if (selRows.length == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"PdsTplSetPlugin_0", (String)"scm-pds-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<DynamicObject> componentList = new ArrayList<DynamicObject>(selRows.length);
            ArrayList<Object> componentIdList = new ArrayList<Object>(selRows.length);
            for (int selRow : selRows) {
                DynamicObject component = (DynamicObject)this.getModel().getValue("component", selRow);
                if (null == component) continue;
                componentIdList.add(component.getPkValue());
                componentList.add(component);
            }
            this.updateTemplateData(componentList);
            HashMap<String, ArrayList<Object>> returnData = new HashMap<String, ArrayList<Object>>();
            returnData.put("componentId", componentIdList);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private void updateTemplateData(List<DynamicObject> componentList) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object entityKey = params.get("entitykey");
        if (null == entityKey) {
            return;
        }
        long billId = PdsCommonUtils.object2Long(params.get("billid"));
        if (billId == 0L) {
            return;
        }
        DynamicObject billObj = BusinessDataServiceHelper.newDynamicObject((String)entityKey.toString());
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)billId, (DynamicObjectType)billObj.getDynamicObjectType());
        if (null == obj) {
            return;
        }
        DynamicObject currTemplate = obj.getDynamicObject("template");
        if (null == currTemplate) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6a21\u677f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u9009\u62e9\u7ec4\u4ef6\u3002", (String)"PdsTplSetPlugin_1", (String)"scm-pds-formplugin", (Object[])new Object[0]));
            return;
        }
        String currTplIdStr = currTemplate.getPkValue().toString();
        DynamicObjectCollection cols = obj.getDynamicObjectCollection("tplentry");
        ArrayList<DynamicObject> needDelEntryList = new ArrayList<DynamicObject>();
        ArrayList<String> needDelCompList = new ArrayList<String>();
        for (DynamicObject col : cols) {
            DynamicObject template = col.getDynamicObject("tmp_template");
            if (template == null || SrmCommonUtil.getPkValue((DynamicObject)template) == 0L) {
                return;
            }
            String templateIdStr = template.getPkValue().toString();
            if (templateIdStr == null) {
                return;
            }
            if (null != template && templateIdStr.equals(currTplIdStr)) {
                needDelEntryList.add(col);
                needDelCompList.add(col.getString("tmp_bizobject"));
                continue;
            }
            String srcTplId = col.getString("srctplid");
            if (!srcTplId.equals(currTplIdStr)) continue;
            needDelEntryList.add(col);
        }
        cols.removeAll(needDelEntryList);
        String currNode = obj.getString("currentnode.bizobject.number");
        if ("src_project".equals(currNode) || "src_purlist".equals(currNode)) {
            this.deleteCompData(obj, needDelCompList);
        }
        for (DynamicObject component : componentList) {
            DynamicObject entry = cols.addNew();
            entry.set("tmp_template", currTemplate.getPkValue());
            entry.set("tmp_component", component.getPkValue());
            DynamicObject bizObject = component.getDynamicObject("bizobject");
            if (null == bizObject) continue;
            entry.set("tmp_bizobject", (Object)bizObject.getString("number"));
        }
        DynamicObjectUtil.setBillEntrySeq((DynamicObject)obj, (String)"tplentry");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    private void deleteCompData(DynamicObject obj, List<String> needDelCompList) {
        if (needDelCompList == null || needDelCompList.size() == 0) {
            return;
        }
        DynamicObjectType type = null;
        for (int i = 0; i < needDelCompList.size(); ++i) {
            DynamicObject compObj;
            String compKey = needDelCompList.get(i);
            if (null == compKey || compKey.trim().length() == 0 || (compObj = TemplateUtil.getCompData((DynamicObject)obj, (String)compKey)) == null || !StringUtils.isBlank((CharSequence)obj.getString("srcbillid")) && compObj.getBoolean("ispurlistcomp")) continue;
            Object[] pks = new Long[1];
            type = compObj.getDynamicObjectType();
            pks[0] = SrmCommonUtil.getPkValue((DynamicObject)compObj);
            DeleteServiceHelper.delete((IDataEntityType)type, (Object[])pks);
        }
    }
}

