/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.function.IGetValFunction;
import kd.scm.pds.common.util.PdsCompConfigUtil;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.PdsMustInputValidatorData;
import kd.scm.pds.common.validator.PdsMustInputValidatorFactory;
import kd.scm.pds.common.validator.SrcValidatorData;
import org.apache.commons.lang3.StringUtils;

public class PdsBidComponentEdit
extends AbstractBillPlugIn {
    private static final String ISFROMQUOTOOL = "isFromQuoTool";

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOpreation) {
        super.beforeDoOperation(beforeDoOpreation);
        AbstractOperate operate = (AbstractOperate)beforeDoOpreation.getSource();
        String opKey = operate.getOperateKey();
        String configOperate = this.getValidateOpreate();
        if (opKey.equals(configOperate)) {
            StringBuilder validateMsg = new StringBuilder();
            this.validateMustInputPro(validateMsg);
            if (validateMsg.length() > 0) {
                beforeDoOpreation.setCancel(true);
                beforeDoOpreation.setCancelMessage(validateMsg.toString());
                return;
            }
        }
    }

    protected String getValidateOpreate() {
        String operate = "";
        if (!this.getModel().isDataLoaded()) {
            return operate;
        }
        Object compConfigId = this.getModel().getValue("compconfigid");
        if (null == compConfigId || String.valueOf(compConfigId).trim().length() == 0) {
            return operate;
        }
        DynamicObject compConfig = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(compConfigId.toString()), (String)"pds_compconfig");
        String compOpreate = compConfig.getString("operate");
        operate = null != compOpreate && compOpreate.trim().length() > 0 ? compOpreate : "submit";
        return operate;
    }

    protected void validateMustInputPro(StringBuilder validateMsg) {
        Object compConfigId = this.getModel().getValue("compconfigid");
        if (null == compConfigId || String.valueOf(compConfigId).trim().length() == 0) {
            return;
        }
        DynamicObject data = this.getModel().getDataEntity(true);
        Map mustInputProMap = PdsCompConfigUtil.getMustInputValByCompConfig((Object)compConfigId);
        ISrcValidator validator = PdsMustInputValidatorFactory.getService((Object)compConfigId);
        IFormView view = this.getView();
        if (null != validator) {
            PdsMustInputValidatorData validatorData = new PdsMustInputValidatorData();
            validatorData.setBillObj(data);
            validatorData.setMustInputProMap(mustInputProMap);
            validatorData.setBizObject(view.getEntityId());
            validatorData.setView(view);
            validator.validate((SrcValidatorData)validatorData);
            if (!validatorData.isSucced()) {
                validateMsg.append(validatorData.getMessage());
                return;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setAppId();
        this.setFeildsCtr();
        this.setParentInfo();
        this.getModel().setDataChanged(false);
    }

    private void setAppId() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String appId = parentView.getModel().getDataEntityType().getAppId();
        if (StringUtils.equals((CharSequence)appId, (CharSequence)"tnd")) {
            this.getModel().setValue("origin", (Object)"2");
        } else {
            this.getModel().setValue("origin", (Object)"1");
        }
    }

    private void setParentInfo() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        try {
            this.getModel().setValue("pentitykey", (Object)parentView.getEntityId());
            this.getModel().setValue("pbillstatus", (Object)this.getView().getParentView().getModel().getDataEntity().getString("billstatus"));
            this.getModel().setValue("pbizstatus", (Object)parentView.getModel().getDataEntity().getString("bizstatus"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setFeildsCtr() {
        String compKey = this.getView().getEntityId();
        DynamicObject obj = this.getObjData();
        List<String> matchProList = this.getGroupPros();
        DynamicObject compConfig = PdsCompConfigUtil.getCompConfig((DynamicObject)obj, (String)compKey, matchProList, (IGetValFunction)this.getFunction());
        IDataModel model = this.getModel();
        if (null == compConfig) {
            model.setValue("compconfigid", (Object)"");
            return;
        }
        model.setValue("compconfigid", compConfig.getPkValue());
        model.setValue("comppageconfig", compConfig.getPkValue());
        IFormView view = this.getView();
        Map propetiesMap = PdsMetadataUtil.getProMap((String)compKey);
        DynamicObjectCollection cols = compConfig.getDynamicObjectCollection("entryentity");
        for (DynamicObject col : cols) {
            Control control;
            String fieldId = col.getString("fieldid");
            if (null == fieldId || null == propetiesMap.get(fieldId)) continue;
            String[] fieldKeys = fieldId.split("\\.");
            String fieldKey = null;
            String entryKey = null;
            if (fieldKeys.length > 1) {
                entryKey = fieldKeys[0];
                fieldKey = fieldKeys[1];
            } else {
                fieldKey = fieldId;
            }
            boolean isVisible = col.getBoolean("isvisible");
            view.setVisible(Boolean.valueOf(isVisible), new String[]{fieldKey});
            if (!isVisible) continue;
            String displayname = col.getString("displayname");
            if (!StringUtils.isEmpty((CharSequence)displayname) && (control = this.getControl(fieldKey)) instanceof FieldEdit) {
                ((FieldEdit)control).setCaption(new LocaleString(displayname));
            }
            boolean isEditable = col.getBoolean("iseditable");
            if (null != entryKey) {
                this.setEntryEnable(entryKey, fieldKey, isEditable);
            } else {
                view.setEnable(Boolean.valueOf(isEditable), new String[]{fieldKey});
            }
            boolean isMustinput = col.getBoolean("ismustinput");
            if (null != entryKey) {
                EntryGrid entry = (EntryGrid)this.getControl(entryKey);
                entry.setMustInput(fieldKey, isMustinput);
                continue;
            }
            Control control2 = this.getControl(fieldKey);
            if (control2 instanceof FieldEdit) {
                ((FieldEdit)control2).setMustInput(isMustinput);
                continue;
            }
            if (!(control2 instanceof AttachmentPanel)) continue;
        }
    }

    private void setEntryEnable(String entryKey, String fieldKey, boolean isEditable) {
        this.getView().setEnable(Boolean.valueOf(isEditable), -1, new String[]{fieldKey});
    }

    protected DynamicObject getObjData() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return null;
        }
        String pageId = this.getView().getParentView().getPageId();
        parentView = SessionManager.getCurrent().getView(pageId);
        if (null == parentView) {
            return null;
        }
        return parentView.getModel().getDataEntity();
    }

    protected List<String> getGroupPros() {
        return PdsCompConfigUtil.getGroupKeys();
    }

    protected IGetValFunction getFunction() {
        return PdsCompConfigUtil.getFunction(this.getSpecialFields(), this.getSpecialBills());
    }

    protected Set<String> getSpecialFields() {
        return PdsCompConfigUtil.getSpecialFields();
    }

    protected Set<String> getSpecialBills() {
        return PdsCompConfigUtil.getSpecialBills();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
        e.setCheckDataChange(true);
    }
}

