/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsChgCompReloadDataTpl
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (!PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        if (this.isNeedReload()) {
            this.reloadBillData();
            this.reloadEntryData();
        }
    }

    protected void reloadBillData() {
    }

    protected void reloadEntryData() {
    }

    protected boolean isNeedReload() {
        if (!this.isSaveStatus()) {
            return false;
        }
        if (this.isChgSrcBillId()) {
            return true;
        }
        return this.isBillEmpty() || this.isEntryEmpty();
    }

    protected boolean isSaveStatus() {
        String billStatus = null;
        try {
            billStatus = this.getView().getParentView().getModel().getDataEntity().getString("billstatus");
        }
        catch (Exception e) {
            billStatus = this.getModel().getDataEntity().getString("billstatus");
        }
        return StringUtils.isBlank((CharSequence)billStatus) || BillStatusEnum.SAVE.getVal().equals(billStatus);
    }

    protected boolean isChgSrcBillId() {
        long chgSrcBillId = this.getChgSrcBillId(this.getView().getParentView().getModel().getDataEntity());
        if (chgSrcBillId == 0L) {
            return false;
        }
        if (chgSrcBillId != this.getModel().getDataEntity().getLong("chgsrcbillid")) {
            this.getModel().setValue("chgsrcbillid", (Object)chgSrcBillId);
            return true;
        }
        return false;
    }

    protected boolean isBillEmpty() {
        return false;
    }

    protected boolean isEntryEmpty() {
        try {
            DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
            if (null != rows && rows.size() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private long getChgSrcBillId(DynamicObject bidChgObj) {
        if (null == bidChgObj) {
            return 0L;
        }
        String changeSource = PdsCommonUtils.object2String((Object)bidChgObj.getString("changesource"), (String)"3");
        if ("1".equals(changeSource)) {
            return bidChgObj.getLong("apply.id");
        }
        if ("2".equals(changeSource)) {
            return bidChgObj.getLong("demand.id");
        }
        return bidChgObj.getLong("project.id");
    }
}

