/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;

public class PdsCompConfigEdit
extends AbstractBillPlugIn {
    protected static final String[] pros = new String[]{"isvisible", "iseditable", "ismustinput", "isexport", "isimport", "iswriteback", "isclearup"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolBar = (Toolbar)this.getControl("tbmain");
        if (null != toolBar) {
            toolBar.addItemClickListener((ItemClickListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setOperateListValue(this.getModel().getDataEntity().getDynamicObject("biznode"));
        PdsCommonUtils.setIsvId((IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        if ("component".equals(proName)) {
            ChangeData[] changeData = e.getChangeSet();
            Object newVal = changeData[0].getNewValue();
            if (null != newVal && newVal instanceof DynamicObject) {
                this.reloadField();
            } else {
                HashMap<String, String> propetiesLinkMap = new HashMap<String, String>(1);
                this.createEntryData(propetiesLinkMap);
            }
        } else if ("biznode".equals(proName)) {
            ChangeData[] changeData = e.getChangeSet();
            Object newVal = changeData[0].getNewValue();
            DynamicObject bizNode = null;
            if (null != newVal && newVal instanceof DynamicObject) {
                bizNode = (DynamicObject)newVal;
            }
            this.setComponentByBizNode(bizNode);
            this.setOperateListValue(bizNode);
        }
    }

    private void setOperateListValue(DynamicObject bizNode) {
        if (null == bizNode) {
            ComboEdit entityOpCombo = (ComboEdit)this.getView().getControl("operate");
            entityOpCombo.setComboItems(new ArrayList());
            this.getModel().setValue("operate", (Object)"");
        } else {
            PdsCommonUtils.setOperateListValue((IFormView)this.getView(), (DynamicObject)bizNode.getDynamicObject("bizobject"), (String)"operate");
        }
    }

    private void setComponentByBizNode(DynamicObject bizNode) {
        IDataModel model = this.getModel();
        Object bidCompId = "";
        if (null != bizNode) {
            DynamicObject compoent = model.getDataEntity().getDynamicObject("component");
            if (null == compoent) {
                return;
            }
            QFilter queryFilter = new QFilter("id", "=", compoent.getPkValue());
            queryFilter.and("biznode", "=", bizNode.getPkValue());
            boolean isExists = QueryServiceHelper.exists((String)"pds_compreg", (QFilter[])new QFilter[]{queryFilter});
            if (isExists) {
                return;
            }
            DynamicObject bizObject = compoent.getDynamicObject("bizobject");
            if (null == bizObject) {
                return;
            }
            String number = bizObject.getString("number");
            QFilter filter = new QFilter("biznode", "=", bizNode.getPkValue());
            filter.and("bizobject.number", "=", (Object)number);
            DynamicObject bidComp = QueryServiceHelper.queryOne((String)"pds_compreg", (String)"id", (QFilter[])new QFilter[]{filter});
            if (null != bidComp) {
                bidCompId = bidComp.get("id");
            }
        }
        model.setValue("component", bidCompId);
    }

    private void createEntryData(Map<String, String> propetiesLinkMap) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        int i = 0;
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (Map.Entry<String, String> propeties : propetiesLinkMap.entrySet()) {
            ts.set("fieldid", (Object)propeties.getKey(), i);
            ts.set("fieldname", (Object)propeties.getValue(), i);
            ++i;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("reloadfield".equals(itemKey)) {
            this.reloadField();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u52a0\u8f7d\u5b57\u6bb5\u6210\u529f\u3002", (String)"PdsCompConfigEdit_0", (String)"scm-pds-formplugin", (Object[])new Object[0]));
        }
    }

    private void reloadField() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject data = model.getDataEntity(true);
        DynamicObject component = data.getDynamicObject("component");
        if (null == component) {
            return;
        }
        DynamicObjectCollection cols = data.getDynamicObjectCollection("entryentity");
        HashMap<String, DynamicObject> field_objMap = new HashMap<String, DynamicObject>(16);
        for (int i = 0; i < cols.size(); ++i) {
            DynamicObject col = (DynamicObject)cols.get(i);
            String fieldId = col.getString("fieldid");
            field_objMap.put(fieldId, col);
        }
        DynamicObject bizObj = component.getDynamicObject("bizobject");
        String entityKey = bizObj.getString("number");
        Map propetiesLinkMap = PdsMetadataUtil.getProMap((String)entityKey);
        model.deleteEntryData("entryentity");
        int i = 0;
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (Map.Entry propeties : propetiesLinkMap.entrySet()) {
            String proKey = (String)propeties.getKey();
            ts.set("fieldid", (Object)proKey, i);
            ts.set("fieldname", propeties.getValue(), i);
            DynamicObject obj = (DynamicObject)field_objMap.get(proKey);
            if (null != obj) {
                for (String pro : pros) {
                    ts.set(pro, obj.get(pro), i);
                }
                ts.set("id", obj.getPkValue(), i);
            } else {
                for (String pro : pros) {
                    ts.set(pro, (Object)false, i);
                }
            }
            ++i;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }
}

