/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.extfilter.FilterGridUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class PdsCompRefreshEdit
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String BTNNEXT = "btnnext";
    private static final String BTNPREV = "btnprev";
    private static final String GUIDECONTENT = "guidecontent";
    private static final String PROJECTDATATAB = "tabpageap1";
    private static final String COMPREFRESHTAB = "tabpageap2";
    private static final String SELPROJECT = "selproject";
    private static final String SELECTENTRY = "selectentry";

    public void registerListener(EventObject e) {
        EntryGrid selEntryControl;
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNNEXT, BTNPREV});
        EntryGrid entryControl = (EntryGrid)this.getControl("entryentity");
        if (null != entryControl) {
            entryControl.addHyperClickListener((HyperLinkClickListener)this);
        }
        if (null != (selEntryControl = (EntryGrid)this.getControl(SELECTENTRY))) {
            selEntryControl.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void click(EventObject evt) {
        String itemKey;
        super.click(evt);
        switch (itemKey = ((Control)evt.getSource()).getKey()) {
            case "btnnext": {
                String nextTabKey = this.getNextTabKey();
                if (PROJECTDATATAB.equals(nextTabKey)) {
                    this.createProjectData();
                    break;
                }
                if (!COMPREFRESHTAB.equals(nextTabKey)) break;
                this.countSelData();
                break;
            }
        }
    }

    private String getNextTabKey() {
        Tab tab = (Tab)this.getView().getControl(GUIDECONTENT);
        String currentTab = tab.getCurrentTab();
        String nextTabKey = null;
        for (int i = 0; i < tab.getItems().size() && !currentTab.equals(((Control)tab.getItems().get(tab.getItems().size() - 1)).getKey()); ++i) {
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            nextTabKey = ((Control)tab.getItems().get(i + 1)).getKey();
            break;
        }
        return nextTabKey;
    }

    private void createProjectData() {
        QFilter filter = this.getNodeFilter();
        if (null == filter) {
            return;
        }
        String entityName = this.getNodeEntityKey();
        String orderBy = "createtime desc";
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])filter.toArray(), (String)orderBy);
        this.getModel().deleteEntryData("entryentity");
        if (cols.size() == 0) {
            return;
        }
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (int i = 0; i < cols.size(); ++i) {
            DynamicObject col = (DynamicObject)cols.get(i);
            ts.set("project", col.get("id"), i);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    private QFilter getNodeFilter() {
        QFilter filter = null;
        Object bizNode = this.getModel().getValue("biznode");
        if (bizNode != null) {
            FilterCondition condition = FilterGridUtils.getCondition((IFormView)this.getView());
            String entityName = this.getNodeEntityKey();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, condition);
            filterBuilder.buildFilter();
            filter = filterBuilder.getQFilter();
            Map paramMap = this.getView().getFormShowParameter().getCustomParams();
            long templateId = PdsCommonUtils.object2Long(paramMap.get("billid"));
            if (null == filter) {
                filter = new QFilter("template", "=", (Object)templateId);
            } else {
                filter.and("template", "=", (Object)templateId);
            }
        }
        return filter;
    }

    private void countSelData() {
        this.getModel().deleteEntryData(SELECTENTRY);
        List<Long> selIdList = this.getSelectProjectId();
        Label label = (Label)this.getControl("number");
        String labelText = ResManager.loadKDString((String)"\u60a8\u5171\u9009\u62e9\u4e86%s\u5f20\u5355\u636e\u5f85\u5237\u65b0\u7ec4\u4ef6\u3002", (String)"PdsCompRefreshEdit_0", (String)"scm-pds-formplugin", (Object[])new Object[0]);
        label.setText(String.format(labelText, selIdList.size()));
        if (selIdList.size() == 0) {
            return;
        }
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (int i = 0; i < selIdList.size(); ++i) {
            ts.set(SELPROJECT, (Object)selIdList.get(i), i);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow(SELECTENTRY, ts);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "comprefresh": {
                this.compRefresh();
                break;
            }
        }
    }

    private void compRefresh() {
        DynamicObject[] objs;
        List<Long> selIdList = this.getSelectProjectId();
        DynamicObject template = this.getModel().getDataEntity().getDynamicObject("template");
        List templateCompKeyList = TemplateUtil.getCompKeyListByTemplate((DynamicObject)template);
        ArrayList<DynamicObject> needSaveObjs = new ArrayList<DynamicObject>();
        for (DynamicObject obj : objs = this.getSelData(selIdList)) {
            List billCompKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)obj);
            Set<String> diffCompKeySet = this.getDiffCompKeySet(templateCompKeyList, billCompKeyList);
            if (diffCompKeySet.size() == 0) continue;
            this.createTplentryData(obj, template, diffCompKeySet);
            needSaveObjs.add(obj);
        }
        String message = ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f%s\u5f20\u5355\u636e\u3002", (String)"PdsCompRefreshEdit_3", (String)"scm-pds-formplugin", (Object[])new Object[0]);
        if (needSaveObjs.size() > 0) {
            message = String.format(message, needSaveObjs.size());
            SaveServiceHelper.save((DynamicObject[])needSaveObjs.toArray(new DynamicObject[0]));
        } else {
            message = ResManager.loadKDString((String)"\u6a21\u677f\u4e0a\u7684\u7ec4\u4ef6\u5355\u636e\u4e0a\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u5237\u65b0\u3002", (String)"PdsCompRefreshEdit_4", (String)"scm-pds-formplugin", (Object[])new Object[0]);
        }
        this.updateBillStatus(needSaveObjs);
        this.getView().showSuccessNotification(message, Integer.valueOf(5000));
    }

    private void updateBillStatus(List<DynamicObject> needSaveObjs) {
        HashMap<Long, DynamicObject> idCompObjMap = new HashMap<Long, DynamicObject>(needSaveObjs.size());
        for (DynamicObject obj : needSaveObjs) {
            idCompObjMap.put(obj.getLong("id"), obj);
        }
        DynamicObjectCollection selectEntryCols = this.getModel().getEntryEntity(SELECTENTRY);
        for (int i = 0; i < selectEntryCols.size(); ++i) {
            DynamicObject selProject = ((DynamicObject)selectEntryCols.get(i)).getDynamicObject(SELPROJECT);
            if (null != idCompObjMap.get(selProject.get("id"))) {
                this.getModel().setValue("status", (Object)"1", i);
                continue;
            }
            this.getModel().setValue("status", (Object)"2", i);
        }
    }

    private List<Long> getSelectProjectId() {
        ArrayList<Long> selIdList = new ArrayList<Long>(16);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selRows = entryGrid.getSelectRows();
        if (selRows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5237\u65b0\u7684\u5355\u636e\u3002", (String)"PdsCompRefreshEdit_1", (String)"scm-pds-formplugin", (Object[])new Object[0]));
            return selIdList;
        }
        int maxSize = 500;
        if (selRows.length > maxSize) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u9009\u62e9%s\u6761\u6570\u636e\u5237\u65b0\u3002", (String)"PdsCompRefreshEdit_2", (String)"scm-pds-formplugin", (Object[])new Object[0]), maxSize));
            return selIdList;
        }
        maxSize = selRows.length;
        for (int i = 0; i < selRows.length; ++i) {
            Object projectF7 = this.getModel().getValue("project", selRows[i]);
            if (null == projectF7) continue;
            selIdList.add(((DynamicObject)projectF7).getLong("id"));
        }
        return selIdList;
    }

    public void createTplentryData(DynamicObject billObj, DynamicObject template, Set<String> diffCompKeySet) {
        DynamicObjectCollection tplEntryCols = billObj.getDynamicObjectCollection("tplentry");
        DynamicObjectCollection compEntryCols = template.getDynamicObjectCollection("compentry");
        IDataEntityProperty propBizObject = (IDataEntityProperty)tplEntryCols.getDynamicObjectType().getProperties().get((Object)"tmp_bizobject");
        IDataEntityProperty propTemplate = (IDataEntityProperty)tplEntryCols.getDynamicObjectType().getProperties().get((Object)"tmp_template");
        IDataEntityProperty propComponent = (IDataEntityProperty)tplEntryCols.getDynamicObjectType().getProperties().get((Object)"tmp_component");
        for (DynamicObject col : compEntryCols) {
            String bizObj = col.getString("bizobject");
            if (null == bizObj || !diffCompKeySet.contains(bizObj)) continue;
            DynamicObject newEntry = tplEntryCols.addNew();
            propBizObject.setValueFast((Object)newEntry, (Object)bizObj);
            propTemplate.setValueFast((Object)newEntry, template.getPkValue());
            DynamicObject component = col.getDynamicObject("component");
            if (null == component) continue;
            propComponent.setValueFast((Object)newEntry, component.getPkValue());
        }
        DynamicObjectUtil.setBillEntrySeq((DynamicObject)billObj, (String)"tplentry");
    }

    private DynamicObject[] getSelData(List<Long> selIdList) {
        String entityName = this.getNodeEntityKey();
        String selectProperties = "id,template,tplentry.seq,tplentry.tmp_template,tplentry.tmp_component,tplentry.tmp_bizobject";
        QFilter filter = new QFilter("id", "in", selIdList);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])filter.toArray());
        return objs;
    }

    private Set<String> getDiffCompKeySet(List<String> templateCompKeyList, List<String> billCompKeyList) {
        HashSet<String> compKeySet = new HashSet<String>();
        HashMap<String, String> billCompKeyMap = new HashMap<String, String>(templateCompKeyList.size());
        for (String compKey : billCompKeyList) {
            billCompKeyMap.put(compKey, compKey);
        }
        for (String compKey : templateCompKeyList) {
            String billCompKey = (String)billCompKeyMap.get(compKey);
            if (null != billCompKey) continue;
            compKeySet.add(compKey);
        }
        return compKeySet;
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.setDefaultValue();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setEntityNumber();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldkey;
        switch (fieldkey = e.getProperty().getName()) {
            case "biznode": {
                this.setEntityNumber();
                break;
            }
        }
    }

    private void setEntityNumber() {
        String entityName = this.getNodeEntityKey();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        filterGrid.setEntityNumber(entityName);
        filterGrid.bindData(null);
    }

    private void setDefaultValue() {
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        long bizNodeId = PdsCommonUtils.object2Long(paramMap.get("biznode"));
        long templateId = PdsCommonUtils.object2Long(paramMap.get("billid"));
        this.getModel().setValue("biznode", (Object)bizNodeId);
        this.getModel().setValue("template", (Object)templateId);
    }

    private String getNodeEntityKey() {
        String entityName = null;
        Object bizNode = this.getModel().getValue("biznode");
        if (bizNode != null) {
            entityName = ((DynamicObject)bizNode).getString("bizobject.number");
        }
        return entityName;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        Object projectF7 = this.getModel().getValue(fieldName, rowIndex);
        if (null != projectF7) {
            Long projectId = ((DynamicObject)projectF7).getLong("id");
            OpenFormUtils.openBillPage((IFormView)this.getView(), (String)this.getNodeEntityKey(), (Object)projectId, (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
        }
    }
}

