/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.mvc.SessionManager;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsCompTplEdit
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u52a0\u8f7d\u4e2d", (String)"PdsCompTplEdit_0", (String)"scm-pds-formplugin", (Object[])new Object[0])));
        this.getView().addClientCallBack("dataLoadedCallBack");
        String pageId = parentView.getPageId();
        parentView = SessionManager.getCurrent().getView(pageId);
        if (null == parentView) {
            return;
        }
        this.setMainOrg(parentView);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        String pageId = parentView.getPageId();
        parentView = SessionManager.getCurrent().getView(pageId);
        if (null == parentView) {
            return;
        }
        String compKey = this.getView().getEntityId();
        String cacheKey = pageId + "_" + compKey + "_" + "unloadcompcount";
        String unloadComp_count = (String)this.getCache().get(cacheKey, String.class);
        if (null != unloadComp_count) {
            Integer compCount = Integer.parseInt(unloadComp_count);
            compCount = compCount - 1;
            this.getCache().put(cacheKey, (Object)String.valueOf(compCount));
        }
        this.getModel().setDataChanged(false);
    }

    private void setMainOrg(IFormView parentView) {
        DynamicObject obj = parentView.getModel().getDataEntity();
        DynamicObject org = null;
        try {
            org = obj.getDynamicObject("org");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == org) {
            return;
        }
        this.getModel().setValue("mainorg", org.getPkValue());
        try {
            this.getModel().setValue("projectf7", this.getProjectId(parentView, obj));
            this.getModel().setValue("compbillno", obj.get("billno"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object getProjectId(IFormView parentView, DynamicObject obj) {
        if (PdsCommonUtils.getNotProjectBill().contains(parentView.getEntityId())) {
            DynamicObject projectObj = null;
            try {
                projectObj = obj.getDynamicObject("project");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null == projectObj) {
                return 0L;
            }
            return projectObj.getPkValue();
        }
        return obj.getPkValue();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOerationEvent) {
        String operateKey;
        super.beforeDoOperation(beforeDoOerationEvent);
        AbstractOperate operate = (AbstractOperate)beforeDoOerationEvent.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": 
            case "submit": {
                this.setEntryParentId();
                if (!beforeDoOerationEvent.isCancel()) break;
                this.getView().hideLoading();
                break;
            }
        }
    }

    protected void setEntryParentId() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        Map<String, String> entry_parentIdMap = this.getEntryParentIdMap();
        IDataModel model = this.getModel();
        if (!model.isDataLoaded()) {
            return;
        }
        String parentIdVal = model.getDataEntity().getString("parentid");
        for (Map.Entry<String, String> entry_parentIdEntry : entry_parentIdMap.entrySet()) {
            try {
                String entryKey = entry_parentIdEntry.getKey();
                DynamicObjectCollection cols = model.getEntryEntity(entryKey);
                String parentIdKey = entry_parentIdEntry.getValue();
                if (null == parentIdKey) continue;
                int rowCount = cols.size();
                for (int i = 0; i < rowCount; ++i) {
                    model.setValue(parentIdKey, (Object)parentIdVal, i);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (null != result && !result.isSuccess()) {
            this.getView().hideLoading();
        }
    }

    protected Map<String, String> getEntryParentIdMap() {
        HashMap<String, String> entry_parentIdMap = new HashMap<String, String>(4);
        entry_parentIdMap.put("entryentity", "entryparentid");
        return entry_parentIdMap;
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if ("dataLoadedCallBack".equals(e.getName())) {
            this.getView().hideLoading();
        }
    }

    public IAppCache getCache() {
        return AppCache.get((String)"pds");
    }
}

