/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.pds.common.costdetail.PdsCostDetailCalcEntryAmount;
import kd.scm.pds.common.edit.AbstractBillImportEdit;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCalculateUtils;
import kd.scm.pds.common.util.PdsCompConfigUtil;
import kd.scm.pds.common.util.PdsCompRegUtil;
import kd.scm.pds.common.util.PdsCostDetailUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;

public class PdsCostDetail1CompImportEdit
extends AbstractBillImportEdit {
    private Map<String, String> mustInputProMap = null;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initBtn();
    }

    public void initBtn() {
        Set entityKeySet;
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        Map customParams = parentView.getFormShowParameter().getCustomParams();
        Object pEntityKey = customParams.get("pentitykey");
        String entityKey = "";
        if (null != pEntityKey) {
            entityKey = String.valueOf(pEntityKey);
        }
        if ((entityKeySet = PdsCostDetailUtils.allowSetCostDetailEntitys()).contains(entityKey)) {
            view.setVisible(Boolean.TRUE, new String[]{"importdata"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"importdata"});
        }
    }

    public String getExportDataTitile() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        String parentEntityKey = parentView.getEntityId();
        String entityKey = this.getModel().getDataEntityType().getName();
        String fileName = DateUtil.date2str((Date)new Date(), (String)"yyyyMMddHHmmss");
        String title = PdsCompRegUtil.getCompTitleByBidComp((String)parentEntityKey, (String)entityKey);
        if (null != title) {
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)parentEntityKey);
            String parentName = type.getDisplayName().toString();
            String regEx = "[ \\\\`~!@#$%^*+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]|\n|\r|\t";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(parentName);
            while (m.find()) {
                String group = m.group(0);
                parentName = parentName.replace(group, "_");
            }
            fileName = parentName + title + fileName;
        }
        return fileName;
    }

    public String getExportTplTitle() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        String parentEntityKey = this.getView().getParentView().getEntityId();
        String entityKey = this.getModel().getDataEntityType().getName();
        String fileName = ResManager.loadKDString((String)"\u6a21\u677f", (String)"PdsCostDetail1CompImportEdit_0", (String)"scm-pds-formplugin", (Object[])new Object[0]);
        String title = PdsCompRegUtil.getCompTitleByBidComp((String)parentEntityKey, (String)entityKey);
        if (null != title) {
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)parentEntityKey);
            fileName = type.getDisplayName().toString() + title + fileName;
        }
        return fileName;
    }

    protected void setColumn(ExcelDataEntity excelData) {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        String entityKey = this.getView().getEntityId();
        DynamicObject parentObj = parentView.getModel().getDataEntity(true);
        ArrayList isExportProList = PdsCompConfigUtil.getPros((DynamicObject)parentObj, (String)entityKey, (String)this.getEntryKey(), (String)"isexport", (boolean)true);
        if (isExportProList.size() == 0) {
            super.setColumn(excelData);
        } else {
            excelData.setColumnKeyList((List)isExportProList);
        }
        this.removeUnValidColumnKey(excelData);
        isExportProList = new ArrayList(excelData.getColumnKeyList());
        Object entryStatus = this.getModel().getValue("entrystatus");
        if (!"B".equals(String.valueOf(entryStatus))) {
            isExportProList.remove("price");
            isExportProList.remove("taxprice");
            isExportProList.remove("amount");
            isExportProList.remove("taxamount");
        }
        excelData.setColumnKeyList(isExportProList);
    }

    public Object getRowVal(DynamicObject col, String column, int i) {
        DynamicObject valObj;
        Object val = null;
        val = "costitem".equals(column) || "unit".equals(column) ? (null == (valObj = col.getDynamicObject(column)) ? "" : valObj.getString("number")) : super.getRowVal(col, column, i);
        return val;
    }

    public Map<String, String> getMustInputProMap() {
        if (null == this.mustInputProMap) {
            this.mustInputProMap = new HashMap<String, String>(1);
            IDataModel model = this.getModel();
            Object compConfigId = model.getValue("compconfigid");
            if (null != compConfigId && String.valueOf(compConfigId).trim().length() > 0) {
                this.mustInputProMap = PdsCompConfigUtil.getMustInputValByCompConfig((Object)compConfigId);
                StringBuilder proKey = new StringBuilder();
                proKey.append(this.getEntryKey());
                proKey.append('.');
                proKey.append(this.getUnEditablePriceProByTaxType());
                this.mustInputProMap.remove(proKey.toString());
            } else {
                ArrayList<String> mustProArr = new ArrayList<String>();
                mustProArr.add("description");
                mustProArr.add("unit");
                Object entryStatus = this.getModel().getValue("entrystatus");
                StringBuilder proKey = new StringBuilder();
                if ("B".equals(String.valueOf(entryStatus))) {
                    proKey.append(this.getEntryKey());
                    proKey.append('.');
                    proKey.append(this.getUnEditablePriceProByTaxType());
                    mustProArr.add("qty");
                    mustProArr.add("price");
                    mustProArr.add("taxprice");
                }
                for (String mustPro : mustProArr) {
                    String desName = PdsMetadataUtil.getFieldDisplayName((Control)this.getView().getControl(mustPro));
                    this.mustInputProMap.put(this.getEntryKey() + "." + mustPro, desName);
                }
                this.mustInputProMap.remove(proKey.toString());
            }
        }
        return this.mustInputProMap;
    }

    private String getUnEditablePriceProByTaxType() {
        String taxType = this.getModel().getDataEntity().getString("taxtype");
        StringBuilder proKey = new StringBuilder();
        if ("2".equals(taxType)) {
            proKey.append("taxprice");
        } else {
            proKey.append("price");
        }
        return proKey.toString();
    }

    public DynamicObject getCurrency(int index) {
        return this.getModel().getDataEntity().getDynamicObject("currencyid");
    }

    public Integer getUpdateRowIndex(Map<String, Integer> columnIndexMap, String uniqueColumnVal, int index) {
        return null;
    }

    protected void addUniqueColumn(List<String> uniqueColumnList) {
        super.addUniqueColumn(uniqueColumnList);
        uniqueColumnList.add("description");
    }

    public void beforeBatchCreateNewEntry(TableValueSetter ts, int successCount) {
        super.beforeBatchCreateNewEntry(ts, successCount);
        IFormView parentView = this.getView().getParentView();
        if (null != parentView && successCount > 0) {
            this.getModel().deleteEntryData(this.getEntryKey());
        }
    }

    protected void afterImportOneRow(Map<String, Object> importDataMap, TableValueSetter ts, int rowIndex, boolean isUpdate) {
        super.afterImportOneRow(importDataMap, ts, rowIndex, isUpdate);
        if (!isUpdate) {
            long projectId = this.getModel().getDataEntity().getLong("projectid.id");
            long purlistId = this.getModel().getDataEntity().getLong("purlistid.id");
            ts.set("project", (Object)projectId, rowIndex);
            ts.set("purlist", (Object)purlistId, rowIndex);
            Object unitPk = ts.get("unit", rowIndex);
            Object qty = ts.get("qty", rowIndex);
            if (Objects.nonNull(unitPk) && Objects.nonNull(qty)) {
                ts.set("qty", (Object)this.setQtyScaleByUnit(unitPk, (BigDecimal)qty), rowIndex);
            }
        }
    }

    private BigDecimal setQtyScaleByUnit(Object unitPk, BigDecimal qty) {
        DynamicObject unitObj = BusinessDataServiceHelper.loadSingle((Object)unitPk, (String)"bd_measureunits");
        if (Objects.isNull(unitObj)) {
            return qty;
        }
        return PdsCalculateUtils.setScaleByUnit((DynamicObject)unitObj, (BigDecimal)qty);
    }

    protected void afterImport() {
        super.afterImport();
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.getEntryKey());
        if (null != entryGrid) {
            ExtPluginContext context = new ExtPluginContext();
            context.setView(this.getView());
            context.setEntityId(this.getEntryKey());
            context.setEntryEntityId("entryentity");
            int rowCount = this.getModel().getEntryRowCount(this.getEntryKey());
            for (int i = 0; i < rowCount; ++i) {
                entryGrid.selectRows(i, true);
                ExtPluginFactory.executeExtplugin((String)PdsCostDetailCalcEntryAmount.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
            }
        }
    }
}

