/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.pds.common.costdetail.PdsCostDetailCalcEntryAmount;
import kd.scm.pds.common.edit.AbstractBillImportEdit;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCalculateUtils;
import kd.scm.pds.common.util.PdsCompConfigUtil;
import kd.scm.pds.common.util.PdsCompRegUtil;
import kd.scm.pds.common.util.PdsCostDetailUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;

public class PdsCostDetail3CompImportEdit
extends AbstractBillImportEdit {
    private Map<String, String> tarEntryIdLevelMap = new HashMap<String, String>(8);
    Map<Long, String> entryIdLevelMap = new HashMap<Long, String>(8);
    private Map<String, String> mustInputProMap = null;
    public Map<String, String> levelMap = new HashMap<String, String>(8);
    public Map<String, Long> levelEntryID = new HashMap<String, Long>(8);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initBtn();
    }

    public void initBtn() {
        Set entityKeySet;
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        Map customParams = parentView.getFormShowParameter().getCustomParams();
        Object pEntityKey = customParams.get("pentitykey");
        String entityKey = "";
        if (null != pEntityKey) {
            entityKey = String.valueOf(pEntityKey);
        }
        if ((entityKeySet = PdsCostDetailUtils.allowSetCostDetailEntitys()).contains(entityKey)) {
            view.setVisible(Boolean.TRUE, new String[]{"importdata"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"importdata"});
        }
    }

    public String getExportDataTitile() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        String parentEntityKey = parentView.getEntityId();
        String entityKey = this.getModel().getDataEntityType().getName();
        String fileName = DateUtil.date2str((Date)new Date(), (String)"yyyyMMddHHmmss");
        String title = PdsCompRegUtil.getCompTitleByBidComp((String)parentEntityKey, (String)entityKey);
        if (null != title) {
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)parentEntityKey);
            String parentName = type.getDisplayName().toString();
            String regEx = "[ \\\\`~!@#$%^*+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]|\n|\r|\t";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(parentName);
            while (m.find()) {
                String group = m.group(0);
                parentName = parentName.replace(group, "_");
            }
            fileName = parentName + title + fileName;
        }
        return fileName;
    }

    public String getExportTplTitle() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        String parentEntityKey = this.getView().getParentView().getEntityId();
        String entityKey = this.getModel().getDataEntityType().getName();
        String fileName = ResManager.loadKDString((String)"\u6a21\u677f", (String)"PdsCostDetail3CompImportEdit_0", (String)"scm-pds-formplugin", (Object[])new Object[0]);
        String title = PdsCompRegUtil.getCompTitleByBidComp((String)parentEntityKey, (String)entityKey);
        if (null != title) {
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)parentEntityKey);
            fileName = type.getDisplayName().toString() + title + fileName;
        }
        return fileName;
    }

    protected void setColumn(ExcelDataEntity excelData) {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        String entityKey = this.getView().getEntityId();
        DynamicObject parentObj = parentView.getModel().getDataEntity(true);
        ArrayList<String> isExportProList = PdsCompConfigUtil.getPros((DynamicObject)parentObj, (String)entityKey, (String)this.getEntryKey(), (String)"isexport", (boolean)true);
        if (isExportProList.size() == 0) {
            super.setColumn(excelData);
        } else {
            excelData.setColumnKeyList((List)isExportProList);
        }
        this.removeUnValidColumnKey(excelData);
        isExportProList = new ArrayList<String>(excelData.getColumnKeyList());
        isExportProList.add(0, this.getLevelKey());
        Object entryStatus = this.getModel().getValue("entrystatus");
        if (!"B".equals(String.valueOf(entryStatus))) {
            isExportProList.remove("price");
            isExportProList.remove("taxprice");
            isExportProList.remove("amount");
            isExportProList.remove("taxamount");
        }
        excelData.setColumnKeyList(isExportProList);
    }

    public Map<String, String> getCustomColumnMap() {
        Map columnMap = super.getCustomColumnMap();
        columnMap.put(this.getLevelKey(), ResManager.loadKDString((String)"\u5c42\u7ea7", (String)"PdsCostDetail3CompImportEdit_1", (String)"scm-pds-formplugin", (Object[])new Object[0]));
        return columnMap;
    }

    protected void addComment(Map<String, String> commentMap) {
        super.addComment(commentMap);
        commentMap.put(this.getLevelKey(), ResManager.loadKDString((String)"1)\u591a\u7ea7\u5e8f\u53f7\u9700\u4e25\u683c\u6309\u7167\u4e00\u7ea7\u53c2\u7167:1,2,3...;\u4e8c\u7ea71.1,1.2,2.1,3.1...;\u4e09\u7ea71.1.1,2.1.1...\u5426\u5219\u7cfb\u7edf\u65e0\u6cd5\u8bc6\u522b\uff1b\r\n2)\u5982\u679c\u5bfc\u5165\u7684\u5c42\u7ea7\u4e0d\u5bf9\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u7684\u5c42\u7ea7\u662f\u5426\u662f\u4e25\u683c\u6309\u7167\u4ece\u4e0a\u5f80\u4e0b\u8f93\u5165\u7684\uff1b", (String)"PdsCostDetail3CompImportEdit_5", (String)"scm-pds-formplugin", (Object[])new Object[0]));
        commentMap.put("price", ResManager.loadKDString((String)"\u6d89\u53ca\u591a\u7ea7\u6210\u672c\u660e\u7ec6\u5bfc\u5165\u65f6\uff0c\u7528\u6237\u53ea\u9700\u8981\u7ef4\u62a4\u672b\u7ea7\u7684\u672a\u7a0e/\u542b\u7a0e\u6210\u672c\uff0c\u4f9d\u636e\u7cfb\u7edf\u516c\u5f0f\u8fdb\u884c\u9010\u7ea7\u8ba1\u7b97\u4e0a\u7ea7\u6210\u672c\u3002", (String)"PdsCostDetail3CompImportEdit_6", (String)"scm-pds-formplugin", (Object[])new Object[0]));
        commentMap.put("taxprice", ResManager.loadKDString((String)"\u6d89\u53ca\u591a\u7ea7\u6210\u672c\u660e\u7ec6\u5bfc\u5165\u65f6\uff0c\u7528\u6237\u53ea\u9700\u8981\u7ef4\u62a4\u672b\u7ea7\u7684\u672a\u7a0e/\u542b\u7a0e\u6210\u672c\uff0c\u4f9d\u636e\u7cfb\u7edf\u516c\u5f0f\u8fdb\u884c\u9010\u7ea7\u8ba1\u7b97\u4e0a\u7ea7\u6210\u672c\u3002", (String)"PdsCostDetail3CompImportEdit_6", (String)"scm-pds-formplugin", (Object[])new Object[0]));
    }

    public Object getRowVal(DynamicObject col, String column, int index) {
        Object val = "";
        if (this.getLevelKey().equals(column)) {
            Map<Long, String> entryIdSeqMap = this.getEntryIDLevelMap();
            Long entryId = col.getLong("id");
            String currLevel = entryIdSeqMap.get(entryId);
            StringBuilder levelSb = new StringBuilder();
            Long pid = col.getLong("pid");
            if (pid > 0L) {
                String level = this.tarEntryIdLevelMap.get(String.valueOf(pid));
                if (null != level) {
                    val = levelSb.append(level).append(".").append(currLevel);
                }
            } else {
                val = levelSb.append(currLevel);
            }
            this.tarEntryIdLevelMap.put(String.valueOf(entryId), String.valueOf(val));
        } else {
            DynamicObject valObj;
            val = "costitem".equals(column) || "unit".equals(column) ? (null == (valObj = col.getDynamicObject(column)) ? "" : valObj.getString("number")) : super.getRowVal(col, column, index);
        }
        return val;
    }

    private Map<Long, String> getEntryIDLevelMap() {
        if (this.entryIdLevelMap.size() > 0) {
            return this.entryIdLevelMap;
        }
        DynamicObjectCollection cols = this.getModel().getEntryEntity(this.getEntryKey());
        int pSeq = 1;
        for (int i = 0; i < cols.size(); ++i) {
            DynamicObject col = (DynamicObject)cols.get(i);
            Long pid = col.getLong("pid");
            if (pid != 0L) continue;
            this.entryIdLevelMap.put(col.getLong("id"), String.valueOf(pSeq++));
        }
        HashMap<Long, Integer> parentIdMaxSeqMap = new HashMap<Long, Integer>(8);
        for (int i = 0; i < cols.size(); ++i) {
            DynamicObject col = (DynamicObject)cols.get(i);
            Long pid = col.getLong("pid");
            if (pid <= 0L) continue;
            Integer maxSeq = null == parentIdMaxSeqMap.get(pid) ? Integer.valueOf(1) : (Integer)parentIdMaxSeqMap.get(pid);
            parentIdMaxSeqMap.put(pid, maxSeq + 1);
            this.entryIdLevelMap.put(col.getLong("id"), String.valueOf(maxSeq));
        }
        return this.entryIdLevelMap;
    }

    public Map<String, String> getMustInputProMap() {
        if (null == this.mustInputProMap) {
            this.mustInputProMap = new HashMap<String, String>(1);
            IDataModel model = this.getModel();
            Object compConfigId = model.getValue("compconfigid");
            if (null != compConfigId && String.valueOf(compConfigId).trim().length() > 0) {
                this.mustInputProMap = PdsCompConfigUtil.getMustInputValByCompConfig((Object)compConfigId);
                StringBuilder proKey = new StringBuilder();
                proKey.append(this.getEntryKey());
                proKey.append('.');
                proKey.append(this.getUnEditablePriceProByTaxType());
                this.mustInputProMap.remove(proKey.toString());
            } else {
                this.mustInputProMap.put(this.getEntryKey() + "." + this.getLevelKey(), ResManager.loadKDString((String)"\u5c42\u7ea7", (String)"PdsCostDetail3CompImportEdit_1", (String)"scm-pds-formplugin", (Object[])new Object[0]));
                ArrayList<String> mustProArr = new ArrayList<String>();
                mustProArr.add("description");
                mustProArr.add("unit");
                Object entryStatus = this.getModel().getValue("entrystatus");
                StringBuilder proKey = new StringBuilder();
                if ("B".equals(String.valueOf(entryStatus))) {
                    proKey.append(this.getEntryKey());
                    proKey.append('.');
                    proKey.append(this.getUnEditablePriceProByTaxType());
                    mustProArr.add("qty");
                    mustProArr.add("price");
                    mustProArr.add("taxprice");
                }
                for (String mustPro : mustProArr) {
                    String desName = PdsMetadataUtil.getFieldDisplayName((Control)this.getView().getControl(mustPro));
                    this.mustInputProMap.put(this.getEntryKey() + "." + mustPro, desName);
                }
                this.mustInputProMap.remove(proKey.toString());
            }
        }
        return this.mustInputProMap;
    }

    private String getUnEditablePriceProByTaxType() {
        String taxType = this.getModel().getDataEntity().getString("taxtype");
        StringBuilder proKey = new StringBuilder();
        if ("2".equals(taxType)) {
            proKey.append("taxprice");
        } else {
            proKey.append("price");
        }
        return proKey.toString();
    }

    protected Object getVal(String column, int index, Object val, StringBuilder msg) {
        if (this.getLevelKey().equals(column)) {
            String parentLev;
            String reg = "^[0-9-.-0-9]+$";
            String level = String.valueOf(val);
            Pattern pattern = Pattern.compile(reg);
            Matcher match = pattern.matcher(level);
            if (!match.matches()) {
                msg.append(ResManager.loadKDString((String)"\u5c42\u7ea7\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6309\u71671.1.1\u7684\u683c\u5f0f\u5f55\u5165\u7684\uff0c\u53ef\u53c2\u8003\u8868\u5934\u5b57\u6bb5\u7684\u6ce8\u91ca\u3002", (String)"PdsCostDetail3CompImportEdit_4", (String)"scm-pds-formplugin", (Object[])new Object[0])).append("\n");
            }
            if ((parentLev = this.getParentLevl(level)).trim().length() > 0 && null == this.levelMap.get(parentLev)) {
                msg.append(ResManager.loadKDString((String)"\u5f53\u524d\u5c42\u7ea7\u6ca1\u6709\u4e0a\u7ea7\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u6570\u636e\u662f\u5426\u5408\u6cd5\u3002", (String)"PdsCostDetail3CompImportEdit_7", (String)"scm-pds-formplugin", (Object[])new Object[0]));
            }
            this.levelMap.put(level, level);
        }
        return super.getVal(column, index, val, msg);
    }

    public DynamicObject getCurrency(int index) {
        return this.getModel().getDataEntity().getDynamicObject("currencyid");
    }

    public Integer getUpdateRowIndex(Map<String, Integer> columnIndexMap, String uniqueColumnVal, int index) {
        return null;
    }

    protected void addUniqueColumn(List<String> uniqueColumnList) {
        super.addUniqueColumn(uniqueColumnList);
        uniqueColumnList.add(this.getLevelKey());
    }

    public void beforeBatchCreateNewEntry(TableValueSetter ts, int successCount) {
        super.beforeBatchCreateNewEntry(ts, successCount);
        IFormView parentView = this.getView().getParentView();
        if (null != parentView && successCount > 0) {
            this.getModel().deleteEntryData(this.getEntryKey());
        }
    }

    protected void afterImportOneRow(Map<String, Object> importDataMap, TableValueSetter ts, int rowIndex, boolean isUpdate) {
        super.afterImportOneRow(importDataMap, ts, rowIndex, isUpdate);
        if (!isUpdate) {
            String level = String.valueOf(importDataMap.get(this.getLevelKey()));
            DynamicObjectCollection cols = this.getModel().getEntryEntity(this.getEntryKey());
            Long entryId = ORM.create().genLongId((IDataEntityType)cols.getDynamicObjectType());
            ts.set("id", (Object)entryId, rowIndex);
            this.levelEntryID.put(String.valueOf(level), entryId);
            String parentLevl = this.getParentLevl(level);
            Long pId = this.levelEntryID.get(parentLevl);
            if (null != pId) {
                ts.set("pid", (Object)pId, rowIndex);
            }
            this.levelEntryID.put(level, entryId);
            long projectId = this.getModel().getDataEntity().getLong("projectid.id");
            long purlistId = this.getModel().getDataEntity().getLong("purlistid.id");
            ts.set("project", (Object)projectId, rowIndex);
            ts.set("purlist", (Object)purlistId, rowIndex);
            Object unitPk = ts.get("unit", rowIndex);
            Object qty = ts.get("qty", rowIndex);
            if (Objects.nonNull(unitPk) && Objects.nonNull(qty)) {
                ts.set("qty", (Object)this.setQtyScaleByUnit(unitPk, (BigDecimal)qty), rowIndex);
            }
        }
    }

    private BigDecimal setQtyScaleByUnit(Object unitPk, BigDecimal qty) {
        DynamicObject unitObj = BusinessDataServiceHelper.loadSingle((Object)unitPk, (String)"bd_measureunits");
        if (Objects.isNull(unitObj)) {
            return qty;
        }
        return PdsCalculateUtils.setScaleByUnit((DynamicObject)unitObj, (BigDecimal)qty);
    }

    private String getParentLevl(String level) {
        String parentLevl = "";
        String[] levArra = level.split("\\.");
        if (levArra.length > 1) {
            parentLevl = level.substring(0, level.lastIndexOf("."));
        }
        return parentLevl;
    }

    protected void afterImport() {
        super.afterImport();
        TreeEntryGrid treeGrid = (TreeEntryGrid)this.getControl(this.getEntryKey());
        if (null != treeGrid) {
            ExtPluginContext context = new ExtPluginContext();
            context.setView(this.getView());
            context.setEntityId(this.getEntryKey());
            context.setEntryEntityId("TreeEntryType");
            int rowCount = this.getModel().getEntryRowCount(this.getEntryKey());
            int[] rows = new int[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                rows[i] = i;
                treeGrid.selectRows(i, true);
                ExtPluginFactory.executeExtplugin((String)PdsCostDetailCalcEntryAmount.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
            }
            treeGrid.expand(rows);
        }
    }

    private String getLevelKey() {
        return "seq";
    }
}

