/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.costdetail.PdsCostDetailCalcEntryAmount;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class PdsCostDetailCompEdit
extends AbstractFormPlugin {
    private boolean isChanging = false;

    public void beforeBindData(EventObject eventobject) {
        super.beforeBindData(eventobject);
        this.setDefaultValue();
        this.priceMustInput();
        this.setToolBarVisible();
        this.setIsChangedEnable();
    }

    private void setToolBarVisible() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        if (!PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        String billStatus = PdsCommonUtils.object2String((Object)parentView.getModel().getDataEntity().getString("billstatus"), (String)BillStatusEnum.SAVE.getVal());
        boolean isView = PdsCommonUtils.object2Boolean((Object)PdsCommonUtils.getCustomParamValue((IFormView)parentView, (String)"view"));
        if (isView || !BillStatusEnum.SAVE.getVal().equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advcontoolbarap", "advcontoolbarap1"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"entryentity", "subentryentity"});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key;
        super.propertyChanged(args);
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        switch (key = args.getProperty().getName()) {
            case "costitem": 
            case "description": 
            case "unit": 
            case "note": 
            case "subdescription": 
            case "subunit": 
            case "subnote": 
            case "qty": 
            case "ratio": 
            case "price": 
            case "taxprice": 
            case "subqty": 
            case "subratio": 
            case "subprice": 
            case "subtaxprice": {
                parentView.getModel().setValue("ischanged", (Object)true);
                parentView.updateView("ischanged");
                this.getView().sendFormAction(parentView);
                break;
            }
        }
    }

    private void setDefaultValue() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        if (!PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        this.getModel().setValue("projectid", (Object)parentView.getModel().getDataEntity().getLong("project.id"));
        this.getModel().setValue("purlistid", (Object)parentView.getModel().getDataEntity().getLong("purlist.id"));
        this.getModel().setValue("currencyid", (Object)parentView.getModel().getDataEntity().getLong("currency.id"));
        this.getModel().setValue("taxtype", parentView.getModel().getValue("taxtype"));
        if ("tnd_costdetail".equals(parentView.getEntityId())) {
            this.getModel().setValue("entrystatus", (Object)"B");
        } else {
            String entryStatus = PdsCommonUtils.object2String((Object)parentView.getModel().getDataEntity().get("purlist.entrystatus"), (String)"A");
            this.getModel().setValue("entrystatus", (Object)entryStatus);
        }
    }

    private void priceMustInput() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        if (!PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        boolean mustInput = false;
        PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"price", (boolean)mustInput);
        PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"subprice", (boolean)mustInput);
        PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"taxprice", (boolean)mustInput);
        PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"subtaxprice", (boolean)mustInput);
        if ("tnd_costdetail".equals(parentView.getEntityId())) {
            mustInput = true;
        }
        if ("2".equals(parentView.getModel().getDataEntity().getString("taxtype"))) {
            PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"price", (boolean)mustInput);
            PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"subprice", (boolean)mustInput);
        } else {
            PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"taxprice", (boolean)mustInput);
            PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"subtaxprice", (boolean)mustInput);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String opKey = ((AbstractOperate)evt.getSource()).getOperateKey();
        if (opKey.equals("save") || opKey.equals("submit")) {
            this.setEntryDefaultValue();
        }
    }

    private void setEntryDefaultValue() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        if (!PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        long projectId = this.getModel().getDataEntity().getLong("projectid.id");
        long purlistId = this.getModel().getDataEntity().getLong("purlistid.id");
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject row : rows) {
            row.set("project", (Object)projectId);
            row.set("purlist", (Object)purlistId);
        }
    }

    protected void calcEntryAmount(String entityName, String entityType) {
        if (this.isChanging) {
            return;
        }
        this.isChanging = true;
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        context.setEntityId(entityName);
        context.setEntryEntityId(entityType);
        ExtPluginFactory.executeExtplugin((String)PdsCostDetailCalcEntryAmount.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
        this.isChanging = false;
    }

    public void setIsChangedEnable() {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.equals((CharSequence)appId, (CharSequence)"tnd")) {
            this.getView().setEnable(Boolean.valueOf(false), -1, new String[]{"ischanged", "subischanged"});
            this.getModel().setValue("issupplier", (Object)true);
        } else {
            this.getModel().setValue("issupplier", (Object)false);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.equals((CharSequence)appId, (CharSequence)"src")) {
            return;
        }
        String fieldName = null;
        switch (e.getEntryProp().getName()) {
            case "entryentity": {
                fieldName = "ischanged";
                break;
            }
            case "subentryentity": {
                fieldName = "subischanged";
                break;
            }
            default: {
                return;
            }
        }
        int[] rowIndexs = e.getRowIndexs();
        StringBuilder sb = new StringBuilder();
        for (int index : rowIndexs) {
            boolean isChanged = (Boolean)this.getModel().getValue(fieldName, index);
            if (isChanged) continue;
            sb.append(ResManager.loadKDString((String)"\u7b2c ", (String)"PdsCostDetailCompEdit_0", (String)"scm-pds-formplugin", (Object[])new Object[0])).append(index + 1).append(ResManager.loadKDString((String)" \u884c", (String)"PdsCostDetailCompEdit_1", (String)"scm-pds-formplugin", (Object[])new Object[0])).append("\t");
        }
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u52ff\u5220\u9664\u91c7\u8d2d\u65b9\u9884\u7f6e\u4e14\u4e0d\u5141\u8bb8\u4fee\u6539\u7684\u5206\u5f55\u3002", (String)"PdsCostDetailCompEdit_2", (String)"scm-pds-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            e.setCancel(true);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String fieldName = null;
        if (Objects.equals(e.getEntryProp().getName(), "entryentity")) {
            fieldName = "ischanged";
        } else if (Objects.equals(e.getEntryProp().getName(), "subentryentity")) {
            fieldName = "subischanged";
        }
        if (null == fieldName) {
            return;
        }
        RowDataEntity[] rowEntitys = e.getRowDataEntities();
        if (rowEntitys.length == 0) {
            return;
        }
        for (RowDataEntity rowDataEntity : rowEntitys) {
            this.getModel().setValue(fieldName, (Object)true, rowDataEntity.getRowIndex());
        }
    }
}

