/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.scm.pds.common.costdetail.PdsCostDetailCalcTreeParentAmount;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.formplugin.edit.PdsCostDetailCompEdit;

public class PdsCostDetailCompEdit3
extends PdsCostDetailCompEdit {
    @Override
    public void beforeBindData(EventObject eventobject) {
        super.beforeBindData(eventobject);
        if (StringUtils.isBlank((Object)this.getModel().getValue("type"))) {
            this.getModel().setValue("type", (Object)"3");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("entryentity");
        grid.setCollapse(false);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs args) {
        String key;
        super.propertyChanged(args);
        switch (key = args.getProperty().getName()) {
            case "qty": 
            case "ratio": 
            case "price": 
            case "taxprice": {
                this.calcEntryAmount(args.getProperty().getParent().getName(), args.getProperty().getParent().getClass().getSimpleName());
                break;
            }
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs evt) {
        if (!StringUtils.equals((CharSequence)"entryentity", (CharSequence)evt.getEntryProp().getName())) {
            return;
        }
        RowDataEntity[] rowEntitys = evt.getRowDataEntities();
        if (rowEntitys.length == 0) {
            return;
        }
        for (RowDataEntity rowDataEntity : rowEntitys) {
            int insertRow = rowDataEntity.getRowIndex();
            if (insertRow == -1) {
                insertRow = this.getModel().getEntryCurrentRowIndex("entryentity");
            }
            if (insertRow < 0) continue;
            this.updateChildCount(rowDataEntity.getDataEntity().getLong("pid"), insertRow, 1);
        }
    }

    @Override
    public void beforeDeleteRow(BeforeDeleteRowEventArgs evt) {
        int[] rowIndexs;
        super.beforeDeleteRow(evt);
        if (!StringUtils.equals((CharSequence)"entryentity", (CharSequence)evt.getEntryProp().getName())) {
            return;
        }
        for (int index : rowIndexs = evt.getRowIndexs()) {
            DynamicObject row = this.getModel().getEntryRowEntity("entryentity", index);
            this.updateChildCount(row.getLong("pid"), index, -1);
        }
    }

    private void updateChildCount(long parentEntryId, int index, int count) {
        if (parentEntryId == 0L) {
            return;
        }
        for (int i = 0; i < index; ++i) {
            DynamicObject parentRow = this.getModel().getEntryRowEntity("entryentity", i);
            if (parentRow.getLong("id") != parentEntryId) continue;
            int childCount = parentRow.getInt("childcount") + count;
            this.getModel().setValue("childcount", (Object)(childCount < 0 ? 0 : childCount), i);
            break;
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String opKey = ((AbstractOperate)evt.getSource()).getOperateKey();
        if (opKey.equals("save") || opKey.equals("submit")) {
            this.calcTreeParentAmount();
        }
    }

    protected void calcTreeParentAmount() {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        context.setEntityId("entryentity");
        context.setEntryEntityId("TreeEntryType");
        ExtPluginFactory.executeExtplugin((String)PdsCostDetailCalcTreeParentAmount.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
    }
}

