/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.pds.common.util.ExportUtil;

public class PdsDataExAndImportEdit
extends AbstractFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOerationEvent) {
        String operateKey;
        super.beforeDoOperation(beforeDoOerationEvent);
        AbstractOperate operate = (AbstractOperate)beforeDoOerationEvent.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "exportzip": {
                this.export(beforeDoOerationEvent, true);
                break;
            }
            case "export": {
                this.export(beforeDoOerationEvent, false);
                break;
            }
            case "import": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("pds_dataimport");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("entitykey", (Object)operate.getEntityId());
                this.getView().showForm(showParameter);
            }
        }
    }

    private void export(BeforeDoOperationEventArgs beforeDoOerationEvent, boolean iszip) {
        ListSelectedRowCollection collections = this.getSelectRows();
        AbstractOperate operate = (AbstractOperate)beforeDoOerationEvent.getSource();
        if (collections.size() == 0) {
            beforeDoOerationEvent.setCancel(true);
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u5bfc\u51fa\u3002", (String)"PdsDataExAndImportEdit_0", (String)"scm-pds-formplugin", (Object[])new Object[0]));
            return;
        }
        if (collections.size() > 10) {
            beforeDoOerationEvent.setCancel(true);
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e00\u6b21\u6700\u591a\u53ea\u80fd\u5bfc\u51fa10\u6761\u6570\u636e\u3002", (String)"PdsDataExAndImportEdit_1", (String)"scm-pds-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityKey = operate.getEntityId();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityKey);
        Object[] primaryKey = collections.getPrimaryKeyValues();
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])primaryKey, (DynamicObjectType)type);
        ArrayList<String> urlList = new ArrayList<String>(8);
        for (DynamicObject obj : objs) {
            String url = ExportUtil.export((DynamicObject)obj, (boolean)true);
            if (iszip) {
                urlList.add(url);
                continue;
            }
            this.getView().openUrl(url);
        }
        if (urlList.size() > 0) {
            Date now = TimeServiceHelper.now();
            StringBuilder zipName = new StringBuilder(type.getDisplayName().toString()).append(DateUtil.date2str((Date)now, (String)"yyyyMMddHHmm")).append(".zip");
            String zipUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().compress(zipName.toString(), urlList.toArray(new String[0]), 300);
            this.getView().openUrl(zipUrl);
        }
    }

    private ListSelectedRowCollection getSelectRows() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        return billList.getSelectedRows();
    }
}

