/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pds.common.enroll.IPdsEnrollHandler;
import kd.scm.pds.common.enroll.PdsEnrollContext;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsDetailBidDocUploadHandler
implements IPdsEnrollHandler {
    private static final long serialVersionUID = 1L;

    public void process(PdsEnrollContext context) {
        if (context.isSucced()) {
            try {
                this.deleteEntryAttach(context);
                this.uploadEntryAttach(context);
            }
            catch (Exception e) {
                BizLog.log((String)("supplier enroll--" + e.getMessage() + "--" + this.getClass().getName()));
                throw new KDBizException(ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
    }

    public void deleteEntryAttach(PdsEnrollContext context) {
        QFilter qfilter = new QFilter("project", "=", (Object)this.getProjectId(context));
        qfilter.and("supplier", "=", (Object)this.getSupplierId(context));
        if ("tnd_bidenroll".equals(context.getBillObj().getDataEntityType().getName())) {
            qfilter.and("billtype", "=", (Object)"3");
        } else {
            qfilter.and("billtype", "=", (Object)"4");
        }
        DeleteServiceHelper.delete((String)"src_biddoctplf7", (QFilter[])qfilter.toArray());
    }

    public void uploadEntryAttach(PdsEnrollContext context) {
        DynamicObjectCollection rows = null;
        rows = "tnd_vie_attachment".equals(context.getBillObj().getDataEntityType().getName()) || "src_vie_attachment".equals(context.getBillObj().getDataEntityType().getName()) ? context.getBillObj().getDynamicObjectCollection("entryentity2") : context.getBillObj().getDynamicObjectCollection("entryentity");
        ArrayList<DynamicObject> bidDocList = new ArrayList<DynamicObject>(rows.size());
        HashSet<String> excludedFields = new HashSet<String>();
        excludedFields.add("seq");
        List properties = null;
        for (DynamicObject row : rows) {
            if (null == row.getDynamicObjectCollection("bidattach") || row.getDynamicObjectCollection("bidattach").size() == 0) continue;
            DynamicObject newRow = BusinessDataServiceHelper.newDynamicObject((String)"src_biddoctplf7");
            if (null == properties) {
                properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)newRow);
            }
            PdsCommonUtils.copyDynamicObjectValue((DynamicObject)row, (DynamicObject)newRow, (List)properties, excludedFields, (int)-1);
            PdsCommonUtils.setPrimaryKey((DynamicObject)newRow);
            if ("tnd_bidenroll".equals(context.getBillObj().getDataEntityType().getName())) {
                newRow.set("billtype", (Object)"3");
                newRow.set("entrystatus", (Object)"A");
            } else {
                newRow.set("billtype", (Object)"4");
                newRow.set("entrystatus", (Object)"C");
                newRow.set("purlist", row.get("purlistid"));
            }
            newRow.set("project", (Object)this.getProjectId(context));
            newRow.set("suppliertype", (Object)"bd_supplier");
            newRow.set("supplier", (Object)this.getSupplierId(context));
            newRow.set("parentid", (Object)this.getProjectId(context));
            newRow.set("billdate", (Object)TimeServiceHelper.now());
            newRow.set("supplierip", (Object)PdsCommonUtils.getLoginIp());
            newRow.set("turns", (Object)QuoteTurnsEnums.NEGOTIATE00.getValue());
            bidDocList.add(newRow);
        }
        PdsCommonUtils.saveDynamicObjects(bidDocList);
    }

    public long getProjectId(PdsEnrollContext context) {
        return context.getBillObj().getLong("project.id");
    }

    public long getSupplierId(PdsEnrollContext context) {
        if ("tnd_bidenroll".equals(context.getBillObj().getDataEntityType().getName())) {
            return context.getBillObj().getLong("supplier.id");
        }
        return context.getBillObj().getLong("supplierid.id");
    }
}

