/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;

public class PdsDocTplEdit
extends AbstractBillPlugIn {
    public static final String COMPBIZOBJECT = "compbizobject";
    public static final String BILLFIELDS = "billfields";
    public static final String COMPFIELDS = "compfields";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
        richTextEditor.setText(" ");
        this.getModel().setValue("content", (Object)"");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        PdsCommonUtils.setIsvId((IFormView)this.getView());
    }

    public void afterBindData(EventObject e) {
        Object compBizObject;
        Object bizNode;
        super.afterBindData(e);
        IDataModel dataModel = this.getModel();
        if (dataModel.getValue("content") != null) {
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
            richTextEditor.setText(dataModel.getValue("content").toString());
        }
        if (null != (bizNode = this.getModel().getValue("biznode"))) {
            DynamicObject bizObj = ((DynamicObject)bizNode).getDynamicObject("bizobject");
            this.setNodeFieldsVal(bizObj, "nodefields");
        }
        if (null != (compBizObject = this.getModel().getValue(COMPBIZOBJECT))) {
            this.setNodeFieldsVal((DynamicObject)compBizObject, COMPFIELDS);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        IDataModel Model = this.getModel();
        switch (operateKey = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
                String text = richTextEditor.getText();
                Model.setValue("content", (Object)text);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        IDataModel model = this.getModel();
        super.afterDoOperation(afterDoOperationEventArgs);
        String text = (String)model.getValue("content");
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
        if (null != text) {
            richTextEditor.setText(text);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newVal = changeData[0].getNewValue();
        Object oldVal = changeData[0].getOldValue();
        if ("biznode".equals(proName)) {
            if (null != newVal && newVal instanceof DynamicObject) {
                DynamicObject bizNode = (DynamicObject)newVal;
                this.setNodeFieldsVal(bizNode, "nodefields");
            } else {
                this.getModel().setValue("nodefields", null);
                ComboEdit fieldsCombo = (ComboEdit)this.getView().getControl("nodefields");
                if (null != fieldsCombo) {
                    fieldsCombo.setComboItems(null);
                }
            }
        } else if ("nodefields".equals(proName)) {
            this.setValToRichText(newVal, oldVal);
        } else if (COMPBIZOBJECT.equals(proName)) {
            if (null != newVal && newVal instanceof DynamicObject) {
                DynamicObject bizNode = (DynamicObject)newVal;
                this.setNodeFieldsVal(bizNode, COMPFIELDS);
            } else {
                this.getModel().setValue(COMPFIELDS, null);
                ComboEdit fieldsCombo = (ComboEdit)this.getView().getControl(COMPFIELDS);
                if (null != fieldsCombo) {
                    fieldsCombo.setComboItems(null);
                }
            }
        } else if (COMPFIELDS.equals(proName)) {
            this.setValToRichText(newVal, oldVal);
        }
    }

    private void setValToRichText(Object newVal, Object oldVal) {
        Set<String> newValSet = this.getNewVal(newVal, oldVal);
        StringBuilder textSb = new StringBuilder();
        if (null != newValSet) {
            for (String val : newValSet) {
                if (null == val || val.trim().length() == 0) continue;
                textSb.append(this.getPageCache().get(val)).append('\uff1a').append('{').append(val).append('}').append("<br/>");
            }
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
            textSb.append(richTextEditor.getText());
            richTextEditor.setText(textSb.toString());
        }
    }

    private void setNodeFieldsVal(DynamicObject entityObject, String fields) {
        if (Objects.isNull(entityObject)) {
            return;
        }
        String number = entityObject.getString("number");
        Map propetiesMap = PdsMetadataUtil.getProMap((String)number, (boolean)false);
        HashMap newPropetiesMap = Maps.newHashMapWithExpectedSize((int)propetiesMap.size());
        for (Map.Entry propetiesMapEntry : propetiesMap.entrySet()) {
            newPropetiesMap.put(number + "$" + (String)propetiesMapEntry.getKey(), propetiesMapEntry.getValue());
        }
        List combList = PdsMetadataUtil.buildPropComboItems((Map)newPropetiesMap);
        ComboEdit fieldsCombo = (ComboEdit)this.getView().getControl(fields);
        if (null != fieldsCombo) {
            fieldsCombo.setComboItems(combList);
        }
        this.getPageCache().put((Map)newPropetiesMap);
    }

    private Set<String> getNewVal(Object newVal, Object oldVal) {
        String[] newVals;
        if (null == newVal) {
            return null;
        }
        HashSet<String> newValSet = new HashSet<String>();
        for (String val : newVals = newVal.toString().split(",")) {
            if (null == val || val.trim().length() == 0) continue;
            newValSet.add(val);
        }
        if (null != oldVal) {
            String[] oldVals;
            for (String val : oldVals = oldVal.toString().split(",")) {
                newValSet.remove(val);
            }
        }
        return newValSet;
    }
}

