/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.mytask.SrcMyTaskFacade;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class PdsEntrustPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.showProjectInfo();
    }

    private void showProjectInfo() {
        Set handleIds = SrcMyTaskFacade.getHandleIdsFromView((IFormView)this.getView());
        if (handleIds != null) {
            Map resultMap = SrcMyTaskFacade.getProjectInfoByHandleIds((Set)handleIds);
            this.getModel().setValue("billno", resultMap.get("billno"));
            this.getModel().setValue("bidname", resultMap.get("bidname"));
            QFilter qfilter = new QFilter("id", "in", (Object)handleIds);
            qfilter.and("type", "=", (Object)"3");
            DynamicObject mytaskObj = BusinessDataServiceHelper.loadSingle((String)"src_memberclarify", (String)"project", (QFilter[])qfilter.toArray());
            if (null != mytaskObj) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"selectexpert"});
                this.getView().getModel().setValue("projectid", (Object)mytaskObj.getLong("project.id"));
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"selectexpert"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "selectexpert": {
                HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
                paramMap.put("project", this.getModel().getValue("projectid"));
                paramMap.put("expertcount", 1);
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"pds_selectexpert", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "pds_selectexpert"));
                break;
            }
            case "confirm": {
                StringBuilder sb = new StringBuilder();
                if (this.getModel().getValue("user") == null) {
                    sb = sb.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62df\u8f6c\u4ea4\u7684\u4eba\u5458\u3002", (String)"PdsEntrustPlugin_0", (String)"scm-pds-formplugin", (Object[])new Object[0])).append('\n');
                }
                if (this.getModel().getValue("description") == null || this.getModel().getValue("description").toString().trim().length() == 0) {
                    sb = sb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4efb\u52a1\u8f6c\u4ea4\u7684\u539f\u56e0\u3002", (String)"PdsEntrustPlugin_1", (String)"scm-pds-formplugin", (Object[])new Object[0]));
                }
                if (sb != null && sb.toString().trim().length() > 0) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(sb.toString());
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5c06\u4efb\u52a1\u8f6c\u4ea4\u7ed9\u5176\u4ed6\u4eba\u5904\u7406\uff1f", (String)"PdsEntrustPlugin_2", (String)"scm-pds-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener("entrust"));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (StringUtils.equals((CharSequence)"entrust", (CharSequence)e.getCallBackId()) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.entrustHandle();
            this.getView().invokeOperation("close");
        }
    }

    private void entrustHandle() {
        Set handleIds = SrcMyTaskFacade.getHandleIdsFromView((IFormView)this.getView());
        if (handleIds != null) {
            SrcMyTaskContext context = new SrcMyTaskContext();
            context.setHandleIds(handleIds);
            long userId = this.getModel().getDataEntity().getLong("user.id");
            String userName = this.getModel().getDataEntity().getString("user.name");
            String description = this.getModel().getDataEntity().getString("description");
            context.setUserId(userId);
            context.setUserName(userName);
            context.setDescription(description);
            SrcMyTaskFacade.entrustHandle((SrcMyTaskContext)context);
            this.sendMessage(context);
            this.getView().showMessage(context.getHandleMessage());
            PdsCommonUtils.refreshParentView((IFormView)this.getView());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if ("user".equals(key) && this.getModel().getDataEntity().getBoolean("isuserlimit")) {
            QFilter userFilter = new QFilter("id", "!=", (Object)RequestContext.get().getCurrUserId());
            Set handleIds = SrcMyTaskFacade.getHandleIdsFromView((IFormView)this.getView());
            QFilter qFilter = new QFilter("id", "in", (Object)handleIds);
            DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_memberclarify", (String)"srcentryid", (QFilter[])qFilter.toArray());
            Set srcEntryIds = rows.stream().map(row -> row.getLong("srcentryid")).collect(Collectors.toSet());
            QFilter scorerFilter = new QFilter("id", "in", srcEntryIds);
            DynamicObject[] scorers = BusinessDataServiceHelper.load((String)"src_bidopenconfig", (String)"scorer", (QFilter[])scorerFilter.toArray());
            HashSet scorerIds = new HashSet(16);
            for (DynamicObject scorer : scorers) {
                scorerIds.addAll(scorer.getDynamicObjectCollection("scorer").stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty(scorerIds)) {
                userFilter.and("id", "not in", scorerIds);
            }
            beforeF7SelectEvent.getCustomQFilters().add(userFilter);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit user = (BasedataEdit)this.getControl("user");
        if (Objects.nonNull(user)) {
            user.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void sendMessage(SrcMyTaskContext context) {
        List newMyTaskList = context.getNewMyTaskList();
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationServiceHelper.executeOperate((String)"sendmsg", (String)"src_memberclarify", (DynamicObject[])newMyTaskList.toArray(new DynamicObject[0]), (OperateOption)option);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (!(returnData instanceof Map)) {
            return;
        }
        Map paramMap = (Map)returnData;
        if (paramMap == null || paramMap.size() == 0) {
            return;
        }
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "pds_selectexpert": {
                List newExpertIds = (List)paramMap.get("expertuser");
                if (newExpertIds == null || newExpertIds.size() == 0) {
                    return;
                }
                this.getModel().setValue("user", newExpertIds.get(0));
                break;
            }
        }
    }
}

