/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;

public class PdsFieldConfigEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    protected static final String[] PROS = new String[]{"isvisible", "iseditable", "ismustinput", "isexport", "isimport", "iswriteback", "isclearup"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit compConfigBdPro = (BasedataEdit)this.getControl("compconfig");
        if (null != compConfigBdPro) {
            compConfigBdPro.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject component = this.getModel().getDataEntity().getDynamicObject("component");
        this.setFieldData(component);
        this.setUpdatedEntryId();
    }

    private void setUpdatedEntryId() {
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity(true);
        DynamicObjectCollection cols = data.getDynamicObjectCollection("entryentity");
        StringBuilder srcEntryIdBuilder = new StringBuilder();
        for (int rowIndex = 0; rowIndex < cols.size(); ++rowIndex) {
            DynamicObject col = (DynamicObject)cols.get(rowIndex);
            Long srcEntryId = col.getLong("srcentryid");
            if (srcEntryId == 0L) continue;
            if (srcEntryIdBuilder.length() > 0) {
                srcEntryIdBuilder.append(",").append(srcEntryId);
                continue;
            }
            srcEntryIdBuilder.append(srcEntryId);
        }
        model.setValue("updatedentryid", (Object)srcEntryIdBuilder.toString());
        model.setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newVal = changeData[0].getNewValue();
        switch (proName) {
            case "component": {
                DynamicObject component = null == newVal ? null : (DynamicObject)newVal;
                this.clearData();
                this.setFieldData(component);
                break;
            }
            case "compconfig": 
            case "field": {
                this.setValToEntry();
                break;
            }
        }
    }

    private void setValToEntry() {
        Set<String> fieldSet = this.getFieldVal();
        if (null != fieldSet) {
            this.createEntryData(fieldSet);
        }
    }

    private Set<String> getFieldVal() {
        String[] newVals;
        String fieldVal = this.getModel().getDataEntity().getString("field");
        if (null == fieldVal) {
            return null;
        }
        HashSet<String> newValSet = new HashSet<String>();
        for (String val : newVals = fieldVal.split(",")) {
            if (null == val || val.trim().length() == 0) continue;
            newValSet.add(val);
        }
        return newValSet;
    }

    private void createEntryData(Set<String> propeties) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        DynamicObjectCollection compConfigCols = model.getDataEntity().getDynamicObjectCollection("compconfig");
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        if (compConfigCols.size() > 0) {
            for (DynamicObject compConfig : compConfigCols) {
                DynamicObject compConfigObj = compConfig.getDynamicObject(1);
                DynamicObjectCollection compEntryCols = compConfigObj.getDynamicObjectCollection("entryentity");
                Map fieldIdObjMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)compEntryCols, (String)"fieldid");
                for (String property : propeties) {
                    DynamicObject compCol = (DynamicObject)fieldIdObjMap.get(property);
                    if (null != compCol) {
                        for (String pro : PROS) {
                            ts.set(pro, compCol.get(pro), i);
                        }
                        ts.set("srcentryid", compCol.getPkValue(), i);
                    }
                    ts.set("biznode", compConfigObj.getDynamicObject("biznode").getPkValue(), i);
                    ts.set("compcfg", compConfigObj.getPkValue(), i);
                    ts.set("fieldid", (Object)property, i);
                    ts.set("fieldname", (Object)this.getPageCache().get(property), i);
                    ++i;
                }
            }
        } else {
            for (String property : propeties) {
                ts.set("fieldid", (Object)property, i);
                ts.set("fieldname", (Object)this.getPageCache().get(property), i);
                ++i;
            }
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    private void setFieldData(DynamicObject component) {
        if (null == component) {
            return;
        }
        DynamicObject bizObj = component.getDynamicObject("bizobject");
        String entityKey = bizObj.getString("number");
        this.setNodeFieldsVal(entityKey, "field");
    }

    private void clearData() {
        IDataModel model = this.getModel();
        model.setValue("field", null);
        model.setValue("compconfig", null);
        model.deleteEntryData("entryentity");
    }

    private void setNodeFieldsVal(String entityKey, String fields) {
        if (Objects.isNull(entityKey)) {
            return;
        }
        Map propetiesMap = PdsMetadataUtil.getProMap((String)entityKey, (boolean)false);
        List combList = PdsMetadataUtil.buildPropComboItems((Map)propetiesMap);
        ComboEdit fieldsCombo = (ComboEdit)this.getView().getControl(fields);
        if (null != fieldsCombo) {
            fieldsCombo.setComboItems(combList);
        }
        this.getPageCache().put(propetiesMap);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String proName;
        switch (proName = beforeF7SelectEvent.getProperty().getName()) {
            case "compconfig": {
                DynamicObject data = this.getModel().getDataEntity();
                DynamicObject component = data.getDynamicObject("component");
                QFilter filter = null;
                if (null == component) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f85\u66f4\u65b0\u7ec4\u4ef6\u3002", (String)"PdsFieldConfigEdit_0", (String)"scm-pds-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject bizObj = component.getDynamicObject("bizobject");
                String entityKey = bizObj.getString("number");
                filter = new QFilter("component.bizobject", "=", (Object)entityKey);
                beforeF7SelectEvent.addCustomQFilter(filter);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "audit": {
                this.updateCompconfig();
            }
        }
    }

    private void updateCompconfig() {
        DynamicObject[] objs = this.getCompConfig();
        HashMap<Long, DynamicObject> idCompObjMap = new HashMap<Long, DynamicObject>(objs.length);
        HashMap<Long, DynamicObject> entryIdColMap = new HashMap<Long, DynamicObject>(objs.length * 50);
        for (DynamicObject obj : objs) {
            idCompObjMap.put(obj.getLong("id"), obj);
            DynamicObjectCollection cols = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject col : cols) {
                entryIdColMap.put(col.getLong("id"), col);
            }
        }
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity(true);
        DynamicObjectCollection cols = data.getDynamicObjectCollection("entryentity");
        boolean needSaveFieldObj = false;
        HashSet<DynamicObject> addNewEntryObjSet = new HashSet<DynamicObject>();
        for (int rowIndex = 0; rowIndex < cols.size(); ++rowIndex) {
            DynamicObject col;
            col = (DynamicObject)cols.get(rowIndex);
            DynamicObject compConfig = col.getDynamicObject("compcfg");
            if (null == compConfig) continue;
            Long srcEntryId = col.getLong("srcentryid");
            DynamicObject entryObj = null;
            if (srcEntryId == 0L) {
                DynamicObject compConfigObj = (DynamicObject)idCompObjMap.get(compConfig.getLong("id"));
                addNewEntryObjSet.add(compConfigObj);
                DynamicObjectCollection entryCols = compConfigObj.getDynamicObjectCollection("entryentity");
                entryObj = entryCols.addNew();
                PdsCommonUtils.setPrimaryKey((DynamicObject)entryObj);
                entryObj.set("fieldid", col.get("fieldid"));
                entryObj.set("fieldname", col.get("fieldname"));
                model.setValue("srcentryid", entryObj.getPkValue(), rowIndex);
                col.set("srcentryid", entryObj.getPkValue());
                needSaveFieldObj = true;
            } else {
                entryObj = (DynamicObject)entryIdColMap.get(col.getLong("srcentryid"));
            }
            if (null == entryObj) continue;
            for (String pro : PROS) {
                entryObj.set(pro, col.get(pro));
            }
        }
        for (DynamicObject addNewEntryObj : addNewEntryObjSet) {
            DynamicObjectUtil.setBillEntrySeq((DynamicObject)addNewEntryObj, (String)"entryentity");
        }
        if (objs.length > 0) {
            SaveServiceHelper.save((DynamicObject[])objs);
            if (needSaveFieldObj) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
            }
        }
    }

    private DynamicObject[] getCompConfig() {
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity();
        DynamicObjectCollection compConfigCols = data.getDynamicObjectCollection("compconfig");
        QFilter filter = null;
        if (compConfigCols.size() > 0) {
            HashSet<Object> compConfigIdSet = new HashSet<Object>();
            for (DynamicObject compConfig : compConfigCols) {
                DynamicObject compConfigObj = compConfig.getDynamicObject(1);
                compConfigIdSet.add(compConfigObj.getPkValue());
            }
            filter = new QFilter("id", "in", compConfigIdSet);
        } else {
            DynamicObject component = data.getDynamicObject("component");
            DynamicObject bizObj = component.getDynamicObject("bizobject");
            String entityKey = bizObj.getString("number");
            filter = new QFilter("component.bizobject", "=", (Object)entityKey);
        }
        String selectProperties = DynamicObjectUtil.getEntrySelectfields((String)"id", (String)"pds_compconfig", (String)"entryentity", (boolean)false);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"pds_compconfig", (String)selectProperties, (QFilter[])filter.toArray());
        return objs;
    }
}

