/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.extfilter.FilterGridUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;

public class PdsFileObjectEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        PdsCommonUtils.setIsvId((IFormView)this.getView());
        DynamicObject bizObject = this.getModel().getDataEntity().getDynamicObject("bizobject");
        if (Objects.nonNull(bizObject)) {
            this.setComoItems(bizObject.getString("number"));
        }
        this.setPKeyFieldComoItems(this.getModel().getDataEntity().getString("pentitykey.number"));
        this.setMustInput();
        FilterGridUtils.setEntityNumber((IFormView)this.getView());
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "save": {
                this.verifyEntryRepeated(evt);
                FilterGridUtils.saveCondition((IFormView)this.getView());
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGridUtils.setCondition((IFormView)this.getView());
    }

    private void verifyEntryRepeated(BeforeDoOperationEventArgs evt) {
        StringBuilder sb = new StringBuilder();
        Map resultMap = PdsCommonUtils.isRepeatForEntry((DynamicObjectCollection)this.getModel().getEntryEntity("billattachments"), (String)"billattach", null, null);
        if (!((Boolean)resultMap.get("succed")).booleanValue()) {
            sb.append(resultMap.get("message")).append(";\n");
        }
        if (!((Boolean)(resultMap = PdsCommonUtils.isRepeatForEntry((DynamicObjectCollection)this.getModel().getEntryEntity("entryattachments"), (String)"entryattach", null, null)).get("succed")).booleanValue()) {
            sb.append(resultMap.get("message")).append(";\n");
        }
        if (!((Boolean)(resultMap = PdsCommonUtils.isRepeatForEntry((DynamicObjectCollection)this.getModel().getEntryEntity("reportattachments"), (String)"reportattach", null, null)).get("succed")).booleanValue()) {
            sb.append(resultMap.get("message")).append(";\n");
        }
        if (sb.length() > 0) {
            this.getView().showMessage(sb.toString());
            evt.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldkey = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (fieldkey) {
            case "bizobject": {
                this.getModel().setValue("keyfield", null);
                this.getModel().setValue("pkeyfield", null);
                this.clearRowValue("billattachments", "billattach");
                this.clearRowValue("entryattachments", "entryattach");
                this.clearRowValue("reportattachments", "reportattach");
                this.setComoItems(Objects.isNull(newValue) ? null : ((DynamicObject)newValue).getString("number"));
                FilterGridUtils.setEntityNumber((IFormView)this.getView());
                break;
            }
            case "filtertype": {
                this.setMustInput();
                break;
            }
            case "pentitykey": {
                this.setPKeyFieldComoItems(Objects.isNull(newValue) ? null : ((DynamicObject)newValue).getString("number"));
                break;
            }
        }
    }

    private void clearRowValue(String entryName, String fieldName) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entryName);
        rows.forEach(row -> row.set(fieldName, null));
        this.getView().updateView(entryName);
    }

    private void setComoItems(String entityKey) {
        PdsCommonUtils.setCombListValue((IFormView)this.getView(), (String)entityKey, (String)"keyfield");
        ComboEdit billAttach = (ComboEdit)this.getControl("billattach");
        billAttach.setComboItems(PdsMetadataUtil.getComboItemFiled((String)entityKey, (String)"attachmentpanelap"));
        ComboEdit entryAttach = (ComboEdit)this.getControl("entryattach");
        entryAttach.setComboItems(PdsMetadataUtil.getComboItemFiled((String)entityKey, (String)"entryap"));
    }

    private void setPKeyFieldComoItems(String entityKey) {
        PdsCommonUtils.setCombListValue((IFormView)this.getView(), (String)entityKey, (String)"pkeyfield");
    }

    public void registerListener(EventObject e) {
        BasedataEdit extfilter;
        super.registerListener(e);
        BasedataEdit reportAttach = (BasedataEdit)this.getControl("reportattach");
        if (Objects.nonNull(reportAttach)) {
            reportAttach.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (Objects.nonNull(extfilter = (BasedataEdit)this.getControl("extfilter"))) {
            extfilter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        String bizObjectNumber = this.getModel().getDataEntity().getString("bizobject.number");
        QFilter qFilter = null;
        switch (key = beforeF7SelectEvent.getProperty().getName()) {
            case "extfilter": {
                qFilter = new QFilter("basedata.number", "=", (Object)bizObjectNumber);
                qFilter.and("group.number", "=", (Object)"SYS12");
                listShowParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "reportattach": {
                qFilter = new QFilter("formid.number", "=", (Object)bizObjectNumber);
                listShowParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
        }
    }

    private void setMustInput() {
        String filtertype;
        switch (filtertype = this.getModel().getDataEntity().getString("filtertype")) {
            case "1": {
                ((ComboEdit)this.getView().getControl("keyfield")).setMustInput(true);
                this.getModel().setValue("pentitykey", null);
                this.getModel().setValue("pkeyfield", null);
                this.getModel().setValue("extplugin", null);
                this.getModel().setValue("extfilter", null);
                break;
            }
            case "2": {
                ((BasedataEdit)this.getView().getControl("pentitykey")).setMustInput(true);
                ((ComboEdit)this.getView().getControl("pkeyfield")).setMustInput(true);
                this.getModel().setValue("keyfield", null);
                this.getModel().setValue("extplugin", null);
                this.getModel().setValue("extfilter", null);
                break;
            }
            case "3": {
                ((TextEdit)this.getView().getControl("extplugin")).setMustInput(true);
                this.getModel().setValue("keyfield", null);
                this.getModel().setValue("pentitykey", null);
                this.getModel().setValue("pkeyfield", null);
                this.getModel().setValue("extfilter", null);
                break;
            }
            case "4": {
                ((BasedataEdit)this.getView().getControl("extfilter")).setMustInput(true);
                this.getModel().setValue("keyfield", null);
                this.getModel().setValue("pentitykey", null);
                this.getModel().setValue("pkeyfield", null);
                this.getModel().setValue("extplugin", null);
                break;
            }
        }
    }
}

