/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsFlowConfigEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String[] bdPro = new String[]{"biznode", "subbiznode", "template", "subtemplate"};

    public void beforeBindData(EventObject e) {
        Object bizNode;
        super.beforeBindData(e);
        PdsCommonUtils.setIsvId((IFormView)this.getView());
        int rowCount = this.getModel().getEntryRowCount("entrynode");
        if (rowCount > 0 && null == (bizNode = this.getModel().getValue("biznode", 0))) {
            this.getModel().setValue("biznode", (Object)PdsBizNodeEnums.PROJECT.getId(), 0);
        }
    }

    public void afterCreateNewData(EventObject evt) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (String pro : bdPro) {
            BasedataEdit bdEdit = (BasedataEdit)this.getControl(pro);
            if (null == bdEdit) continue;
            bdEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        switch (opKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "save": {
                this.inviteNodeVerify(args);
                if (args.isCancel()) break;
                this.getModel().setValue("matchfield", (Object)ExtFilterUtils.getMatchFields((IFormView)this.getView(), (String)"src_project_srctype_filter"));
                break;
            }
        }
    }

    private void inviteNodeVerify(BeforeDoOperationEventArgs args) {
        if (!this.getModel().getDataEntity().getBoolean("isneedinvite")) {
            return;
        }
        String inviteNode = this.getModel().getDataEntity().getString("invitenode.number");
        if (null == inviteNode || inviteNode.trim().length() == 0) {
            return;
        }
        List<String> nodeList = this.selectedNode();
        if (!nodeList.contains(inviteNode)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u9080\u8bf7\u51fd\u7684\u4e1a\u52a1\u8282\u70b9\u5728\u6d41\u7a0b\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PdsFlowConfigEdit_0", (String)"scm-pds-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        QFilter qFilter = null;
        String name = evt.getProperty().getName();
        DynamicObject sourceType = this.getModel().getDataEntity().getDynamicObject("sourcetype");
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if ("biznode".equals(name) || "subbiznode".equals(name)) {
            List<String> selectedNode = this.selectedNode();
            if (selectedNode.size() > 0) {
                qFilter = new QFilter("number", "not in", selectedNode);
            }
            if (qFilter != null) {
                listShowParameter.getListFilterParameter().setFilter(qFilter);
            }
        } else if ("template".equals(name)) {
            Object bizNode = this.getModel().getValue("biznode", evt.getRow());
            if (Objects.isNull(bizNode)) {
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("biznode", ((DynamicObject)bizNode).getPkValue());
            paramMap.put("sourcetype", Objects.isNull(sourceType) ? Long.valueOf(0L) : sourceType.getPkValue());
            SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getModel().getDataEntity(), (String)"pds_tplconfig_filter", paramMap);
        } else if ("subtemplate".equals(name)) {
            Object bizNode = this.getModel().getValue("subbiznode", evt.getRow());
            if (Objects.isNull(bizNode)) {
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("biznode", ((DynamicObject)bizNode).getPkValue());
            paramMap.put("sourcetype", Objects.isNull(sourceType) ? Long.valueOf(0L) : sourceType.getPkValue());
            SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getModel().getDataEntity(), (String)"pds_tplconfig_filter", paramMap);
        }
    }

    public List<String> selectedNode() {
        ArrayList<String> codeList = new ArrayList<String>();
        DynamicObjectCollection entryNodes = this.getModel().getEntryEntity("entrynode");
        for (DynamicObject entryNode : entryNodes) {
            String bizNodeNumber = entryNode.getString("biznode.number");
            if (bizNodeNumber != null) {
                codeList.add(bizNodeNumber);
            }
            DynamicObjectCollection subentryNodes = entryNode.getDynamicObjectCollection("subentrynode");
            for (DynamicObject subentryNode : subentryNodes) {
                String subentryNodeNumber = subentryNode.getString("subbiznode.number");
                if (subentryNodeNumber == null) continue;
                codeList.add(subentryNodeNumber);
            }
        }
        return codeList;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "sourcetype": {
                DynamicObject sourcetypeObject = this.getModel().getDataEntity().getDynamicObject("sourcetype");
                if (sourcetypeObject == null) {
                    return;
                }
                DynamicObjectCollection newSourcetype = QueryServiceHelper.query((String)"pds_extdata", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", sourcetypeObject.getPkValue())});
                if (newSourcetype.size() <= 0) break;
                FieldEdit opentypeEdit = (FieldEdit)this.getControl("opentype");
                Set sourceTypeSet = PdsCommonUtils.buildSet((String[])new String[]{SourceTypeEnums.BID.getValue(), SourceTypeEnums.BID2.getValue(), SourceTypeEnums.BID3.getValue(), SourceTypeEnums.BID4.getValue()});
                if (sourceTypeSet.contains(((DynamicObject)newSourcetype.get(0)).get("number"))) {
                    opentypeEdit.setMustInput(true);
                    break;
                }
                opentypeEdit.setMustInput(false);
                break;
            }
            case "isneedinvite": {
                this.setInviteNodeMustInput();
                break;
            }
            case "isneedbiddoc": {
                this.setBidDocTypeMustInput();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setInviteNodeMustInput();
        this.setBidDocTypeMustInput();
    }

    private void setInviteNodeMustInput() {
        BasedataEdit invitenode = (BasedataEdit)this.getControl("invitenode");
        if (((Boolean)this.getModel().getValue("isneedinvite")).booleanValue()) {
            invitenode.setMustInput(true);
        } else {
            invitenode.setMustInput(false);
        }
    }

    private void setBidDocTypeMustInput() {
        ComboEdit biddoctype = (ComboEdit)this.getControl("biddoc");
        if (((Boolean)this.getModel().getValue("isneedbiddoc")).booleanValue()) {
            biddoctype.setMustInput(true);
        } else {
            biddoctype.setMustInput(false);
        }
    }
}

