/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.util.EventObject;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.constant.PdsMessageConstant;
import kd.scm.pds.common.message.PdsMessageContext;
import kd.scm.pds.common.message.PdsMessageFacade;
import kd.scm.pds.common.message.PdsMessageUtils;

public class PdsMessageSendAssist
extends AbstractFormPlugin
implements BeforeF7SelectListener,
TreeNodeClickListener {
    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        PdsMessageFacade.initBaseInfo((PdsMessageContext)this.createContext());
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        PdsMessageFacade.initPublisher((PdsMessageContext)this.createContext());
        PdsMessageFacade.initPortalMessage((PdsMessageContext)this.createContext());
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        for (int i = 1; i <= 25; ++i) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpageap" + i});
        }
        PdsMessageFacade.initSupplier((PdsMessageContext)this.createContext());
        PdsMessageFacade.initVisible((PdsMessageContext)this.createContext());
        PdsMessageFacade.initLettersTpl((PdsMessageContext)this.createContext());
        PdsMessageFacade.initPage((PdsMessageContext)this.createContext());
        this.setBillStatus();
        this.getModel().setDataChanged(false);
    }

    private void setBillStatus() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IDataEntityProperty property = model.getProperty("billstatus");
        if (property != null && view instanceof IBillView) {
            IBillView billView = (IBillView)view;
            if (view.getFormShowParameter().getStatus() == OperationStatus.VIEW) {
                billView.setBillStatus(BillOperationStatus.VIEW);
            } else {
                String value = (String)model.getValue("billstatus");
                if (BillStatusEnum.SAVE.getVal().equals(value)) {
                    boolean bFromDb = model.getDataEntity().getDataEntityState().getFromDatabase();
                    if (bFromDb) {
                        billView.setBillStatus(BillOperationStatus.EDIT);
                    } else {
                        billView.setBillStatus(BillOperationStatus.ADDNEW);
                    }
                } else if (BillStatusEnum.SUBMIT.getVal().equals(value)) {
                    billView.setBillStatus(BillOperationStatus.SUBMIT);
                } else if (BillStatusEnum.AUDIT.getVal().equals(value)) {
                    billView.setBillStatus(BillOperationStatus.AUDIT);
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        switch (opKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "refresh": {
                PdsMessageUtils.resetCachedPageIds((PdsMessageContext)this.createContext());
                break;
            }
            case "save": {
                PdsMessageUtils.setNoticeContentSaveStatus((PdsMessageContext)this.createContext());
                break;
            }
            case "send": 
            case "submit": {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
                PdsMessageUtils.setNoticeContentSaveStatus((PdsMessageContext)this.createContext());
                if (PdsMessageFacade.verifySendType((PdsMessageContext)this.createContext())) break;
                args.setCancel(true);
                return;
            }
            case "buildmsg": {
                PdsMessageFacade.showDocContent((PdsMessageContext)this.createContext());
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
                args.setCancel(true);
                this.getModel().setDataChanged(false);
                break;
            }
            case "batchfillattach": {
                AttachmentUtils.batchFillAttach((IFormView)this.getView(), (String)"supplierentry", (String)"attachment");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        switch (opKey) {
            case "send": 
            case "audit": 
            case "resend": 
            case "unaudit": 
            case "submit": 
            case "unsubmit": {
                if (null == result || !result.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        PdsMessageFacade.propertyChangeHandle((PdsMessageContext)this.createContext(), (PropertyChangedArgs)args);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs args) {
        super.afterDeleteRow(args);
        PdsMessageFacade.showDocContent((PdsMessageContext)this.createContext());
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7Evt) {
        PdsMessageFacade.setBeforeF7Filter((PdsMessageContext)this.createContext(), (BeforeF7SelectEvent)beforeF7Evt, (DynamicObject)this.getModel().getDataEntity(true));
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String treeNodeId = (String)evt.getNodeId();
        if (null == treeNodeId || PdsMessageConstant.TREE_KEYS().contains(treeNodeId)) {
            return;
        }
        PdsMessageContext context = this.createContext();
        PdsMessageUtils.setNoticeContentSaveStatus((PdsMessageContext)context);
        PdsMessageFacade.treeNodeClick((PdsMessageContext)context, (String)treeNodeId);
        super.treeNodeClick(evt);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.registerListenerTpl();
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl("supplier");
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TreeView tv = (TreeView)this.getView().getControl("treeviewap");
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    private void registerListenerTpl() {
        String[] bizTypes = PdsMessageUtils.getBizTypes((DynamicObject)this.getModel().getDataEntity(true));
        if (null != bizTypes && bizTypes.length > 0) {
            for (String bizType : bizTypes) {
                for (String tplType : PdsMessageConstant.TPL_TYPES()) {
                    BasedataEdit tplBd = (BasedataEdit)this.getView().getControl(bizType + tplType);
                    if (null == tplBd) continue;
                    tplBd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                }
            }
        }
    }

    private PdsMessageContext createContext() {
        PdsMessageContext context = new PdsMessageContext();
        context.setView(this.getView());
        context.setBillObj(this.getModel().getDataEntity(true));
        return context;
    }
}

