/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.scm.pds.common.util.ComboEditUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;

public class PdsNoticeTplEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String COMPBIZOBJECT = "compbizobject";
    public static final String BILLFIELDS = "billfields";
    public static final String COMPFIELDS = "compfields";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bdPro = (BasedataEdit)this.getControl("bizobject");
        bdPro.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit compBdPro = (BasedataEdit)this.getControl(COMPBIZOBJECT);
        compBdPro.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
        richTextEditor.setText(" ");
        this.getModel().setValue("content", (Object)"");
        this.getModel().setValue("tpltype", (Object)this.getTplType("tpltype"));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        PdsCommonUtils.setIsvId((IFormView)this.getView());
        this.setTplTypeVisibleAndComboList();
    }

    public void afterBindData(EventObject e) {
        Object compBizObject;
        Object bizObject;
        super.afterBindData(e);
        IDataModel dataModel = this.getModel();
        Object content = dataModel.getValue("content_tag");
        if (content != null) {
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
            richTextEditor.setText(content.toString());
        }
        if (null != (bizObject = this.getModel().getValue("bizobject"))) {
            this.setNodeFieldsVal((DynamicObject)bizObject, BILLFIELDS);
        }
        if (null != (compBizObject = this.getModel().getValue(COMPBIZOBJECT))) {
            this.setNodeFieldsVal((DynamicObject)compBizObject, COMPFIELDS);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        IDataModel model = this.getModel();
        switch (operateKey = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
                String text = richTextEditor.getText();
                model.setValue("content_tag", (Object)text);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey;
        IDataModel model = this.getModel();
        super.afterDoOperation(afterDoOperationEventArgs);
        String text = (String)model.getValue("content_tag");
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
        if (null != text) {
            richTextEditor.setText(text);
        }
        switch (opKey = afterDoOperationEventArgs.getOperateKey()) {
            case "audit": {
                this.getView().updateView("auditor");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newVal = changeData[0].getNewValue();
        Object oldVal = changeData[0].getOldValue();
        switch (proName) {
            case "bizobject": {
                if (null != newVal && newVal instanceof DynamicObject) {
                    DynamicObject bizNode = (DynamicObject)newVal;
                    this.setNodeFieldsVal(bizNode, BILLFIELDS);
                    break;
                }
                this.getModel().setValue(BILLFIELDS, null);
                ComboEdit fieldsCombo = (ComboEdit)this.getView().getControl(BILLFIELDS);
                if (null == fieldsCombo) break;
                fieldsCombo.setComboItems(null);
                break;
            }
            case "compbizobject": {
                if (null != newVal && newVal instanceof DynamicObject) {
                    DynamicObject bizNode = (DynamicObject)newVal;
                    this.setNodeFieldsVal(bizNode, COMPFIELDS);
                    break;
                }
                this.getModel().setValue(COMPFIELDS, null);
                ComboEdit fieldsCombo = (ComboEdit)this.getView().getControl(COMPFIELDS);
                if (null == fieldsCombo) break;
                fieldsCombo.setComboItems(null);
                break;
            }
            case "billfields": {
                this.setValToRichText(newVal, oldVal);
                break;
            }
            case "compfields": {
                this.setValToRichText(newVal, oldVal);
                break;
            }
        }
    }

    private void setNodeFieldsVal(DynamicObject entityObject, String fields) {
        if (Objects.isNull(entityObject)) {
            return;
        }
        String number = entityObject.getString("number");
        Map propetiesMap = PdsMetadataUtil.getProMap((String)number, (boolean)false);
        HashMap newPropetiesMap = Maps.newHashMapWithExpectedSize((int)propetiesMap.size());
        for (Map.Entry propetiesMapEntry : propetiesMap.entrySet()) {
            newPropetiesMap.put(number + "$" + (String)propetiesMapEntry.getKey(), propetiesMapEntry.getValue());
        }
        List combList = PdsMetadataUtil.buildPropComboItems((Map)newPropetiesMap);
        ComboEdit fieldsCombo = (ComboEdit)this.getView().getControl(fields);
        if (null != fieldsCombo) {
            fieldsCombo.setComboItems(combList);
        }
        this.getPageCache().put((Map)newPropetiesMap);
    }

    private void setValToRichText(Object newVal, Object oldVal) {
        Set<String> newValSet = this.getNewVal(newVal, oldVal);
        StringBuilder textSb = new StringBuilder();
        if (null != newValSet) {
            for (String val : newValSet) {
                if (null == val || val.trim().length() == 0) continue;
                textSb.append(this.getPageCache().get(val)).append('\uff1a').append('{').append(val).append('}').append("<br/>");
            }
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
            textSb.append(richTextEditor.getText());
            richTextEditor.setText(textSb.toString());
        }
    }

    public Set<String> getNewVal(Object newVal, Object oldVal) {
        String[] newVals;
        if (null == newVal) {
            return null;
        }
        HashSet<String> newValSet = new HashSet<String>();
        for (String val : newVals = newVal.toString().split(",")) {
            if (null == val || val.trim().length() == 0) continue;
            newValSet.add(val);
        }
        if (null != oldVal) {
            String[] oldVals;
            for (String val : oldVals = oldVal.toString().split(",")) {
                newValSet.remove(val);
            }
        }
        return newValSet;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7Select) {
        String proName;
        switch (proName = beforeF7Select.getProperty().getName()) {
            case "bizobject": 
            case "compbizobject": {
                IFormView parentView = this.getView().getParentView();
                if (null == parentView) break;
                String appNumber = PdsCommonUtils.getCustomParamsByMenu((IFormView)parentView, (String)"filterAppNumber");
                String appNumber2 = PdsCommonUtils.getCustomParamsByMenu((IFormView)parentView, (String)"filterAppNumber2");
                if (StringUtils.isNotEmpty((String)appNumber) && StringUtils.isNotEmpty((String)appNumber2)) {
                    QFilter appQfilter = new QFilter("bizappid.number", "=", (Object)appNumber).or("bizappid.number", "=", (Object)appNumber2);
                    beforeF7Select.addCustomQFilter(appQfilter);
                    break;
                }
                if (!StringUtils.isNotEmpty((String)appNumber)) break;
                QFilter appQfilter = new QFilter("bizappid.number", "=", (Object)appNumber);
                beforeF7Select.addCustomQFilter(appQfilter);
                break;
            }
        }
    }

    private String getTplType(String key) {
        IFormView parentView = this.getView().getParentView();
        Object paramVal = null;
        if (null != parentView) {
            Map params = parentView.getFormShowParameter().getCustomParams();
            paramVal = params.get(key);
        }
        return PdsCommonUtils.object2String(paramVal, (String)"1");
    }

    private void setTplTypeVisibleAndComboList() {
        String tplType2 = this.getTplType("tpltype2");
        if ("5".equals(tplType2)) {
            HashMap<String, String> comboMap = new HashMap<String, String>(2);
            comboMap.put("4", ResManager.loadKDString((String)"\u91c7\u8d2d\u65b9\u6807\u4e66\u6a21\u677f", (String)"PdsNoticeTplEdit_0", (String)"scm-pds-formplugin", (Object[])new Object[0]));
            comboMap.put("5", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u6807\u4e66\u6a21\u677f", (String)"PdsNoticeTplEdit_1", (String)"scm-pds-formplugin", (Object[])new Object[0]));
            ComboEdit tplType = (ComboEdit)this.getControl("tpltype");
            tplType.setComboItems(ComboEditUtils.getComboList(comboMap));
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tpltype"});
        }
    }
}

