/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.constant.SrcCommonConstant;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsParamPluginEdit
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(PdsParamPluginEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"confirm", "cancel", "paramvalue"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if ("cancel".equals(key)) {
            this.getView().close();
        }
        if ("confirm".equals(key)) {
            String paramTag = this.getPageCache().get("param_tag");
            HashMap<String, Object> returnData = new HashMap<String, Object>(4);
            returnData.put("fieldname", PdsCommonUtils.getCustomParamsByMenu((IFormView)this.getView(), (String)"fieldname"));
            if (StringUtils.isBlank((CharSequence)paramTag)) {
                returnData.put("paramvalue", "");
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                return;
            }
            if ("basedatavalue".equals(paramTag)) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                BasedataProp basedataProp = (BasedataProp)this.getModel().getProperty(paramTag);
                Object pkId = this.getModel().getValue("basedatavalue_id");
                String pattern = basedataProp.getBaseEntityId();
                HashMap<String, Object> basedataValueMap = new HashMap<String, Object>();
                basedataValueMap.put("number", pattern);
                if (StringUtils.isNotBlank((Object)pkId) && !"0".equals(pkId)) {
                    basedataValueMap.put("id", pkId);
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)pattern);
                    Object nameValue = dynamicObject.get(((BasedataEntityType)dynamicObject.getDataEntityType()).getNameProperty());
                    String nameStr = nameValue != null ? nameValue.toString() : "";
                    dataMap.put("defaultvalue", nameStr);
                }
                dataMap.put("basedatavalue", basedataValueMap);
                dataMap.put("type", "basedata");
                returnData.put("returnData", dataMap);
                this.getPageCache().remove("baseentitynumber");
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                return;
            }
            if ("combotype".equals(paramTag)) {
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                String combotype = this.getModel().getDataEntity().getString("combotype");
                dataMap.put("defaultvalue", combotype);
                dataMap.put("type", "combovalue");
                String comboInfo = this.getPageCache().get("comboinfo");
                List comboInfos = SerializationUtils.fromJsonStringToList((String)comboInfo, ComboItem.class);
                dataMap.put("combovalue", this.downValueConversionKey(comboInfos, combotype));
                returnData.put("returnData", dataMap);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                return;
            }
            if ("booleantype".equals(paramTag)) {
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                String paramDefValue = StringUtils.equals((CharSequence)"1", (CharSequence)((String)this.getModel().getValue("booleantype"))) ? SrcCommonConstant.TRUE : SrcCommonConstant.FALSE;
                dataMap.put("type", "boolean");
                dataMap.put("defaultvalue", paramDefValue);
                returnData.put("returnData", dataMap);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                return;
            }
            HashMap<String, String> dataMap = new HashMap<String, String>(4);
            String paramDefValue = "";
            switch (paramTag) {
                case "datetype": {
                    Date date = (Date)this.getModel().getValue("datetype");
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    paramDefValue = simpleDateFormat.format(date);
                    break;
                }
                case "datetimetype": {
                    Date datetimetype = (Date)this.getModel().getValue("datetimetype");
                    SimpleDateFormat simpleDateFormatTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    paramDefValue = simpleDateFormatTime.format(datetimetype);
                    break;
                }
                case "timetype": {
                    Integer timetype = (Integer)this.getModel().getValue("timetype");
                    paramDefValue = this.formatDuration(timetype);
                    break;
                }
                case "decimaltype": {
                    paramDefValue = this.getModel().getDataEntity().getBigDecimal("decimaltype").stripTrailingZeros().toPlainString();
                    break;
                }
                default: {
                    paramDefValue = String.valueOf(this.getModel().getValue(paramTag));
                }
            }
            dataMap.put("type", "text");
            dataMap.put("defaultvalue", paramDefValue);
            returnData.put("returnData", dataMap);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        Map basedataInfoMap;
        Object basedataDef;
        super.getEntityType(e);
        String basedataInfo = (String)this.getView().getFormShowParameter().getCustomParam("basedatainfo");
        if (StringUtils.isNotBlank((CharSequence)basedataInfo) && (basedataDef = (basedataInfoMap = (Map)SerializationUtils.fromJsonString((String)basedataInfo, Map.class)).get("basedatavalue")) != null) {
            Map basedataDefMap = (Map)basedataDef;
            String baseentity = (String)basedataDefMap.get("number");
            this.setEntityType(e, baseentity);
        }
        String baseentity = this.getPageCache().get("baseentitynumber");
        this.setEntityType(e, baseentity);
    }

    private void setEntityType(GetEntityTypeEventArgs e, String baseentity) {
        if (StringUtils.isNotBlank((CharSequence)baseentity)) {
            MainEntityType baseType = EntityMetadataCache.getDataEntityType((String)baseentity);
            MainEntityType mainType = null;
            try {
                mainType = (MainEntityType)e.getOriginalEntityType().clone();
            }
            catch (CloneNotSupportedException var7) {
                log.error(var7.getMessage());
            }
            BasedataProp baseProp = (BasedataProp)mainType.findProperty("basedatavalue");
            baseProp.setComplexType((IDataEntityType)baseType);
            baseProp.setBaseEntityId(baseType.getName());
            DynamicSimpleProperty refIdProp = (DynamicSimpleProperty)mainType.findProperty(baseProp.getRefIdProp().getName());
            mainType.getProperties().remove((Object)refIdProp);
            refIdProp = baseProp.createRefIDProp();
            refIdProp.setPrimaryKey(false);
            if (StringUtils.isBlank((CharSequence)baseProp.getAlias())) {
                refIdProp.setDbIgnore(true);
            } else {
                refIdProp.setAlias(baseProp.getAlias());
                refIdProp.setTableGroup(baseProp.getTableGroup());
            }
            refIdProp.setName(baseProp.getName() + "_id");
            mainType.addProperty((DynamicProperty)refIdProp);
            baseProp.setRefIdPropName(baseProp.getName() + "_id");
            baseProp.setRefIdProp((IDataEntityProperty)refIdProp);
            e.setNewEntityType(mainType);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String value = (String)parameter.getCustomParam("value");
        String visibleType = PdsCommonUtils.object2String((Object)parameter.getCustomParam("visible"), (String)"combotype");
        String title = (String)parameter.getCustomParam("title");
        if (null != title) {
            FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(visibleType);
            fieldEdit.setCaption(new LocaleString(title));
        }
        this.getPageCache().put("param_tag", visibleType);
        switch (visibleType) {
            case "basedatavalue": {
                Map basedataMap;
                Object basedataValueObj;
                String basedataInfo = (String)parameter.getCustomParam("basedatainfo");
                if (!StringUtils.isNotBlank((CharSequence)basedataInfo) || (basedataValueObj = (basedataMap = (Map)SerializationUtils.fromJsonString((String)basedataInfo, Map.class)).get("basedatavalue")) == null) break;
                Map basedataValueMap = (Map)basedataValueObj;
                String basedataValueNumber = (String)basedataValueMap.get("number");
                this.getPageCache().put("baseentitynumber", basedataValueNumber);
                try {
                    this.getModel().setValue("basedatavalue", basedataValueMap.get("id"));
                }
                catch (Exception e1) {
                    BizLog.log((String)e1.getMessage());
                }
                this.bindBaseDataType("basedatavalue", basedataValueNumber);
                break;
            }
            case "combotype": {
                String comboInfo;
                ComboEdit fieldsCombo = (ComboEdit)this.getView().getControl(visibleType);
                if (null != fieldsCombo && StringUtils.isNotBlank((CharSequence)(comboInfo = (String)parameter.getCustomParam("comboinfo")))) {
                    this.getPageCache().put("comboinfo", comboInfo);
                    List comboInfos = SerializationUtils.fromJsonStringToList((String)comboInfo, ComboItem.class);
                    fieldsCombo.setComboItems(comboInfos);
                }
                this.getModel().setValue(visibleType, (Object)value);
                break;
            }
            default: {
                this.getModel().setValue(visibleType, (Object)value);
            }
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{visibleType});
    }

    private void bindBaseDataType(String key, String value) {
        BasedataEdit basedatavalue = (BasedataEdit)this.getView().getControl(key);
        BasedataProp basedataProp = (BasedataProp)basedatavalue.getProperty();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            basedataProp.setBaseEntityId(value);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)value);
            basedataProp.setComplexType((IDataEntityType)dataEntityType);
        }
    }

    private String formatDuration(int duration) {
        if (duration == 0) {
            return "00:00:00";
        }
        String time = String.format("%02d:%2$02d:%3$02d", duration / 3600, duration % 3600 / 60, duration % 60);
        return time;
    }

    private String downValueConversionKey(List<ComboItem> comboItems, String value) {
        String result = "";
        for (ComboItem comboItem : comboItems) {
            if (!StringUtils.equals((CharSequence)value, (CharSequence)comboItem.getValue())) continue;
            result = comboItem.getCaption().getLocaleValue();
            break;
        }
        return result;
    }
}

