/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.formplugin.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.pds.common.util.PdsReportUtils;

public class PdsPrintConvertPdfEdit
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject evt) {
        this.setDefaultValue();
    }

    private void setDefaultValue() {
        Map paramMap = PdsCommonUtils.getCustomParamMap((IFormView)this.getView());
        if (null != paramMap && paramMap.size() > 0) {
            this.getModel().setValue("entityname", paramMap.get("entityname"));
            this.getModel().setValue("compkey", paramMap.get("compkey"));
            this.getModel().setValue("currentrow", paramMap.get("currentrow"));
        }
        ComboEdit billAttach = (ComboEdit)this.getControl("billattach");
        billAttach.setComboItems(PdsMetadataUtil.getComboItemFiled((String)this.getModel().getDataEntity().getString("compkey"), (String)"attachmentpanelap"));
        ComboEdit entryAttach = (ComboEdit)this.getControl("entryattach");
        entryAttach.setComboItems(PdsMetadataUtil.getComboItemFiled((String)this.getModel().getDataEntity().getString("compkey"), (String)"entryap"));
        this.createEntry(this.getModel().getDataEntity().getString("entityname"));
    }

    private void createEntry(String entityName) {
        QFilter qfilter = new QFilter("formid.number", "=", (Object)entityName);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"bos_print_meta", (String)"id", (QFilter[])qfilter.toArray(), (String)"number");
        if (rows == null || rows.size() == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_createpdf"});
            this.getView().setEnable(Boolean.valueOf(false), -1, new String[]{"billattach", "entryattach", "index"});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6ca1\u6709\u914d\u7f6e\u6253\u5370\u6a21\u677f\uff0c\u4e0d\u80fd\u751f\u6210pdf\u9644\u4ef6\u3002", (String)"PdsPrintConvertPdfEdit_2", (String)"scm-pds-formplugin", (Object[])new Object[0]));
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        model.deleteEntryData("entryentity");
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int index = 0;
        Map<String, DynamicObject> defaultMap = this.getDefaultValueMap();
        for (DynamicObject row : rows) {
            ts.set("template", (Object)row.getString("id"), index);
            ts.set("index", (Object)(this.getModel().getDataEntity().getInt("currentrow") + 1), index);
            String key = this.getModel().getDataEntity().getString("entityname") + '|' + this.getModel().getDataEntity().getString("compkey") + '|' + row.getString("id");
            DynamicObject defaultObj = defaultMap.get(key);
            if (null != defaultObj) {
                ts.set("billattach", defaultObj.get("billattach"), index);
                ts.set("entryattach", defaultObj.get("entryattach"), index);
            }
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        switch (opKey = args.getOperateKey()) {
            case "createpdf": {
                this.createPanelAttachment();
                break;
            }
            case "createpdf2": {
                this.createEntryAttachment();
                break;
            }
            case "exit": {
                this.getView().close();
                break;
            }
        }
    }

    private void createPanelAttachment() {
        StringBuilder sb = new StringBuilder();
        DynamicObject billObj = this.getView().getParentView().getModel().getDataEntity();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        IFormView parentView = this.getView().getParentView();
        HashSet<String> updatePanelKeySet = new HashSet<String>(8);
        for (DynamicObject row : rows) {
            String prtTplId = row.getString("template.id");
            String attachPanelKey = row.getString("billattach");
            if (null == attachPanelKey || attachPanelKey.length() <= 0 || prtTplId.length() <= 0) continue;
            PdsReportUtils.createPanelAttachmentAndRebuildUrl((DynamicObject)billObj, (String)prtTplId, (String)attachPanelKey, (boolean)true);
            sb.append(row.getString("template.name")).append(ResManager.loadKDString((String)" \u5df2\u751f\u6210pdf\u9644\u4ef6\n", (String)"PdsPrintConvertPdfEdit_0", (String)"scm-pds-formplugin", (Object[])new Object[0]));
            updatePanelKeySet.add(attachPanelKey);
        }
        for (String attachPanelKey : updatePanelKeySet) {
            parentView.updateView(attachPanelKey);
        }
        this.getView().sendFormAction(parentView);
        this.afterCreateAttachment(sb);
    }

    private void createEntryAttachment() {
        StringBuilder sb = new StringBuilder();
        DynamicObject billObj = this.getView().getParentView().getParentView().getModel().getDataEntity();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        ArrayList<DynamicObject> attachObjs = new ArrayList<DynamicObject>(8);
        IFormView parentView = this.getView().getParentView();
        parentView.getModel().beginInit();
        for (DynamicObject row : rows) {
            String prtTplId = row.getString("template.id");
            String entryAttachKey = row.getString("entryattach");
            if (null == entryAttachKey || entryAttachKey.length() == 0 || prtTplId.length() == 0) continue;
            List attachments = PdsReportUtils.createFieldAttachmentAndRebuildUrl((DynamicObject)billObj, (String)prtTplId, null, (boolean)true);
            for (Map attachment : attachments) {
                DynamicObject attachObj = this.createAttachObj(attachment);
                attachObjs.add(attachObj);
            }
            this.setEntryAttachment(attachObjs, row);
            sb.append(row.getString("template.name")).append(ResManager.loadKDString((String)" \u5df2\u751f\u6210pdf\u9644\u4ef6\n", (String)"PdsPrintConvertPdfEdit_0", (String)"scm-pds-formplugin", (Object[])new Object[0]));
        }
        parentView.getModel().endInit();
        Map paramMap = PdsCommonUtils.getCustomParamMap((IFormView)this.getView());
        parentView.updateView((String)paramMap.get("entryname"));
        this.getView().sendFormAction(parentView);
        this.afterCreateAttachment(sb);
    }

    protected DynamicObject createAttachObj(Map<String, Object> attachment) {
        DynamicObject attachObj = AttachmentFieldServiceHelper.getAttCreatorByUID((String)((String)attachment.get("uid")));
        if (null == attachObj) {
            attachObj = AttachmentUtils.createBdAttachment(attachment);
        }
        return attachObj;
    }

    protected void setEntryAttachment(List<DynamicObject> attachObjs, DynamicObject row) {
        DynamicObject entry;
        int index;
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        String entryAttachKey = row.getString("entryattach");
        String[] attachKeys = entryAttachKey.split("\\.");
        int maxIndex = parentView.getModel().getEntryRowCount(attachKeys[0]) - 1;
        if (maxIndex < 0) {
            maxIndex = 0;
        }
        int n = index = row.getInt("index") <= 1 ? 0 : row.getInt("index") - 1;
        if (index > maxIndex) {
            index = maxIndex;
        }
        if (null == (entry = parentView.getModel().getEntryRowEntity(attachKeys[0], index))) {
            return;
        }
        Set idSet = MultiBasedataUtils.getBasedataIdSet((DynamicObject)entry, (String)attachKeys[1]);
        Set newIdSet = attachObjs.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        IDataModel model = parentView.getModel();
        if (idSet.addAll(newIdSet)) {
            model.setValue(attachKeys[1], (Object)idSet.toArray(), index);
            String fileName = AttachmentUtils.getAttachFileName(attachObjs);
            IDataEntityProperty property = model.getProperty("packfilename");
            if (null != property) {
                model.setValue("packfilename", (Object)fileName, index);
            }
        }
    }

    private void afterCreateAttachment(StringBuilder sb) {
        if (sb.length() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9pdf\u9644\u4ef6\u4e0a\u4f20\u7684\u9762\u677f\uff0c\u518d\u751f\u6210pdf\u9644\u4ef6\u3002", (String)"PdsPrintConvertPdfEdit_1", (String)"scm-pds-formplugin", (Object[])new Object[0]));
        } else {
            this.saveDefaultValue();
            this.getView().showSuccessNotification(sb.toString());
            this.getView().close();
        }
    }

    private Map<String, DynamicObject> getDefaultValueMap() {
        String entityName = this.getModel().getDataEntity().getString("entityname");
        String compKey = this.getModel().getDataEntity().getString("compkey");
        QFilter qfilter = new QFilter("entityname", "=", (Object)entityName);
        qfilter.and("compkey", "=", (Object)compKey);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"pds_print_pdf_set", (boolean)false);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"pds_print_pdf_set", (String)selectFields, (QFilter[])qfilter.toArray());
        return Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getString("entityname") + '|' + e.getString("compkey") + '|' + e.getString("template.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
    }

    private void saveDefaultValue() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        if (rows.size() == 0) {
            return;
        }
        String entityName = this.getModel().getDataEntity().getString("entityname");
        String compKey = this.getModel().getDataEntity().getString("compkey");
        ArrayList<DynamicObject> defaultList = new ArrayList<DynamicObject>(rows.size());
        Map<String, DynamicObject> defaultMap = this.getDefaultValueMap();
        for (DynamicObject row : rows) {
            String key = entityName + '|' + compKey + '|' + row.getString("template.id");
            DynamicObject defaultObj = defaultMap.get(key);
            if (null != defaultObj) {
                if (defaultObj.getString("billattach").equals(row.getString("billattach")) && defaultObj.getString("entryattach").equals(row.getString("entryattach"))) {
                    continue;
                }
            } else {
                defaultObj = BusinessDataServiceHelper.newDynamicObject((String)"pds_print_pdf_set");
                defaultObj.set("entityname", (Object)entityName);
                defaultObj.set("compkey", (Object)compKey);
                defaultObj.set("template", (Object)row.getString("template.id"));
            }
            defaultObj.set("billattach", row.get("billattach"));
            defaultObj.set("entryattach", row.get("entryattach"));
            defaultList.add(defaultObj);
        }
        PdsCommonUtils.saveDynamicObjects(defaultList);
    }
}

