/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.parser.JdApiParser;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ExceptionUtil;

public class PmmMallGoodsUtil {
    private static final Log log = LogFactory.getLog((String)PmmMallGoodsUtil.class.getName());

    public static void updateMallGoods(String platform, List<Object> goodsNumbers) {
        try {
            ApiAccessor.invokeServiceFlow((String)PmmMallGoodsUtil.getServiceFlowNumber(platform), Collections.singletonList(goodsNumbers));
        }
        catch (Exception e) {
            log.warn(ExceptionUtil.getStackTrace((Throwable)e));
            throw new KDBizException(e.getMessage());
        }
    }

    public static void cleanDuplicateItems(String platform) {
        HashSet<Object> goodsIdSet = new HashSet<Object>();
        HashSet<String> goodsNumberSet = new HashSet<String>();
        String goodsOql = "SELECT fid AS goodsid,fnumber AS goodsnumber FROM t_mal_goods WHERE FNUMBER IN (SELECT FNUMBER FROM t_mal_goods GROUP BY fnumber HAVING (COUNT(fnumber) > 1)) AND FSOURCE = ?";
        try (DataSet goodsDataSet = DB.queryDataSet((String)RequestContext.get().getTraceId(), (DBRoute)DBRoute.of((String)"pur"), (String)goodsOql, (Object[])new Object[]{platform});){
            for (Row goodsRow : goodsDataSet) {
                goodsIdSet.add(goodsRow.get("goodsid"));
                goodsNumberSet.add(goodsRow.getString("goodsnumber"));
            }
            String statusOql = "SELECT B.fid AS goodsid,B.fnumber AS goodsnumber FROM t_mal_goods_status A INNER JOIN t_mal_goods B ON A.fmallgoodsid = B.fid WHERE A.fmallgoodsid IN (SELECT fmallgoodsid FROM t_mal_goods_status GROUP BY fmallgoodsid HAVING (COUNT(fmallgoodsid) > 1)) AND B.FSOURCE = ?";
            try (DataSet statusDataSet = DB.queryDataSet((String)RequestContext.get().getTraceId(), (DBRoute)DBRoute.of((String)"pur"), (String)statusOql, (Object[])new Object[]{platform});){
                for (Row statusRow : statusDataSet) {
                    goodsIdSet.add(statusRow.get("goodsid"));
                    goodsNumberSet.add(statusRow.getString("goodsnumber"));
                }
            }
            String priceOql = "SELECT B.fid AS goodsid,B.fnumber AS goodsnumber FROM t_mal_goods_price A INNER JOIN t_mal_goods B ON A.fmallgoodsid = B.fid WHERE A.fmallgoodsid IN (SELECT fmallgoodsid FROM t_mal_goods_price GROUP BY fmallgoodsid HAVING (COUNT(fmallgoodsid) > 1)) AND B.FSOURCE = ?";
            DataSet priceDataSet = DB.queryDataSet((String)RequestContext.get().getTraceId(), (DBRoute)DBRoute.of((String)"pur"), (String)priceOql, (Object[])new Object[]{platform});
            Object object = null;
            try {
                for (Object priceRow : priceDataSet) {
                    goodsIdSet.add(priceRow.get("goodsid"));
                    goodsNumberSet.add(priceRow.getString("goodsnumber"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (priceDataSet != null) {
                    if (object != null) {
                        try {
                            priceDataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        priceDataSet.close();
                    }
                }
            }
            HashSet<Object> needDownloadStatusSet = new HashSet<Object>(goodsIdSet.size());
            DataSet statusDs = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_mallgoods_status", (String)"id", (QFilter[])new QFilter[]{new QFilter("mallgoods.id", "in", goodsIdSet)}, null);
            Object object2 = null;
            try {
                for (Row statusRow : statusDs) {
                    needDownloadStatusSet.add(statusRow.get("id"));
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("isStrict", String.valueOf(false));
                option.setVariableValue("ishasright", String.valueOf(true));
                OperationResult downloadResult = OperationServiceHelper.executeOperate((String)"download", (String)"pbd_mallgoods_status", (Object[])needDownloadStatusSet.toArray(), (OperateOption)option);
                log.info("\u540e\u53f0\u4e0b\u67b6\u5546\u54c1\u72b6\u6001id\u96c6\u5408\uff1a" + needDownloadStatusSet);
                try {
                    CommonUtil.check((OperationResult)downloadResult);
                }
                catch (Exception e) {
                    log.warn("\u540e\u53f0\u4e0b\u67b6\u91cd\u590d\u5546\u54c1\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (statusDs != null) {
                    if (object2 != null) {
                        try {
                            statusDs.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        statusDs.close();
                    }
                }
            }
            PmmMallGoodsUtil.delDownloadGoods(new ArrayList<Object>(goodsIdSet), platform);
            if (!goodsNumberSet.isEmpty()) {
                PmmMallGoodsUtil.updateMallGoods(platform, new ArrayList<Object>(goodsNumberSet));
            }
        }
    }

    public static void delDownloadGoods(List<Object> needDelGoodsIdSet, String platform) {
        QFilter statusinfoFilter = new QFilter("statusinfo.id", "=", (Object)0).and("source", "=", (Object)platform);
        QFilter ecstatusFilter = new QFilter("statusinfo.ecstatus", "=", (Object)"0").and("source", "=", (Object)platform);
        PmmMallGoodsUtil.innerDelDownloadGoods(needDelGoodsIdSet, statusinfoFilter);
        PmmMallGoodsUtil.innerDelDownloadGoods(needDelGoodsIdSet, ecstatusFilter);
    }

    private static void innerDelDownloadGoods(List<Object> needDelGoodsIdSet, QFilter filter) {
        if (!ObjectUtils.isEmpty(needDelGoodsIdSet)) {
            filter.and("id", "in", needDelGoodsIdSet);
        }
        int pageSize = 1000;
        ORM orm = ORM.create();
        String selectFields = "id,number,priceinfo.id,statusinfo.id";
        boolean isContinue = true;
        int from = 0;
        ArrayList clearGoods = new ArrayList(16);
        while (isContinue) {
            DataSet ecGoodsDs = PmmMallGoodsUtil.queryMallGoodsDataSet(filter, pageSize, orm, selectFields, from);
            Throwable throwable = null;
            try {
                ArrayList<String> mallGoodsNumber = new ArrayList<String>(needDelGoodsIdSet.size());
                HashMap<Object, Object> goodsId2StatusIdMap = new HashMap<Object, Object>(needDelGoodsIdSet.size() << 2);
                HashMap<Object, Object> goodsId2PriceIdMap = new HashMap<Object, Object>(needDelGoodsIdSet.size() << 2);
                for (Row row : ecGoodsDs) {
                    mallGoodsNumber.add(row.getString("number"));
                    goodsId2StatusIdMap.put(row.get("id"), row.get("statusinfo.id"));
                    goodsId2PriceIdMap.put(row.get("id"), row.get("priceinfo.id"));
                }
                if (goodsId2StatusIdMap.isEmpty()) {
                    isContinue = false;
                }
                try (DataSet prodManageDs = PmmMallGoodsUtil.queryProdManageDataSet(goodsId2StatusIdMap);){
                    for (Row row : prodManageDs) {
                        mallGoodsNumber.remove(row.getString("number"));
                        goodsId2StatusIdMap.remove(row.get("id"));
                        goodsId2PriceIdMap.remove(row.get("id"));
                    }
                }
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pbd_mallgoods_status"), (Object[])goodsId2StatusIdMap.values().toArray(new Object[0]));
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pbd_mallgoods_price"), (Object[])goodsId2PriceIdMap.values().toArray(new Object[0]));
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pbd_mallgoods"), (Object[])goodsId2StatusIdMap.keySet().toArray());
                from = from + pageSize - goodsId2StatusIdMap.size();
                clearGoods.addAll(mallGoodsNumber);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ecGoodsDs == null) continue;
                if (throwable != null) {
                    try {
                        ecGoodsDs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ecGoodsDs.close();
            }
        }
        log.info("\u6e05\u7406\u4e0b\u67b6\u5546\u54c1\u6210\u529f\uff1a" + SerializationUtils.toJsonString(clearGoods));
    }

    private static DataSet queryProdManageDataSet(Map<Object, Object> goodsId2StatusIdMap) {
        return QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pmm_prodmanage", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", goodsId2StatusIdMap.keySet())}, null);
    }

    private static DataSet queryMallGoodsDataSet(QFilter filter, int pageSize, ORM orm, String selectFields, int from) {
        return orm.queryDataSet(RequestContext.get().getTraceId(), "pmm_mallgoods", selectFields, new QFilter[]{filter}, "id", from, pageSize);
    }

    private static String getServiceFlowNumber(String platform) {
        if (EcPlatformEnum.ECPLATFORM_JD.getVal().equals(platform)) {
            return "SRM_JD_GOODS_INIT_SUB";
        }
        if (EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(platform)) {
            return "SRM_SN_GOODS_INIT_SUB";
        }
        if (EcPlatformEnum.ECPLATFORM_XY.getVal().equals(platform)) {
            return "SRM_XY_GOODS_INIT_SUB";
        }
        if (EcPlatformEnum.ECPLATFORM_CG.getVal().equals(platform)) {
            return "SRM_CG_GOODS_INIT_SUB";
        }
        if (EcPlatformEnum.ECPLATFORM_DL.getVal().equals(platform)) {
            return "SRM_DL_GOODS_INIT_SUB";
        }
        if (EcPlatformEnum.ECPLATFORM_XFS.getVal().equals(platform)) {
            return "SRM_XFS_GOODS_UPDATE";
        }
        if (EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(platform)) {
            return JdApiParser.getJdApiNumber((String)platform, (String)"SRM_JD_GOODS_INIT_SUB");
        }
        if (EcPlatformEnum.ECPLATFORM_ZKH.getVal().equals(platform)) {
            return "SRM_ZKH_GOODS_UPDATE";
        }
        return "";
    }

    public static void updateEcIscSchema(String platform) {
        String filePath = PmmMallGoodsUtil.getFilePath(platform);
        DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"PmmEcIscSchemaManageService", (String)"updateEcIscSchema", (Object[])new Object[]{filePath});
        DynamicObject releaseConfig = BusinessDataServiceHelper.loadSingle((String)"pmm_inittask", (QFilter[])new QFilter[]{new QFilter("platform", "=", (Object)platform).and("classname", "=", (Object)"kd.scm.pmm.service.ecinit.action.EcIscSchemaReleaseAction")});
        DynamicObjectCollection entrys = releaseConfig.getDynamicObjectCollection("entryentity");
        if (null != entrys) {
            ArrayList<Long> flowIds = new ArrayList<Long>(entrys.size());
            for (DynamicObject entry : entrys) {
                flowIds.add(entry.getLong("flow_id"));
            }
            if (!flowIds.isEmpty()) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                Object[] ids = flowIds.toArray(new Object[0]);
                OperationResult opResult = OperationServiceHelper.executeOperate((String)"release", (String)"isc_service_flow", (Object[])ids, (OperateOption)option);
                CommonUtil.check((OperationResult)opResult);
            }
        }
    }

    private static String getFilePath(String platform) {
        if (EcPlatformEnum.ECPLATFORM_JD.getVal().equals(platform)) {
            return "/kd/scm/pmm/SCM-JD/SCHEMA/SCHEMA.zip";
        }
        if (EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(platform)) {
            return "/kd/scm/pmm/SCM-SN/SCHEMA/SCHEMA.zip";
        }
        if (EcPlatformEnum.ECPLATFORM_XY.getVal().equals(platform)) {
            return "/kd/scm/pmm/SCM-XY/SCHEMA/SCHEMA.zip";
        }
        if (EcPlatformEnum.ECPLATFORM_CG.getVal().equals(platform)) {
            return "/kd/scm/pmm/SCM-CG/SCHEMA/SCHEMA.zip";
        }
        if (EcPlatformEnum.ECPLATFORM_DL.getVal().equals(platform)) {
            return "/kd/scm/pmm/SCM-DL/SCHEMA/SCHEMA.zip";
        }
        if (EcPlatformEnum.ECPLATFORM_XFS.getVal().equals(platform)) {
            return "/kd/scm/pmm/SCM-XFS/SCHEMA/SCHEMA.zip";
        }
        if (EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(platform)) {
            return "/kd/scm/pmm/SCM-JDPRO/SCHEMA/SCHEMA.zip";
        }
        if (EcPlatformEnum.ECPLATFORM_ZKH.getVal().equals(platform)) {
            return "/kd/scm/pmm/SCM-ZKH/SCHEMA/SCHEMA.zip";
        }
        return "";
    }
}

