/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.report.mutidimamount;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataHandle;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DateUtil;
import kd.scm.pmm.report.mutidimamount.PmmMultiDimAmountRptParam;

public class PmmMultiDimAmountRptForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String MUL_DEP_ORG = "muldeporg";
    private static final String MUL_PUR_ORG = "mulpurorg";
    private static final String MUL_SETTLE_ORG = "mulsettleorg";
    private static final String MUL_EXPENSE_ORG = "mulexpenseorg";
    private static final String MUL_SUPPLIER = "mulsupplier";
    private static final String MUL_GOODS_CATEGORY = "mulgoodscategory";
    private static final String QUERYSCHEME = "queryscheme";

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getView().getModel();
        Object startdate = model.getValue(START_DATE);
        Object enddate = model.getValue(END_DATE);
        if (startdate == null && enddate == null) {
            Date today = TimeServiceHelper.today();
            today = DateUtil.formatEndDate((Date)today);
            model.setValue(END_DATE, (Object)today);
            Date startDate = DateUtil.formatStartDate((Date)DateUtil.addMonth((Date)today, (int)-6));
            model.setValue(START_DATE, (Object)startDate);
        }
        ReportConf conf = ReportDataHandle.loadReportConf((String)"pmm_multidimamountrpt");
        this.fillComboItem(conf);
        this.getModel().setValue(MUL_DEP_ORG, (Object)new Object[]{RequestContext.get().getOrgId()});
    }

    private void fillComboItem(ReportConf conf) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)BillStatusEnum.AUDIT.getVal());
        List bigTableColConfs = conf.getBigTableColConf();
        Map<String, String> numberAndNameMap = bigTableColConfs.stream().filter(bigTableColConf -> "A".equals(bigTableColConf.getCalType())).collect(Collectors.toMap(BigTableColConf::getCol, BigTableColConf::getColName));
        String defaultScheme = "";
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(8);
        try (DataSet querySchemes = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"pmmamountqueryscheme", (String)"id,name,summarybasiskey,isdefault", (QFilter[])qFilter.toArray(), null);){
            for (Row queryScheme : querySchemes) {
                StringBuilder caption = new StringBuilder();
                StringBuilder value = new StringBuilder();
                String name = queryScheme.getString("name");
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    caption.append(name);
                }
                caption.append("\uff08");
                String summarybasiskey = queryScheme.getString("summarybasiskey");
                if (StringUtils.isNotBlank((CharSequence)summarybasiskey)) {
                    String[] keys;
                    for (String key : keys = summarybasiskey.split(",")) {
                        if (!StringUtils.isNotBlank((CharSequence)key) || !numberAndNameMap.containsKey(key)) continue;
                        caption.append(numberAndNameMap.get(key)).append("+");
                        value.append(key).append(",");
                    }
                }
                if (value.length() <= 0) continue;
                caption.setLength(caption.length() - 1);
                caption.append("\uff09");
                value.setLength(value.length() - 1);
                value.append("_").append(queryScheme.getString("id"));
                combos.add(new ComboItem(new LocaleString(caption.toString()), value.toString()));
                if (!queryScheme.getBoolean("isdefault").booleanValue()) continue;
                defaultScheme = value.toString();
            }
        }
        ComboEdit item = (ComboEdit)this.getView().getControl(QUERYSCHEME);
        item.setComboItems(combos);
        this.getModel().setValue("showkeycols", (Object)this.getQueryFieldByScheme(defaultScheme));
        this.getModel().setValue(QUERYSCHEME, (Object)defaultScheme);
    }

    private String getQueryFieldByScheme(String schemeValue) {
        return schemeValue.split("_")[0];
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (QUERYSCHEME.equals(propertyName)) {
            this.getModel().setValue("showkeycols", (Object)this.getQueryFieldByScheme((String)this.getModel().getValue(QUERYSCHEME)));
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        Date startdate = filter.getDate(START_DATE);
        Date enddate = filter.getDate(END_DATE);
        if (startdate == null || enddate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8ba2\u8d27\u65e5\u671f\u3002", (String)"PmmMultiDimAmountRptForm_0", (String)"scm-pmm-report", (Object[])new Object[0]));
            return false;
        }
        List<Long> depOrgIdList = PmmMultiDimAmountRptForm.getIdList((Collection<DynamicObject>)filter.getDynamicObjectCollection(MUL_DEP_ORG));
        if (CollectionUtils.isEmpty(depOrgIdList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u8bf7\u7ec4\u7ec7\u3002", (String)"PmmMultiDimAmountRptForm_2", (String)"scm-pmm-report", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((Object)filter.getValue("showkeycols")) || filter.getString("showkeycols").split(",").length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u67e5\u8be2\u65b9\u6848\u3002", (String)"PmmMultiDimAmountRptForm_1", (String)"scm-pmm-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit mulreqorg = (BasedataEdit)this.getControl(MUL_DEP_ORG);
        mulreqorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mulpurorg = (BasedataEdit)this.getControl(MUL_PUR_ORG);
        mulpurorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mulsettleorg = (BasedataEdit)this.getControl(MUL_SETTLE_ORG);
        mulsettleorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mulexpenseorg = (BasedataEdit)this.getControl(MUL_EXPENSE_ORG);
        mulexpenseorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mulsupplier = (BasedataEdit)this.getControl(MUL_SUPPLIER);
        mulsupplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mulgoodscategory = (BasedataEdit)this.getControl(MUL_GOODS_CATEGORY);
        mulgoodscategory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        HasPermOrgResult hasPermOrgResult;
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        if ((MUL_DEP_ORG.equals(name) || MUL_PUR_ORG.equals(name) || MUL_SETTLE_ORG.equals(name) || MUL_EXPENSE_ORG.equals(name)) && !(hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId())).hasAllOrgPerm()) {
            qFilters.add(new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
        }
        if (MUL_SUPPLIER.equals(name)) {
            qFilters.add(new QFilter("mallstatus", "in", (Object)new String[]{"B", "C", "D"}));
        }
        if (MUL_GOODS_CATEGORY.equals(name)) {
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        PmmMultiDimAmountRptParam pmmMultiDimAmountRptParam = new PmmMultiDimAmountRptParam();
        FilterInfo filterInfo = queryParam.getFilter();
        pmmMultiDimAmountRptParam.setStartDate(filterInfo.getDate(START_DATE));
        pmmMultiDimAmountRptParam.setEndDate(filterInfo.getDate(END_DATE));
        pmmMultiDimAmountRptParam.setMulDepOrgList(PmmMultiDimAmountRptForm.getIdList((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection(MUL_DEP_ORG)));
        pmmMultiDimAmountRptParam.setMulPurOrgList(PmmMultiDimAmountRptForm.getIdList((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection(MUL_PUR_ORG)));
        pmmMultiDimAmountRptParam.setMulSettleList(PmmMultiDimAmountRptForm.getIdList((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection(MUL_SETTLE_ORG)));
        pmmMultiDimAmountRptParam.setMulExpenseList(PmmMultiDimAmountRptForm.getIdList((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection(MUL_EXPENSE_ORG)));
        pmmMultiDimAmountRptParam.setMulSupplierList(PmmMultiDimAmountRptForm.getIdList((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection(MUL_SUPPLIER)));
        pmmMultiDimAmountRptParam.setMulGoodsCategoryList(PmmMultiDimAmountRptForm.getIdList((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection(MUL_GOODS_CATEGORY)));
        ArrayList<String> orderByFields = new ArrayList<String>(8);
        orderByFields.add(filterInfo.getString("seqdimension"));
        pmmMultiDimAmountRptParam.setOrderByFields(orderByFields);
        queryParam.getCustomParam().put("param", pmmMultiDimAmountRptParam);
    }

    private static List<Long> getIdList(Collection<DynamicObject> objs) {
        if (objs == null) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> pks = new ArrayList<Long>(objs.size());
        for (DynamicObject obj : objs) {
            pks.add(obj.getLong("id"));
        }
        return pks;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        ReportList reportList = (ReportList)evt.getSource();
        int rowIndex = evt.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        if ("tradingamount".equals(evt.getFieldName()) || "tradingqty".equals(evt.getFieldName())) {
            QFilter qFilter = new QFilter("billdate", ">=", this.getModel().getValue(START_DATE));
            qFilter.and("billdate", "<", (Object)DateUtil.addDays((Date)((Date)this.getModel().getValue(END_DATE)), (int)1));
            PmmMultiDimAmountRptParam pmmMultiDimAmountRptParam = new PmmMultiDimAmountRptParam();
            pmmMultiDimAmountRptParam.setStartDate((Date)this.getModel().getValue(START_DATE));
            pmmMultiDimAmountRptParam.setEndDate((Date)this.getModel().getValue(END_DATE));
            PmmMultiDimAmountRptForm.addQFilter(rowData, "deporg", "deporg", qFilter);
            PmmMultiDimAmountRptForm.addQFilter(rowData, "org", "purorg", qFilter);
            PmmMultiDimAmountRptForm.addQFilter(rowData, "settleorg", "settleorg", qFilter);
            PmmMultiDimAmountRptForm.addQFilter(rowData, "expenseorg", "expenseorg", qFilter);
            PmmMultiDimAmountRptForm.addQFilter(rowData, "entryentity.supplier.id", "supplier", qFilter);
            PmmMultiDimAmountRptForm.addQFilter(rowData, "entryentity.goods.category.id", "goodscategory", qFilter);
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.getListFilterParameter().setFilter(qFilter);
            listShowParameter.setBillFormId("pmm_puramountdetail");
            listShowParameter.setCustomParam("rptParam", (Object)SerializationUtils.toJsonString((Object)pmmMultiDimAmountRptParam));
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private static void addQFilter(DynamicObject rowData, String targetProperty, String srcProperty, QFilter qFilter) {
        if (rowData.getDynamicObjectType().getProperties().containsKey((Object)srcProperty) && qFilter != null && rowData.getLong(srcProperty + "_id") != 0L) {
            qFilter.and(new QFilter(targetProperty, "=", (Object)rowData.getLong(srcProperty + "_id")));
        }
    }
}

