/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.report.mutidimamount;

import java.util.Arrays;
import java.util.List;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pmm.report.mutidimamount.PmmMultiReturnAmountMapFunc;

public class PmmMultiDimAmountTransform
implements IDataXTransform {
    private ReportDataCtx ctx;
    List<String> orderByFields;

    public PmmMultiDimAmountTransform(ReportDataCtx ctx) {
        this.ctx = ctx;
    }

    public PmmMultiDimAmountTransform(ReportDataCtx ctx, List<String> orderByFields) {
        this.ctx = ctx;
        this.orderByFields = orderByFields;
    }

    public DataSetX doTransform(DataSetX srcData) {
        QFilter purOrderQFilter = new QFilter("billstatus", "in", Arrays.asList(BillStatusEnum.AUDIT.getVal(), BillStatusEnum.CLOSED.getVal()));
        OrmInput purOrderInput = new OrmInput("PmmMultiDimAmountTransform_pur_order", "pur_order", "billno billno_right,materialentry.srcentryid srcentryid_right,materialentry.poentryid poentryid", purOrderQFilter.toArray());
        DataSetX purOrderSubData = this.ctx.getCurrentJob().fromInput((Input)purOrderInput);
        srcData = srcData.leftJoin(purOrderSubData).on("entryid", "srcentryid_right").on("erpbillnumber", "billno_right").removeFields(new String[]{"srcentryid_right"});
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        OrmInput purReturnInput = new OrmInput("PmmMultiDimAmountTransform_pur_return", "pur_return", "materialentry.poentryid poentryid_right_a,materialentry.taxamount taxamount_return", qFilter.toArray());
        DataSetX purReturnSubData = this.ctx.getCurrentJob().fromInput((Input)purReturnInput).groupBy(new String[]{"poentryid_right_a"}).sum("taxamount_return");
        srcData = srcData.leftJoin(purReturnSubData).on("poentryid", "poentryid_right_a");
        QFilter receiveQFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        receiveQFilter.and("isreturn", "=", (Object)"1");
        OrmInput purReceiptReturnInput = new OrmInput("PmmMultiDimAmountTransform_pur_receipt_return", "pur_receipt_return", "materialentry.poentryid poentryid_right_b,materialentry.taxamount taxamount_receipt_return", receiveQFilter.toArray());
        DataSetX purReceiveReturnSubData = this.ctx.getCurrentJob().fromInput((Input)purReceiptReturnInput).groupBy(new String[]{"poentryid_right_b"}).sum("taxamount_receipt_return");
        srcData = srcData.leftJoin(purReceiveReturnSubData).on("poentryid", "poentryid_right_b");
        srcData = srcData.map((MapFunction)new PmmMultiReturnAmountMapFunc(srcData.getRowMeta()));
        srcData.orderBy(this.orderByFields.toArray(new String[0]));
        return srcData;
    }
}

