/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.report.mutidimamount;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DateUtil;
import kd.scm.pmm.report.mutidimamount.PmmMultiDimAmountRptParam;

public class PmmPurAmountDetailList
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId());
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            qFilters.add(new QFilter("deporg", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String rptParamJson = (String)formShowParameter.getCustomParam("rptParam");
        if (StringUtils.isBlank((CharSequence)rptParamJson)) {
            return;
        }
        PmmMultiDimAmountRptParam rptParam = (PmmMultiDimAmountRptParam)SerializationUtils.fromJsonString((String)rptParamJson, PmmMultiDimAmountRptParam.class);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            String fieldName = commonFilterColumn.getFieldName();
            if (!"billdate".equals(fieldName)) continue;
            commonFilterColumn.setDefaultValues(new Object[]{DateUtil.date2str((Date)rptParam.getStartDate(), (String)"yyyy-MM-dd"), DateUtil.date2str((Date)rptParam.getEndDate(), (String)"yyyy-MM-dd")});
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new PmmPurAmountDetailListDataProvider());
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        HasPermOrgResult hasPermOrgResult;
        super.filterColumnSetFilter(args);
        List<String> orgFields = Arrays.asList("deporg.name", "org.name", "settleorg.name", "expenseorg.name");
        if (orgFields.contains(args.getFieldName()) && !(hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId())).hasAllOrgPerm()) {
            args.addCustomQFilter(new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        HasPermOrgResult hasPermOrgResult;
        super.filterContainerBeforeF7Select(args);
        if ("bos_org".equals(args.getRefEntityId()) && !(hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId())).hasAllOrgPerm()) {
            args.addCustomQFilter(new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
        }
        if ("bd_supplier".equals(args.getRefEntityId())) {
            args.addCustomQFilter(new QFilter("mallstatus", "in", (Object)new String[]{"B", "C", "D"}));
        }
    }

    static class PmmPurAmountDetailListDataProvider
    extends ListDataProvider {
        PmmPurAmountDetailListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            this.setMalOrderQtyAndAmount(rows);
            return rows;
        }

        private void setMalOrderQtyAndAmount(DynamicObjectCollection rows) {
            for (DynamicObject malOrder : rows) {
                if (!malOrder.getDynamicObjectType().getProperties().containsKey((Object)"platform") || EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malOrder.getString("platform"))) continue;
                malOrder.set("platform", (Object)"Z");
            }
            if (!((DynamicObject)rows.get(0)).getDynamicObjectType().getProperties().containsKey((Object)"entryentity.id")) {
                return;
            }
            HashMap<Long, Object> platformMap = new HashMap<Long, Object>(rows.size());
            HashMap<Long, Object> taxamountMap = new HashMap<Long, Object>(rows.size());
            HashMap<Long, Object> returnamountMap = new HashMap<Long, Object>(rows.size());
            HashMap<Long, Object> erpbillnumberMap = new HashMap<Long, Object>(rows.size());
            HashMap<Long, Object> sumreturnreqqtyMap = new HashMap<Long, Object>(rows.size());
            HashMap<Long, Object> amountMap = new HashMap<Long, Object>(rows.size());
            if (!(((DynamicObject)rows.get(0)).getDynamicObjectType().getProperties().containsKey((Object)"platform") && ((DynamicObject)rows.get(0)).getDynamicObjectType().getProperties().containsKey((Object)"entryentity.taxamount") && ((DynamicObject)rows.get(0)).getDynamicObjectType().getProperties().containsKey((Object)"entryentity.returnamount") && ((DynamicObject)rows.get(0)).getDynamicObjectType().getProperties().containsKey((Object)"entryentity.erpbillnumber"))) {
                List ids = rows.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mal_order", (String)"id,platform,entryentity.id,entryentity.taxamount,entryentity.returnamount,entryentity.erpbillnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, null);
                Object object = null;
                try {
                    dataSet.forEach(row -> {
                        platformMap.put(row.getLong("entryentity.id"), row.getString("platform"));
                        taxamountMap.put(row.getLong("entryentity.id"), row.getBigDecimal("entryentity.taxamount"));
                        returnamountMap.put(row.getLong("entryentity.id"), row.getBigDecimal("entryentity.returnamount"));
                        erpbillnumberMap.put(row.getLong("entryentity.id"), row.getString("entryentity.erpbillnumber"));
                    });
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (dataSet != null) {
                        if (object != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
            }
            for (DynamicObject malOrder : rows) {
                this.setFieldValue(malOrder, "entryentity.sumreturnreqqty", BigDecimal.ZERO, sumreturnreqqtyMap);
                if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(this.getFieldValue(malOrder, "platform", platformMap))) {
                    this.setFieldValue(malOrder, "entryentity.returnamount", BigDecimal.ZERO, returnamountMap);
                }
                this.setFieldValue(malOrder, "entryentity.amount", BigDecimal.ZERO, amountMap);
            }
            HashMap<String, DynamicObject> entryIdAndDynMap = new HashMap<String, DynamicObject>(rows.size());
            ArrayList<String> entryIds = new ArrayList<String>(rows.size());
            rows.forEach(row -> entryIdAndDynMap.put(row.getString("entryentity.id"), (DynamicObject)row));
            for (DynamicObject row2 : rows) {
                entryIdAndDynMap.put(row2.getString("entryentity.id") + "_" + this.getFieldValue(row2, "entryentity.erpbillnumber", erpbillnumberMap), row2);
                entryIds.add(row2.getString("entryentity.id"));
            }
            HashMap<String, DynamicObject> poEntryIdAndDynMap = new HashMap<String, DynamicObject>(rows.size());
            QFilter purOrderQFilter = new QFilter("materialentry.srcentryid", "in", entryIds);
            purOrderQFilter.and("billstatus", "in", Arrays.asList(BillStatusEnum.AUDIT.getVal(), BillStatusEnum.CLOSED.getVal()));
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pur_order", (String)"billno,materialentry.srcentryid srcentryid,materialentry.poentryid poentryid", (QFilter[])purOrderQFilter.toArray(), null);
            Object object = null;
            try {
                for (Row row3 : dataSet) {
                    DynamicObject malOrder = (DynamicObject)entryIdAndDynMap.get(row3.getString("srcentryid") + "_" + row3.getString("billno"));
                    if (malOrder == null) continue;
                    poEntryIdAndDynMap.put(row3.getString("poentryid"), malOrder);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            QFilter returnQFilter = new QFilter("materialentry.poentryid", "in", poEntryIdAndDynMap.keySet());
            returnQFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
            DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pur_return", (String)"materialentry.poentryid poentryid,materialentry.taxamount taxamount,materialentry.qty qty", (QFilter[])returnQFilter.toArray(), null);
            Object object2 = null;
            try {
                dataSet2.forEach(row -> {
                    DynamicObject malOrder = (DynamicObject)poEntryIdAndDynMap.get(row.getString("poentryid"));
                    if (malOrder != null) {
                        this.setFieldValue(malOrder, "entryentity.sumreturnreqqty", row.getBigDecimal("qty").abs().add((BigDecimal)this.getFieldValue(malOrder, "entryentity.sumreturnreqqty", sumreturnreqqtyMap)), sumreturnreqqtyMap);
                        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(this.getFieldValue(malOrder, "platform", platformMap))) {
                            this.setFieldValue(malOrder, "entryentity.returnamount", row.getBigDecimal("taxamount").abs().add((BigDecimal)this.getFieldValue(malOrder, "entryentity.returnamount", returnamountMap)), returnamountMap);
                        }
                    }
                });
            }
            catch (Throwable row3) {
                object2 = row3;
                throw row3;
            }
            finally {
                if (dataSet2 != null) {
                    if (object2 != null) {
                        try {
                            dataSet2.close();
                        }
                        catch (Throwable row3) {
                            ((Throwable)object2).addSuppressed(row3);
                        }
                    } else {
                        dataSet2.close();
                    }
                }
            }
            returnQFilter.and("isreturn", "=", (Object)"1");
            dataSet2 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pur_receipt_return", (String)"materialentry.poentryid poentryid,materialentry.taxamount taxamount,materialentry.qty qty", (QFilter[])returnQFilter.toArray(), null);
            object2 = null;
            try {
                dataSet2.forEach(row -> {
                    DynamicObject malOrder = (DynamicObject)poEntryIdAndDynMap.get(row.getString("poentryid"));
                    if (malOrder != null) {
                        this.setFieldValue(malOrder, "entryentity.sumreturnreqqty", row.getBigDecimal("qty").abs().add((BigDecimal)this.getFieldValue(malOrder, "entryentity.sumreturnreqqty", sumreturnreqqtyMap)), sumreturnreqqtyMap);
                        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(this.getFieldValue(malOrder, "platform", platformMap))) {
                            this.setFieldValue(malOrder, "entryentity.returnamount", row.getBigDecimal("taxamount").abs().add((BigDecimal)this.getFieldValue(malOrder, "entryentity.returnamount", returnamountMap)), returnamountMap);
                        }
                    }
                });
            }
            catch (Throwable row3) {
                object2 = row3;
                throw row3;
            }
            finally {
                if (dataSet2 != null) {
                    if (object2 != null) {
                        try {
                            dataSet2.close();
                        }
                        catch (Throwable row3) {
                            ((Throwable)object2).addSuppressed(row3);
                        }
                    } else {
                        dataSet2.close();
                    }
                }
            }
            for (DynamicObject malOrder : rows) {
                BigDecimal taxamount = (BigDecimal)this.getFieldValue(malOrder, "entryentity.taxamount", taxamountMap);
                BigDecimal returnamount = (BigDecimal)this.getFieldValue(malOrder, "entryentity.returnamount", returnamountMap);
                this.setFieldValue(malOrder, "entryentity.amount", taxamount.subtract(returnamount), amountMap);
            }
        }

        private void setFieldValue(DynamicObject malOrder, String property, Object value, Map<Long, Object> valueMap) {
            if (malOrder.getDynamicObjectType().getProperties().containsKey((Object)property)) {
                malOrder.set(property, value);
            } else {
                valueMap.put(malOrder.getLong("entryentity.id"), value);
            }
        }

        private Object getFieldValue(DynamicObject malOrder, String property, Map<Long, Object> valueMap) {
            if (malOrder.getDynamicObjectType().getProperties().containsKey((Object)property)) {
                return malOrder.get(property);
            }
            return valueMap.get(malOrder.getLong("entryentity.id"));
        }
    }
}

