/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pmm.opplugin.validator.PmmCategoryUnionSaveValidator;

public class PmmCategoryUnionSaveOp
extends AbstractOperationServicePlugIn {
    private Set<Long> ecIds = new HashSet<Long>(16);
    private Set<Long> selfIds = new HashSet<Long>(16);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("ecclass.id");
        e.getFieldKeys().add("ecclass.number");
        e.getFieldKeys().add("ecclass.status");
        e.getFieldKeys().add("ecclass.enable");
        e.getFieldKeys().add("ecclass.level");
        e.getFieldKeys().add("selfclass.id");
        e.getFieldKeys().add("selfclass.number");
        e.getFieldKeys().add("selfclass.name");
        e.getFieldKeys().add("selfclass.status");
        e.getFieldKeys().add("selfclass.enable");
        e.getFieldKeys().add("selfclass.level");
        e.getFieldKeys().add("platform");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PmmCategoryUnionSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject info : dataEntities) {
            if (0L == info.getLong("id")) continue;
            idSet.add(info.getLong("id"));
        }
        if (idSet.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", idSet);
            DynamicObjectCollection pmm_categoryunion = QueryServiceHelper.query((String)"pmm_categoryunion", (String)"ecclass.id,selfclass.id", (QFilter[])qFilter.toArray());
            for (DynamicObject info : pmm_categoryunion) {
                this.ecIds.add(info.getLong("ecclass.id"));
                this.selfIds.add(info.getLong("selfclass.id"));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        this.doUnionBySelfClass(e);
        this.updateClassMapping(e);
        this.updateClassBlank(e);
    }

    private void doUnionBySelfClass(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> selfClassIds = new HashSet<Long>(16);
        HashSet<Long> ecClassIds = new HashSet<Long>(16);
        HashSet<Long> unionIds = new HashSet<Long>(16);
        HashMap<Long, Long> ec_selfClassMap = new HashMap<Long, Long>(16);
        for (DynamicObject info : dataEntities) {
            DynamicObjectCollection mulecclass = info.getDynamicObjectCollection("mulecclass");
            if (mulecclass.size() <= 0) continue;
            selfClassIds.add(info.getLong("selfclass.id"));
            ecClassIds.add(info.getLong("ecclass.id"));
            unionIds.add(info.getLong("id"));
            for (DynamicObject row : mulecclass) {
                DynamicObject fbasedataid = row.getDynamicObject("fbasedataid");
                ec_selfClassMap.put(fbasedataid.getLong("id"), info.getLong("selfclass.id"));
            }
        }
        if (selfClassIds.size() > 0) {
            QFilter qFilter = new QFilter("selfclass.id", "in", selfClassIds);
            DynamicObjectCollection pmmCategoryunion = QueryServiceHelper.query((String)"pmm_categoryunion", (String)"id,selfclass.id,ecclass.id", (QFilter[])qFilter.toArray());
            HashSet<Long> deleteIds = new HashSet<Long>(16);
            HashSet<Long> existEcClassIds = new HashSet<Long>(16);
            HashMap<Long, Long> ec_selfClassAddMap = new HashMap<Long, Long>(16);
            for (DynamicObject row : pmmCategoryunion) {
                long ecclassId = row.getLong("ecclass.id");
                long selfclassId = row.getLong("selfclass.id");
                if (null == ec_selfClassMap.get(ecclassId) || (Long)ec_selfClassMap.get(ecclassId) != selfclassId) {
                    deleteIds.add(row.getLong("id"));
                    ec_selfClassAddMap.put(ecclassId, (Long)ec_selfClassMap.get(ecclassId));
                } else {
                    existEcClassIds.add(ecclassId);
                }
                if (!ecClassIds.contains(ecclassId) || unionIds.contains(row.getLong("id"))) continue;
                deleteIds.add(row.getLong("id"));
            }
            this.doDeleteCategoryUnion(deleteIds);
            this.doAddCategoryUnion(ec_selfClassMap, ec_selfClassAddMap, existEcClassIds);
        }
    }

    private void doAddCategoryUnion(Map<Long, Long> ec_selfClassMap, Map<Long, Long> ec_selfClassAddMap, Set<Long> existEcClassIds) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        HashSet<Long> allClassIds = new HashSet<Long>(16);
        for (Map.Entry<Long, Long> map : ec_selfClassMap.entrySet()) {
            if (existEcClassIds.contains(map.getKey())) continue;
            ec_selfClassAddMap.put(map.getKey(), map.getValue());
            allClassIds.add(map.getKey());
            allClassIds.add(map.getValue());
        }
        if (ec_selfClassAddMap.size() > 0 && allClassIds.size() > 0) {
            QFilter qFilter1 = new QFilter("id", "in", allClassIds);
            DynamicObject[] mdr_goodsclasses = BusinessDataServiceHelper.load((String)"mdr_goodsclass", (String)"status,enable,level,standard,number,id", (QFilter[])qFilter1.toArray());
            HashMap<Long, DynamicObject> goodsClassMap = new HashMap<Long, DynamicObject>(16);
            HashSet<Long> standardIds = new HashSet<Long>(16);
            for (DynamicObject info : mdr_goodsclasses) {
                goodsClassMap.put(info.getLong("id"), info);
                standardIds.add(info.getLong("standard.id"));
            }
            DynamicObjectCollection standardDyos = this.getStandardDyos(standardIds);
            HashMap<Long, String> platFormMap = new HashMap<Long, String>(16);
            for (DynamicObject standRow : standardDyos) {
                platFormMap.put(standRow.getLong("standard.id"), standRow.getString("platform"));
            }
            ArrayList<DynamicObject> newObjects = new ArrayList<DynamicObject>(16);
            ORM orm = ORM.create();
            for (Map.Entry<Long, Long> map : ec_selfClassAddMap.entrySet()) {
                DynamicObject dynamicObject = this.getCategoryUnion(orm);
                DynamicObject ecDyn = (DynamicObject)goodsClassMap.get(map.getKey());
                if (null == ecDyn) continue;
                long standardId = ecDyn.getLong("standard.id");
                dynamicObject.set("ecclass", goodsClassMap.get(map.getKey()));
                dynamicObject.set("selfclass", goodsClassMap.get(map.getValue()));
                dynamicObject.set("platform", platFormMap.get(standardId));
                dynamicObject.set("creator_id", (Object)RequestContext.get().getCurrUserId());
                newObjects.add(dynamicObject);
            }
            OperationResult saveResullt = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_categoryunion", (DynamicObject[])newObjects.toArray(new DynamicObject[0]), (OperateOption)option);
            if (!saveResullt.isSuccess()) {
                throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)saveResullt.getAllErrorOrValidateInfo()));
            }
        }
    }

    private DynamicObject getCategoryUnion(ORM orm) {
        return orm.newDynamicObject("pmm_categoryunion");
    }

    private void doDeleteCategoryUnion(Set<Long> deleteIds) {
        OperationResult deleteResullt;
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        if (deleteIds.size() > 0 && !(deleteResullt = OperationServiceHelper.executeOperate((String)"delete", (String)"pmm_categoryunion", (Object[])deleteIds.toArray(new Object[0]), (OperateOption)option)).isSuccess()) {
            throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)deleteResullt.getAllErrorOrValidateInfo()));
        }
    }

    private DynamicObjectCollection getStandardDyos(Set<Long> stardIds) {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("openstatus", "=", (Object)"2").and(new QFilter("tenantid", "=", (Object)RequestContext.getOrCreate().getTenantId())));
        qFilter.and(new QFilter("standard.id", "in", stardIds));
        return QueryServiceHelper.query((String)"pmm_ecadmit", (String)"id,number,name,platform,standard.id,standard.number,standard.name", (QFilter[])new QFilter[]{qFilter}, (String)"platform desc");
    }

    private void updateClassBlank(AfterOperationArgs e) {
        QFilter qFilter = new QFilter("ecclass.id", "in", this.ecIds);
        qFilter.or(new QFilter("selfclass.id", "in", this.selfIds));
        DynamicObjectCollection pmm_categoryunion = QueryServiceHelper.query((String)"pmm_categoryunion", (String)"ecclass.id,selfclass.id", (QFilter[])qFilter.toArray());
        HashSet<Long> tarEcIds = new HashSet<Long>(16);
        HashSet<Long> tarSelfIds = new HashSet<Long>(16);
        for (DynamicObject info : pmm_categoryunion) {
            tarEcIds.add(info.getLong("ecclass.id"));
            tarSelfIds.add(info.getLong("selfclass.id"));
        }
        HashSet<Long> allUpdateClassIds = new HashSet<Long>(16);
        HashMap<Long, String> classMap = new HashMap<Long, String>(16);
        Set<Long> ecDiffIdSet = this.getDiffIdSet(this.ecIds, tarEcIds);
        allUpdateClassIds.addAll(ecDiffIdSet);
        for (Long id : ecDiffIdSet) {
            classMap.put(id, null);
        }
        Set<Long> selfDiffIdSet = this.getDiffIdSet(this.selfIds, tarSelfIds);
        allUpdateClassIds.addAll(selfDiffIdSet);
        String msg = ResManager.loadKDString((String)"\u5df2\u5bf9\u5e94", (String)"PmmCategoryUnionSaveOp_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
        for (Long id : selfDiffIdSet) {
            classMap.put(id, msg);
        }
        this.updateClass(allUpdateClassIds, classMap);
    }

    private void updateClass(Set<Long> allClassIds, Map<Long, String> classMap) {
        DynamicObject[] dysArr;
        QFilter qFilter = new QFilter("id", "in", allClassIds);
        for (DynamicObject dys : dysArr = BusinessDataServiceHelper.load((String)"mdr_goodsclass", (String)"id,selfclassification", (QFilter[])qFilter.toArray())) {
            dys.set("selfclassification", (Object)classMap.get(dys.getLong("id")));
        }
        SaveServiceHelper.save((DynamicObject[])dysArr);
    }

    private Set<Long> getDiffIdSet(Set<Long> ecIds, Set<Long> tarEcIds) {
        HashSet<Long> diffIdSet = new HashSet<Long>(16);
        for (long classId : ecIds) {
            if (tarEcIds.contains(classId)) continue;
            diffIdSet.add(classId);
        }
        return diffIdSet;
    }

    private void updateClassMapping(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> allClassIds = new HashSet<Long>(16);
        HashMap<Long, String> classMap = new HashMap<Long, String>(16);
        String msg = ResManager.loadKDString((String)"\u5df2\u5bf9\u5e94", (String)"PmmCategoryUnionSaveOp_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
        for (DynamicObject info : dataEntities) {
            allClassIds.add(info.getLong("ecclass.id"));
            classMap.put(info.getLong("ecclass.id"), info.getString("selfclass.name"));
            allClassIds.add(info.getLong("selfclass.id"));
            classMap.put(info.getLong("selfclass.id"), msg);
        }
        this.updateClass(allClassIds, classMap);
    }
}

