/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.ecapi.jd.JDAccessTokenUtil;
import kd.scm.common.util.AESUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.pmm.opplugin.validator.PmmEcadmitSaveValidator;
import net.sf.json.JSONObject;

public class PmmEcadmitSaveOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PmmEcadmitSaveOp.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    private static final String TENANTID = "tenantid";
    private static final String PLATFORM = "platform";
    private static final String ENTRY_MALLACCOUNT = "mallaccount";
    private static final String ENTRY_MALL_MA = "mallpwd";
    private static final String ENTRY_DATE = "uneffectualdate";
    private static final String ENTRY_TOKEN = "token";
    private static final String ENTRY_COMPANYORG = "companyorg";
    private static final String STATUS = "status";
    private static final String ISC_DATABASE_LINK = "isc_database_link";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add(PLATFORM);
        fieldKeys.add(TENANTID);
        fieldKeys.add(STATUS);
        fieldKeys.add("invoiceorgcode");
        fieldKeys.add("emalemail");
        fieldKeys.add("initconfig");
        fieldKeys.add(ENTRY_ENTITY);
        fieldKeys.add("entryentity.mallaccount");
        fieldKeys.add("entryentity.mallpwd");
        fieldKeys.add("entryentity.companyorg");
        fieldKeys.add("entryentity.seq");
        fieldKeys.add("entryentity.uneffectualdate");
        fieldKeys.add("entryentity.token");
        fieldKeys.add("entryentity.client_id");
        fieldKeys.add("entryentity.client_secret");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PmmEcadmitSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        DynamicObject[] dataEntities;
        for (DynamicObject dynamicObject : dataEntities = beginOperationTransactionArgs.getDataEntities()) {
            dynamicObject.set(STATUS, (Object)"C");
            dynamicObject.set(TENANTID, (Object)RequestContext.getOrCreate().getTenantId());
            String platform = dynamicObject.getString(PLATFORM);
            if (!"2".equals(platform) && !"7".equals(platform) || !"2".equals(dynamicObject.getString("openstatus"))) continue;
            JDAccessTokenUtil.clearCache();
            this.getJDToken(dynamicObject, beginOperationTransactionArgs);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            String platform = dynamicObject.getString(PLATFORM);
            if (!MalOrderUtil.getDefaultMalVersion()) continue;
            this.updateIscDatabaseLink(platform, dynamicObject);
        }
    }

    private void getJDToken(DynamicObject dynamicObject, BeginOperationTransactionArgs beginOperationTransactionArgs) {
        String tenantId = RequestContext.getOrCreate().getTenantId();
        String clientId = dynamicObject.getString(CLIENT_ID);
        String secret = dynamicObject.getString(CLIENT_SECRET);
        dynamicObject.set(TENANTID, (Object)tenantId);
        boolean flag = MalOrderUtil.getDefaultMalVersion();
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        StringBuilder logString = new StringBuilder();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            String userName = entry.getString(ENTRY_MALLACCOUNT);
            String pwStr = entry.getString(ENTRY_MALL_MA);
            try {
                pwStr = AESUtil.decryptToStringNew((String)pwStr);
                String tokenJson = JDAccessTokenUtil.getJDTokenJSON((String)userName, (String)pwStr, (String)tenantId, (String)clientId, (String)secret);
                logString.append("tokenJson:").append("@@@kd.scm.pmm.opplugin.PmmEcadmitSaveOp.getJDToken:getAuthorizationInfoJson\uff1a").append(tokenJson).append("\n");
                JSONObject node = JSONObject.fromObject((Object)tokenJson);
                if (node.getString("success").equals("true")) {
                    JSONObject rs = node.getJSONObject("result");
                    String refreshToken = rs.optString("refresh_token");
                    long expriDate = Long.parseLong(rs.optString("refresh_token_expires"));
                    entry.set(ENTRY_DATE, (Object)new Date(expriDate));
                    entry.set(ENTRY_TOKEN, (Object)refreshToken);
                    if (!flag) {
                        dynamicObject.set("openstatus", (Object)"2");
                    }
                    continue;
                }
                String msg = node.getString("resultMessage");
                log.info("@@@kd.scm.pmm.opplugin.PmmEcadmitSaveOp.getJDToken\u83b7\u53d6\u6388\u6743\u4fe1\u606f\u5931\u8d25,\u5931\u8d25\u539f\u56e0:" + msg);
                throw new KDBizException(msg);
            }
            catch (Exception e) {
                log.warn("@@@kd.scm.pmm.opplugin.PmmEcadmitSaveOp.getJDToken\u83b7\u53d6\u6388\u6743\u4fe1\u606f\u5931\u8d25,\u5931\u8d25\u539f\u56e0;" + ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
        log.info(logString.toString());
    }

    private void updateIscDatabaseLink(String platform, DynamicObject dynamicObject) {
        DynamicObject config = dynamicObject.getDynamicObject("initconfig");
        if (config == null) {
            log.info("@@@initconfig\u4e3a\u7a7a");
            return;
        }
        long dataSourceId = config.getLong("datasource.id");
        if (dataSourceId == 0L) {
            log.info("@@@kd.scm.pmm.opplugin.PmmEcadmitSaveOp.updateIscDatabaseLink\u5bf9\u5e94\u8fde\u63a5\u5668\u914d\u7f6e\u672a\u627e\u5230:dataSourceId\u4e3a" + dataSourceId);
            return;
        }
        DynamicObject linkDyo = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)ISC_DATABASE_LINK);
        if (linkDyo == null) {
            log.info("@@@kd.scm.pmm.opplugin.PmmEcadmitSaveOp.updateIscDatabaseLink\u5bf9\u5e94\u8fde\u63a5\u5668\u914d\u7f6e\u672a\u627e\u5230:dataSourceId\u4e3a" + dataSourceId);
            return;
        }
        linkDyo.set("appid", dynamicObject.get(CLIENT_ID));
        linkDyo.set("appsecret", dynamicObject.get(CLIENT_SECRET));
        linkDyo.set("appsecret_new", dynamicObject.get(CLIENT_SECRET));
        DynamicObject entry = (DynamicObject)dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY).get(0);
        if (entry != null) {
            linkDyo.set("user", (Object)entry.getString(ENTRY_MALLACCOUNT));
            String pwStr = "";
            try {
                pwStr = AESUtil.decryptToStringNew((String)entry.getString(ENTRY_MALL_MA));
            }
            catch (Exception exception) {
                pwStr = entry.getString(ENTRY_MALL_MA);
                log.warn(exception.getMessage(), (Throwable)exception);
            }
            linkDyo.set("password", (Object)pwStr);
            linkDyo.set("newpwd", (Object)pwStr);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)ISC_DATABASE_LINK, (DynamicObject[])new DynamicObject[]{linkDyo}, (OperateOption)option);
        if (!saveResult.isSuccess()) {
            log.info("@@@kd.scm.pmm.opplugin.PmmEcadmitSaveOp.handleAuth\u4fdd\u5b58\u96c6\u6210\u4e91\u8fde\u63a5\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo()));
            return;
        }
    }
}

