/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pmm.business.service.impl.ProdPoolCommandServiceImpl;
import kd.scm.pmm.opplugin.validator.PmmGoodsBarcodeValidator;

public class PmmGoodsSaveOp
extends AbstractOperationServicePlugIn {
    private static final String PMM_PRODMATMAPPING = "pmm_prodmatmapping";
    private static final String CATEGORY = "category";
    private static final String PRODMATMAPPING = "prodmatmapping";
    private static final String PRODMATMAPPINGSTATUS = "prodmatmappingstatus";
    private static final String PRODMATMAPPINGTYPE = "prodmatmappingtype";
    private static final String MATERIALMAPPINGYES = "1";
    private static final String MATERIALMAPPINGNO = "0";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("content");
        e.getFieldKeys().add("specification");
        e.getFieldKeys().add("taxprice");
        e.getFieldKeys().add(PRODMATMAPPING);
        e.getFieldKeys().add(PRODMATMAPPINGSTATUS);
        e.getFieldKeys().add(PRODMATMAPPINGTYPE);
        e.getFieldKeys().add("barcode");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add(CATEGORY);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> cateDynList = new ArrayList<Long>();
        HashMap updateMappingDyn = new HashMap();
        for (DynamicObject dynamicObject : dataEntities) {
            List<DynamicObject> dynamicObjects;
            if (dynamicObject.get("taxprice") == null) {
                dynamicObject.set("taxprice", (Object)BigDecimal.ZERO);
            }
            if (!StringUtils.isBlank((CharSequence)dynamicObject.getString(PRODMATMAPPINGTYPE))) continue;
            Long categoryPkValue = 0L;
            if (dynamicObject.get(CATEGORY) instanceof DynamicObject) {
                DynamicObject category = dynamicObject.getDynamicObject(CATEGORY);
                categoryPkValue = (Long)category.getPkValue();
            } else {
                categoryPkValue = dynamicObject.getLong(CATEGORY);
            }
            cateDynList.add(categoryPkValue);
            if (updateMappingDyn.containsKey(categoryPkValue)) {
                dynamicObjects = (List)updateMappingDyn.get(categoryPkValue);
                dynamicObjects.add(dynamicObject);
                continue;
            }
            dynamicObjects = new ArrayList();
            ((ArrayList)dynamicObjects).add(dynamicObject);
            updateMappingDyn.put(categoryPkValue, dynamicObjects);
        }
        DynamicObjectCollection cateGoryMapping = this.getCateGoryMapping(cateDynList);
        for (DynamicObject dynamicObject : cateGoryMapping) {
            List dynamicObjects = (List)updateMappingDyn.get(dynamicObject.getLong(CATEGORY));
            if (null == dynamicObjects) continue;
            for (DynamicObject dyn : dynamicObjects) {
                dyn.set(PRODMATMAPPING, (Object)dynamicObject.getLong("id"));
                dyn.set(PRODMATMAPPINGSTATUS, (Object)MATERIALMAPPINGYES);
                dyn.set(PRODMATMAPPINGTYPE, (Object)CATEGORY);
            }
            updateMappingDyn.remove(dynamicObject.getLong(CATEGORY));
        }
        for (Map.Entry longArrayListEntry : updateMappingDyn.entrySet()) {
            List value = (List)longArrayListEntry.getValue();
            for (DynamicObject dynamicObject : value) {
                dynamicObject.set(PRODMATMAPPINGSTATUS, (Object)MATERIALMAPPINGNO);
            }
        }
    }

    private DynamicObjectCollection getCateGoryMapping(List<Long> cateDyn) {
        QFilter[] qFilters = new QFilter[]{new QFilter(CATEGORY, "in", cateDyn)};
        DynamicObjectCollection prodmatmapping = QueryServiceHelper.query((String)PMM_PRODMATMAPPING, (String)"id,category", (QFilter[])qFilters);
        return prodmatmapping;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        if (objs != null && objs[0] != null) {
            if (objs[0].get("content_tag") != null && StringUtils.isEmpty((CharSequence)((String)objs[0].get("content_tag")))) {
                objs[0].set("content_tag", objs[0].get("content"));
            }
            if (objs[0].get("specification_tag") != null && StringUtils.isEmpty((CharSequence)((String)objs[0].get("specification_tag")))) {
                objs[0].set("specification_tag", objs[0].get("specification"));
            }
            objs[0].set("content", (Object)"");
            objs[0].set("specification", (Object)"");
        }
        e.addValidator((AbstractValidator)new PmmGoodsBarcodeValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> productIds = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            productIds.add(dataEntity.getLong("id"));
        }
        ProdPoolCommandServiceImpl prodPoolCommandService = new ProdPoolCommandServiceImpl();
        List prodPoolDynList = prodPoolCommandService.addNoProtocolProdPool(productIds);
        prodPoolCommandService.auditProdPool(prodPoolDynList);
        prodPoolCommandService.deleteProdPoolRelation(productIds);
        this.batchUpdateSku(dataEntities);
    }

    private void batchUpdateSku(DynamicObject[] dataEntities) {
        HashSet<String> spuNos = new HashSet<String>(16);
        HashMap<Long, DynamicObject> goodsMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dyn : dataEntities) {
            if (!StringUtils.isEmpty((CharSequence)dyn.getString("spunumber")) && dyn.getBoolean("mulmodel")) {
                spuNos.add(dyn.getString("spunumber"));
            }
            goodsMap.put(dyn.getLong("id"), dyn);
        }
        if (spuNos.size() > 0) {
            DynamicObject[] spus;
            QFilter qFilter = new QFilter("number", "in", spuNos);
            String selectors = "id";
            selectors = DynamicObjectUtil.getEntrySelectfields((String)selectors, (String)"pmm_spu", (String)"spuskumapentry", (boolean)false);
            for (DynamicObject spu : spus = BusinessDataServiceHelper.load((String)"pmm_spu", (String)selectors, (QFilter[])qFilter.toArray())) {
                DynamicObjectCollection spuskumapentry = spu.getDynamicObjectCollection("spuskumapentry");
                for (DynamicObject row : spuskumapentry) {
                    long goodIds;
                    DynamicObject goods = row.getDynamicObject("goods");
                    if (null == row.getDynamicObject("goods") || null == goodsMap.get(goodIds = goods.getLong("id"))) continue;
                    this.updateSpuGoodsEntryFields(row, (DynamicObject)goodsMap.get(goodIds));
                }
            }
            if (spus.length > 0) {
                SaveServiceHelper.save((DynamicObject[])spus);
            }
        }
    }

    private void updateSpuGoodsEntryFields(DynamicObject row, DynamicObject goods) {
        Map prodMap = DynamicObjectUtil.getDifferDynamicProperties((DynamicObject)goods);
        List allProdProsList = (List)prodMap.get("allProList");
        Map allSpuProsMap = DynamicObjectUtil.getDifferDynamicProperties((DynamicObject)row);
        List allSpuEntryProsList = (List)allSpuProsMap.get("allProList");
        for (String pro : allSpuEntryProsList) {
            if ("skunumber".equals(pro) && StringUtils.isEmpty((CharSequence)row.getString(pro))) continue;
            if (allProdProsList.contains(pro)) {
                row.set(pro, goods.get(pro));
            }
            row.set("skuname", goods.get("name"));
        }
    }
}

