/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pmm.opplugin.validator.PmmGoodsUnAuditValidator;

public class PmmGoodsUnAuditOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PmmGoodsUnAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("auditor");
        fieldKeys.add("auditdate");
        fieldKeys.add("number");
        fieldKeys.add("origin");
        fieldKeys.add("spunumber");
        fieldKeys.add("protocolentry.prodpool");
        fieldKeys.add("protocolentry.prodpool.mallstatus");
        fieldKeys.add("protocolentry.protocol");
        fieldKeys.add("spunumber");
        fieldKeys.add("mulmodel");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PmmGoodsUnAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            dataEntity.set("auditor", null);
            dataEntity.set("auditdate", null);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String source;
        this.deleteProdPoolRelation(e.getDataEntities());
        DynamicObject[] dataEntities = e.getDataEntities();
        OperateOption option = this.getOption();
        if (option.containsVariable("batchspulinkgoods") && Boolean.parseBoolean(source = option.getVariableValue("batchspulinkgoods"))) {
            this.batchSubmitSkuBySpuNumber(dataEntities);
        }
    }

    private void batchSubmitSkuBySpuNumber(DynamicObject[] dataEntities) {
        HashSet<String> spuNos = new HashSet<String>(16);
        HashSet<Long> removeIds = new HashSet<Long>(16);
        for (DynamicObject dyn : dataEntities) {
            if (!StringUtils.isEmpty((CharSequence)dyn.getString("spunumber")) && dyn.getBoolean("mulmodel")) {
                spuNos.add(dyn.getString("spunumber"));
            }
            removeIds.add(dyn.getLong("id"));
        }
        if (spuNos.size() > 0) {
            QFilter qFilter = new QFilter("number", "in", spuNos);
            String selectors = "spuskumapentry.goods.status,spuskumapentry.goods.id";
            DynamicObjectCollection spus = QueryServiceHelper.query((String)"pmm_spu", (String)selectors, (QFilter[])qFilter.toArray());
            HashSet<Long> goodsIds = new HashSet<Long>(16);
            for (DynamicObject row : spus) {
                String status = row.getString("spuskumapentry.goods.status");
                long goodIds = row.getLong("spuskumapentry.goods.id");
                if (!"C".equals(status) || removeIds.contains(goodIds)) continue;
                goodsIds.add(goodIds);
            }
            if (goodsIds.size() > 0) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                option.setVariableValue("mulmodel", String.valueOf(false));
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"pmm_prodmanage", (Object[])goodsIds.toArray(), (OperateOption)option);
                if (!submitResult.isSuccess()) {
                    log.info(ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo()));
                }
            }
        }
    }

    private void deleteProdPoolRelation(DynamicObject[] dataEntities) {
        DynamicObject[] prodPools;
        HashSet<Long> prodPoolAndProdMap = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dynamicObject : dataEntities) {
            DynamicObjectCollection protocolEntry = dynamicObject.getDynamicObjectCollection("protocolentry");
            for (DynamicObject entry : protocolEntry) {
                prodPoolAndProdMap.add(entry.getDynamicObject("prodpool").getLong("id"));
            }
        }
        for (DynamicObject prodPool : prodPools = BusinessDataServiceHelper.load((String)"pmm_prodpool", (String)"id,goods", (QFilter[])new QFilter[]{new QFilter("id", "in", prodPoolAndProdMap)})) {
            prodPool.set("goods", null);
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])prodPools);
    }
}

