/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;

public class PmmPackageSelectionImportOp
extends BatchImportPlugin {
    protected boolean isForceBatch() {
        return true;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Iterator<ImportBillData> iterator = billdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData billdata = iterator.next();
            JSONObject data = billdata.getData();
            if (Objects.isNull(data)) continue;
            StringBuilder msg = this.checkImportValid(billdata);
            if (msg.toString().length() > 0) {
                logger.log((Integer)data.getObject("rowNum", Integer.class), msg.toString());
                logger.fail();
                iterator.remove();
                continue;
            }
            JSONObject createorg = (JSONObject)data.getObject("createorg", JSONObject.class);
            boolean validEntryResult = this.validEntrys(data, logger, createorg);
            if (validEntryResult) continue;
            logger.fail();
            iterator.remove();
        }
    }

    private boolean validEntrys(JSONObject data, ImportLogger logger, JSONObject org) {
        List entryentity = (List)data.getObject("entryentity", List.class);
        DynamicObjectCollection selfGoodsEntryCol = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)org.getString("number")), new QFilter("fispurchase", "=", (Object)true)});
        if (!CollectionUtils.isEmpty((Collection)entryentity)) {
            JSONObject goods = null;
            String source = null;
            boolean isprimary = false;
            Iterator entryIts = entryentity.iterator();
            ArrayList<String> mallgoodsList = new ArrayList<String>(entryentity.size());
            ArrayList<String> prodmanageList = new ArrayList<String>(entryentity.size());
            while (entryIts.hasNext()) {
                JSONObject entry = (JSONObject)entryIts.next();
                goods = entry.getJSONObject("goods");
                if (goods == null) {
                    logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u201c\u5546\u54c1\u7f16\u7801\u201d\u4e3a\u7a7a\uff0c\u8be5\u884c\u4e0d\u5f15\u5165\u3002", (String)"PmmPackageSelectionImportOp_2", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                    return false;
                }
                source = entry.getString("source");
                if (source == null) {
                    logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u201c\u5546\u54c1\u6765\u6e90\u201d\u4e3a\u7a7a\uff0c\u8be5\u884c\u4e0d\u5f15\u5165\u3002", (String)"PmmPackageSelectionImportOp_8", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                    return false;
                }
                if ("pmm_prodmanage".equals(source)) {
                    prodmanageList.add(goods.getString("number"));
                } else if ("pbd_mallgoods".equals(source)) {
                    mallgoodsList.add(goods.getString("number"));
                } else {
                    logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u201c\u5546\u54c1\u6765\u6e90\u201d\u7684\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u540e\u5f15\u5165\u3002", (String)"PmmPackageSelectionImportOp_4", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                    return false;
                }
                if (CollectionUtils.isEmpty((Collection)selfGoodsEntryCol)) {
                    logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u8f93\u5165\u503c\u4e0d\u5408\u6cd5\uff0c\u8bf7\u68c0\u67e5\u540e\u5f15\u5165\u3002", (String)"PmmPackageSelectionImportOp_3", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                    return false;
                }
                BigDecimal qty = entry.getBigDecimal("qty");
                if (qty == null || BigDecimal.ZERO.compareTo(qty) >= 0) {
                    entry.put("qty", (Object)BigDecimal.ONE);
                } else {
                    qty = qty.setScale(0, 5);
                    entry.put("qty", (Object)qty);
                }
                if (isprimary && entry.getBooleanValue("isprimary")) {
                    logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u4e00\u4e2a\u91c7\u8d2d\u5957\u9910\u53ea\u80fd\u6709\u4e00\u4e2a\u4e3b\u5546\u54c1\uff0c\u8bf7\u68c0\u67e5\u540e\u5f15\u5165\u3002", (String)"PmmPackageSelectionImportOp_5", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                    return false;
                }
                if (!entry.getBooleanValue("isprimary")) continue;
                isprimary = true;
            }
            Map<String, DynamicObject> goodsMap = this.getGoodsMap(prodmanageList, mallgoodsList);
            for (JSONObject entry : entryentity) {
                JSONObject goodsmap;
                HashMap<String, Object> unitMap;
                source = entry.getString("source");
                goods = entry.getJSONObject("goods");
                if (goods == null) {
                    entryIts.remove();
                    continue;
                }
                String goodsnumber = goods.getString("number");
                if (!goodsMap.containsKey(goodsnumber)) {
                    logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u201c\u5546\u54c1\u7f16\u7801\u201d\u4e0d\u6b63\u786e\uff0c\u201c\u5546\u54c1\u6765\u6e90\u201d\u548c\u201c\u5546\u54c1\u7f16\u7801\u201d\u4e0d\u5339\u914d\u6216\u8005\u5728\u5f53\u524d\u7ec4\u7ec7\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u540e\u5f15\u5165\u3002", (String)"PmmPackageSelectionImportOp_6", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                    return false;
                }
                DynamicObject goodsdata = goodsMap.get(goodsnumber);
                if (prodmanageList.contains(goodsnumber) && goodsdata != null) {
                    if (goodsdata.getString("source") == null || !"1".equals(goodsdata.getString("source"))) {
                        logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u201c\u5546\u54c1\u6765\u6e90\u201d,\u201c\u5546\u54c1\u7f16\u7801\u201d\u548c\u201c\u5546\u5bb6\u201d\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u540e\u5f15\u5165\u3002", (String)"PmmPackageSelectionImportOp_7", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                        return false;
                    }
                    unitMap = new HashMap<String, Object>();
                    unitMap.put("importprop", "id");
                    unitMap.put("id", goodsdata.getLong("unitid"));
                    entry.put("unit", unitMap);
                    goodsmap = entry.getJSONObject("goods");
                    goodsmap.put("importprop", "id");
                    goodsmap.put("id", goodsdata.getLong("id"));
                    entry.put("goods", (Object)goodsmap);
                    entry.put("goodssupplier", (Object)goodsdata.getString("suppliername"));
                }
                if (!mallgoodsList.contains(goodsnumber)) continue;
                goodsdata = goodsMap.get(goodsnumber + entry.getString("goodssupplier"));
                if (goodsdata == null && StringUtils.isEmpty((CharSequence)entry.getString("goodssupplier"))) {
                    goodsdata = goodsMap.get(goodsnumber);
                }
                if (goodsdata == null || goodsdata.getString("source") != null && "1".equals(goodsdata.getString("source"))) {
                    logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u201c\u5546\u54c1\u6765\u6e90\u201d,\u201c\u5546\u54c1\u7f16\u7801\u201d\u548c\u201c\u5546\u5bb6\u201d\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u540e\u5f15\u5165\u3002", (String)"PmmPackageSelectionImportOp_7", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                    return false;
                }
                unitMap = new HashMap();
                unitMap.put("importprop", "id");
                unitMap.put("id", goodsdata.getLong("unitid"));
                entry.put("unit", unitMap);
                goodsmap = entry.getJSONObject("goods");
                goodsmap.put("importprop", "id");
                goodsmap.put("id", goodsdata.getLong("id"));
                entry.put("goods", (Object)goodsmap);
                String supplierName = null;
                if (StringUtils.isNotBlank((CharSequence)goodsdata.getString("supplier"))) {
                    supplierName = EcApiUtil.getMalName((String)goodsdata.getString("supplier"));
                }
                entry.put("goodssupplier", supplierName);
            }
        }
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u6240\u6709\u7684\u5206\u5f55\u6570\u636e\u90fd\u4e0d\u5408\u6cd5\uff0c\u4e0d\u80fd\u5f15\u5165", (String)"PmmPackageSelectionImportOp_9", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Map<String, DynamicObject> getGoodsMap(List<String> selfGoodsNumbers, List<String> ecGoodsNumbers) {
        HashMap<String, DynamicObject> goodsMap = new HashMap<String, DynamicObject>();
        if (!selfGoodsNumbers.isEmpty()) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("number", "in", selfGoodsNumbers));
            qFilters.add(new QFilter("source", "=", (Object)"1"));
            qFilters.add(new QFilter("status", "=", (Object)"C"));
            DynamicObjectCollection selfGoodsEntryCol = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,name,unit.id unitid ,unit.name,supplier.name suppliername,thumbnail,shopprice,number ,source", (QFilter[])qFilters.toArray(new QFilter[0]));
            for (DynamicObject selfGoodsEntry : selfGoodsEntryCol) {
                goodsMap.put(selfGoodsEntry.getString("number"), selfGoodsEntry);
            }
        }
        if (!ecGoodsNumbers.isEmpty()) {
            DynamicObjectCollection ecGoodsPriceEntryCol = QueryServiceHelper.query((String)"pbd_mallgoods", (String)"unitid.id unitid,id, number, null source ,source supplier,null as suppliername", (QFilter[])new QFilter[]{new QFilter("number", "in", ecGoodsNumbers)});
            for (DynamicObject malGoodsEntry : ecGoodsPriceEntryCol) {
                goodsMap.put(malGoodsEntry.getString("number") + malGoodsEntry.getString("supplier"), malGoodsEntry);
                goodsMap.put(malGoodsEntry.getString("number"), malGoodsEntry);
            }
        }
        return goodsMap;
    }

    private StringBuilder checkImportValid(ImportBillData data) {
        Map createOrgData = (Map)data.getData().get((Object)"createorg");
        Map nameData = (Map)data.getData().get((Object)"name");
        StringBuilder msg = new StringBuilder();
        if (nameData == null) {
            msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5957\u9910\u540d\u79f0\u201d\u3002", (String)"PmmPackageSelectionImportOp_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
        }
        if (createOrgData == null) {
            msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u3002", (String)"PmmPackageSelectionImportOp_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
        }
        return msg;
    }
}

